/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.tidePrediction;

import com.gargoylesoftware.htmlunit.AjaxController;
import com.gargoylesoftware.htmlunit.AlertHandler;
import com.gargoylesoftware.htmlunit.IncorrectnessListener;
import com.gargoylesoftware.htmlunit.NicelyResynchronizingAjaxController;
import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.ScriptException;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.html.DomElement;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.HTMLParserListener;
import com.gargoylesoftware.htmlunit.html.HtmlArea;
import com.gargoylesoftware.htmlunit.html.HtmlDivision;
import com.gargoylesoftware.htmlunit.html.HtmlMap;
import com.gargoylesoftware.htmlunit.html.HtmlOption;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.html.HtmlSelect;
import com.gargoylesoftware.htmlunit.html.HtmlTable;
import com.gargoylesoftware.htmlunit.html.HtmlTableBody;
import com.gargoylesoftware.htmlunit.javascript.JavaScriptErrorListener;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.logging.LogFactory;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.plugins.tidePrediction.Harbors;
import pt.lsts.neptus.plugins.tidePrediction.util.DateUtils;
import pt.lsts.neptus.util.bathymetry.TidePrediction;
import pt.lsts.neptus.util.bathymetry.TidePredictionFinder;

public class PtHydrographicWeb
extends TidePredictionFinder {
    private static final String INSTITUTO_HIDROGRAFICO_URL = "http://www.hidrografico.pt/previsao-mares.php";
    private final WebClient webClient;
    private final Harbors harbor;

    public PtHydrographicWeb(Harbors harbor) {
        this.harbor = harbor;
        this.predictions = null;
        this.webClient = new WebClient();
        this.webClient.setAjaxController((AjaxController)new NicelyResynchronizingAjaxController());
        LogFactory.getFactory().setAttribute("org.apache.commons.logging.Log", (Object)"org.apache.commons.logging.impl.NoOpLog");
        Logger.getLogger("com.gargoylesoftware.htmlunit").setLevel(Level.OFF);
        Logger.getLogger("org.apache.commons.httpclient").setLevel(Level.OFF);
        this.webClient.getOptions().setCssEnabled(false);
        this.webClient.setIncorrectnessListener(new IncorrectnessListener(){

            public void notify(String arg0, Object arg1) {
            }
        });
        this.webClient.setAlertHandler(new AlertHandler(){

            public void handleAlert(Page arg0, String arg1) {
            }
        });
        this.webClient.setJavaScriptErrorListener(new JavaScriptErrorListener(){

            public void timeoutError(HtmlPage arg0, long arg1, long arg2) {
            }

            public void scriptException(HtmlPage arg0, ScriptException arg1) {
            }

            public void malformedScriptURL(HtmlPage arg0, String arg1, MalformedURLException arg2) {
            }

            public void loadScriptError(HtmlPage arg0, URL arg1, Exception arg2) {
            }
        });
        this.webClient.setHTMLParserListener(new HTMLParserListener(){

            public void error(String arg0, URL arg1, String arg2, int arg3, int arg4, String arg5) {
            }

            public void warning(String arg0, URL arg1, String arg2, int arg3, int arg4, String arg5) {
            }
        });
        this.webClient.getOptions().setThrowExceptionOnFailingStatusCode(false);
        this.webClient.getOptions().setThrowExceptionOnScriptError(false);
    }

    public Float getTidePrediction(Date date, boolean print) throws Exception {
        if (this.predictions == null || this.predictions.size() < 2 || ((TidePrediction)this.predictions.get(0)).getTimeAndDate().compareTo(date) > 0 || ((TidePrediction)this.predictions.get(1)).getTimeAndDate().compareTo(date) < 0) {
            this.downloadPredictions(date);
        }
        Float prediction = this.findPrediction(date, 0);
        if (print) {
            NeptusLog.pub().info((Object)("<###>For " + date + " in " + this.harbor.toString()));
            NeptusLog.pub().info((Object)("<###> " + ((TidePrediction)this.predictions.get(0)).toString()));
            NeptusLog.pub().info((Object)("<###> " + ((TidePrediction)this.predictions.get(1)).toString()));
        }
        return prediction;
    }

    private void downloadPredictions(Date date) throws Exception {
        try {
            HtmlPage page = (HtmlPage)this.webClient.getPage(INSTITUTO_HIDROGRAFICO_URL);
            if (page == null) {
                this.logError(new Exception("Cannot get html page."));
            }
            this.setHarbor(page, this.harbor.getCoordinates(), this.webClient);
            this.setDate(page, date);
            this.predictions = this.findPredictions(page, date);
            this.webClient.closeAllWindows();
        }
        catch (Exception e) {
            this.logError(e);
            throw e;
        }
    }

    private HtmlPage setHarbor(HtmlPage page, String coordinatesHarbor, WebClient webClient) throws IOException, InterruptedException {
        HtmlMap map = (HtmlMap)page.getHtmlElementById(HTML_IDS.MAP_AREAS.getID());
        Iterable childAreas = map.getChildElements();
        for (DomElement htmlElement : childAreas) {
            HtmlArea tempArea = (HtmlArea)htmlElement;
            if (!tempArea.getCoordsAttribute().equals(coordinatesHarbor)) continue;
            HtmlPage resultPage = (HtmlPage)tempArea.click();
            return resultPage;
        }
        return null;
    }

    protected Page setDate(HtmlPage page, Date wantedDate) throws InterruptedException {
        Calendar cal = Calendar.getInstance();
        cal.setTime(wantedDate);
        HtmlSelect select = (HtmlSelect)page.getHtmlElementById(HTML_IDS.SELECT_DATE_DAY.getID());
        page = this.changeSelectedOption(select, cal.get(5) + "");
        StringBuilder newDate = new StringBuilder(((HtmlOption)select.getSelectedOptions().get(0)).asText());
        select = (HtmlSelect)page.getHtmlElementById(HTML_IDS.SELECT_DATE_MONTH.getID());
        String monthNumber = new SimpleDateFormat("M").format(wantedDate);
        page = this.changeSelectedOption(select, DateUtils.getMonthNameInPortuguese(Integer.parseInt(monthNumber)));
        newDate.append('-');
        newDate.append(((HtmlOption)select.getSelectedOptions().get(0)).asText());
        select = (HtmlSelect)page.getHtmlElementById(HTML_IDS.SELECT_DATE_YEAR.getID());
        page = this.changeSelectedOption(select, cal.get(1) + "");
        newDate.append('-');
        newDate.append(((HtmlOption)select.getSelectedOptions().get(0)).asText());
        return page;
    }

    private HtmlPage changeSelectedOption(HtmlSelect select, String newSelection) {
        List options = select.getOptions();
        for (HtmlOption htmlOption : options) {
            if (!htmlOption.asText().equals(newSelection)) continue;
            return (HtmlPage)select.setSelectedAttribute(htmlOption, true);
        }
        return null;
    }

    protected ArrayList<TidePrediction> findPredictions(HtmlPage page, Date date) throws InterruptedException, ParseException {
        HtmlDivision tideTableDiv = (HtmlDivision)page.getHtmlElementById(HTML_IDS.TIDES_TABLE.getID());
        DomNode dateHarbor = tideTableDiv.getFirstChild();
        DomNode tidePredictionsNode = dateHarbor.getNextSibling();
        HtmlTableBody tidePredictionsTableBody = (HtmlTableBody)((HtmlTable)tidePredictionsNode).getBodies().get(0);
        Iterator tableElementsIt = tidePredictionsTableBody.getChildElements().iterator();
        tableElementsIt.next();
        ArrayList<TidePrediction> predictions = new ArrayList<TidePrediction>(2);
        TidePrediction nextTide = null;
        TidePrediction lastTide = null;
        while (tableElementsIt.hasNext()) {
            TidePrediction tidePrediction;
            DomElement row = (DomElement)tableElementsIt.next();
            try {
                tidePrediction = this.buildTidePrediciton(row.getChildElements().iterator());
            }
            catch (ParseException e) {
                NeptusLog.pub().error((Object)"Unable to read a tide prediction from website.", (Throwable)e);
                break;
            }
            if (tidePrediction.getTimeAndDate().before(date) || tidePrediction.getTimeAndDate().equals(date)) {
                lastTide = tidePrediction;
                continue;
            }
            if (!tidePrediction.getTimeAndDate().after(date)) continue;
            nextTide = tidePrediction;
            break;
        }
        predictions.add(0, lastTide);
        predictions.add(1, nextTide);
        return predictions;
    }

    private TidePrediction buildTidePrediciton(Iterator<DomElement> tideInfo) throws ParseException {
        float height;
        DomElement next = tideInfo.next();
        String dateAndHour = next.getTextContent();
        Date timeAndDate = DateUtils.getDate(dateAndHour);
        next = tideInfo.next();
        String substring = next.getTextContent().substring(1);
        try {
            height = Float.parseFloat(substring);
        }
        catch (NumberFormatException e) {
            NeptusLog.pub().debug((Object)e.getMessage());
            next = tideInfo.next();
            substring = next.getTextContent().substring(1);
            height = Float.parseFloat(substring);
        }
        next = tideInfo.next();
        String tideTypeStr = next.getTextContent().substring(1);
        TidePrediction.TIDE_TYPE tideType = tideTypeStr.equals(TidePrediction.TIDE_TYPE.HIGH_TIDE.getPt()) ? TidePrediction.TIDE_TYPE.HIGH_TIDE : TidePrediction.TIDE_TYPE.LOW_TIDE;
        return new TidePrediction(height, timeAndDate, tideType);
    }

    private static enum HTML_IDS {
        SELECT_DATE_YEAR("seldateyear"),
        SELECT_DATE_MONTH("seldatemonth"),
        SELECT_DATE_DAY("seldateday"),
        DIV_WHOLE_UTILITY("divshow0"),
        MAP_AREAS("FPMap1"),
        TIDES_TABLE("divppd");

        private final String id;

        private HTML_IDS(String id) {
            this.id = id;
        }

        public String getID() {
            return this.id;
        }
    }
}

