/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.tidePrediction.gui;

import java.awt.Component;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.DefaultCellEditor;
import javax.swing.JFormattedTextField;
import javax.swing.JTable;
import javax.swing.text.DateFormatter;
import javax.swing.text.DefaultFormatterFactory;

class DateCellEditor
extends DefaultCellEditor {
    private static final long serialVersionUID = -2995449781104657808L;
    DateFormat formatter = new SimpleDateFormat("dd-MM-yyyy");

    public DateCellEditor() {
        super(new JFormattedTextField());
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        JFormattedTextField editor = (JFormattedTextField)super.getTableCellEditorComponent(table, value, isSelected, row, column);
        System.out.println("DateCellEditor getTableCellEditorComponent" + value);
        if (value instanceof Date) {
            editor.setFormatterFactory(new DefaultFormatterFactory(new DateFormatter(this.formatter)));
            editor.setHorizontalAlignment(0);
            editor.setValue(value);
            table.getModel().setValueAt(value, row, column);
        }
        return editor;
    }

    @Override
    public boolean stopCellEditing() {
        try {
            this.getCellEditorValue();
            return super.stopCellEditing();
        }
        catch (Exception ex) {
            return false;
        }
    }

    @Override
    public Object getCellEditorValue() {
        String str = (String)super.getCellEditorValue();
        if (str == null) {
            return null;
        }
        if (str.length() == 0) {
            return null;
        }
        System.out.print("DateCellEditor getCellEditorValue " + str + " --> ");
        try {
            Date value = this.formatter.parse(str);
            System.out.println(value.toString());
            return value;
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }
}

