/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.tidePrediction.gui;

import java.util.Calendar;
import java.util.Date;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.util.bathymetry.TidePrediction;

public class TideTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 3748803424658938532L;
    private final String label = "High tide (m)";
    private final Date startDate = new Date();
    private final Vector<TidePrediction> predictions = new Vector();

    public TideTableModel() {
        this.predictions.add(new TidePrediction(0.0f, this.startDate, TidePrediction.TIDE_TYPE.HIGH_TIDE));
        Calendar cal = Calendar.getInstance();
        cal.setTime(this.startDate);
        cal.add(11, 6);
        Date secondTide = cal.getTime();
        this.predictions.add(new TidePrediction(0.0f, secondTide, TidePrediction.TIDE_TYPE.HIGH_TIDE));
    }

    @Override
    public int getRowCount() {
        return this.predictions.size();
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (rowIndex == 0) {
            switch (columnIndex) {
                case 0: {
                    return this.startDate;
                }
                case 1: {
                    return "High tide (m)";
                }
            }
        } else {
            switch (columnIndex) {
                case 0: {
                    return this.predictions.get(rowIndex).getTimeAndDate();
                }
                case 1: {
                    return Float.valueOf(this.predictions.get(rowIndex).getHeight());
                }
            }
        }
        NeptusLog.pub().error((Object)("Case not covered in TideTableModel row:" + rowIndex + ", collumn:" + columnIndex));
        return null;
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return column != 1 || row != 0;
    }
}

