/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.tidePrediction.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import pt.lsts.neptus.NeptusLog;

public class DateUtils {
    public static Date getDate(String dateAndHour) throws ParseException {
        String[] split = dateAndHour.split(" ");
        String dateRegEx = "yyyy-MM-dd HH:mm";
        dateAndHour = split[1] + " " + split[2];
        SimpleDateFormat formatter = new SimpleDateFormat(dateRegEx);
        try {
            Date date = formatter.parse(dateAndHour);
            return date;
        }
        catch (ParseException e) {
            NeptusLog.pub().info((Object)("<###>The date " + dateAndHour + " is not compatible with " + dateRegEx));
            NeptusLog.pub().info((Object)("<###> " + e.getMessage()));
            throw e;
        }
    }

    public static String getMonthNameInPortuguese(int month) {
        switch (month) {
            case 1: {
                return "Janeiro";
            }
            case 2: {
                return "Fevereiro";
            }
            case 3: {
                return "Mar\u00e7o";
            }
            case 4: {
                return "Abril";
            }
            case 5: {
                return "Maio";
            }
            case 6: {
                return "Junho";
            }
            case 7: {
                return "Julho";
            }
            case 8: {
                return "Agosto";
            }
            case 9: {
                return "Setembro";
            }
            case 10: {
                return "Outubro";
            }
            case 11: {
                return "Novembro";
            }
            case 12: {
                return "Dezembro";
            }
        }
        throw new IllegalArgumentException("The month has to be betweeb 1 and 12, not " + month);
    }
}

