/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.echosounder;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import pt.lsts.imc.IMCMessage;
import pt.lsts.imc.SonarData;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.colormap.ColorMap;
import pt.lsts.neptus.colormap.ColorMapFactory;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.mra.MRAPanel;
import pt.lsts.neptus.mra.MRAProperties;
import pt.lsts.neptus.mra.importers.IMraLogGroup;
import pt.lsts.neptus.mra.visualizations.MRAVisualization;
import pt.lsts.neptus.plugins.NeptusProperty;
import pt.lsts.neptus.plugins.PluginDescription;
import pt.lsts.neptus.plugins.PluginUtils;
import pt.lsts.neptus.plugins.echosounder.EchoSounderMRARuler;
import pt.lsts.neptus.util.ImageUtils;

@PluginDescription(author="zp", active=false, name="Echo Sounder Analysis", icon="pt/lsts/neptus/plugins/echosounder/echosounder.png")
public class EchoSounderMRA
extends JPanel
implements MRAVisualization {
    private static final long serialVersionUID = 1L;
    protected IMraLogGroup source;
    protected MRAPanel mraPanel;
    @NeptusProperty
    public ColorMap colormap = ColorMapFactory.createJetColorMap();
    protected BufferedImage image = null;
    protected int imageWidth;
    protected int imageHeight;
    protected int maxRange;
    protected int minRange;
    private EchoSounderMRARuler ruler;

    public EchoSounderMRA(MRAPanel panel) {
        this.mraPanel = panel;
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                EchoSounderMRA.this.generateImage();
            }
        });
    }

    public boolean supportsVariableTimeSteps() {
        return true;
    }

    public Component getComponent(IMraLogGroup source, double timestep) {
        this.source = source;
        this.setLayout(new BorderLayout());
        this.getSonarDataValues();
        this.generateImage();
        this.ruler = new EchoSounderMRARuler(this);
        return this;
    }

    private void getSonarDataValues() {
        int c = 0;
        for (IMCMessage msg : this.source.getLsfIndex().getIterator("SonarData")) {
            if ((long)msg.getInteger("type") != SonarData.TYPE.ECHOSOUNDER.value()) continue;
            ++c;
            this.imageHeight = msg.getRawData("data").length;
            this.maxRange = msg.getInteger("max_range");
            this.minRange = msg.getInteger("min_range");
        }
        this.imageWidth = c;
    }

    public void generateImage() {
        NeptusLog.pub().info((Object)"<###>Generating Echo sounder image");
        this.image = ImageUtils.createCompatibleImage((int)this.imageWidth, (int)this.imageHeight, (int)1);
        Graphics2D g2d = (Graphics2D)this.image.getGraphics();
        int x = 0;
        for (IMCMessage msg : this.source.getLsfIndex().getIterator("SonarData")) {
            if ((long)msg.getInteger("type") != SonarData.TYPE.ECHOSOUNDER.value()) continue;
            int y = 0;
            for (byte b : msg.getRawData("data")) {
                this.image.setRGB(x, this.imageHeight - y - 1, this.colormap.getColor(new Byte(b).doubleValue() * 2.0 / 255.0).getRGB());
                ++y;
            }
            ++x;
        }
        x = 0;
        int prevX = 0;
        int prevY = 0;
        int j = this.source.getLsfIndex().getFirstMessageOfType(262);
        while (j != -1) {
            if (this.source.getLsfIndex().entityNameOf(j).equals("Echo Sounder")) {
                if (x >= this.imageWidth) break;
                double y = (double)this.imageHeight - (double)(500 / this.maxRange) * this.source.getLsfIndex().getMessage(j).getDouble("value") - 1.0;
                this.image.setRGB(x, (int)y, Color.BLACK.getRGB());
                if (x != 0) {
                    g2d.setColor(Color.BLACK);
                    g2d.drawLine(prevX, prevY, x, (int)y);
                    prevX = x;
                    prevY = (int)y;
                } else {
                    prevX = x;
                    prevY = (int)y;
                }
                ++x;
            }
            j = this.source.getLsfIndex().getNextMessageOfType(262, j);
        }
    }

    @Override
    public void paint(Graphics g) {
        NeptusLog.pub().info((Object)("<###> " + this.getWidth() + " " + this.getHeight()));
        g.drawImage(this.image, 21, 0, this.getWidth(), this.getHeight(), 0, 0, this.imageWidth, this.imageHeight, null);
        this.ruler.paintComponent(g);
    }

    public boolean canBeApplied(IMraLogGroup source) {
        return source.getLog("SonarData") != null && source.getLsfIndex().getEntityId("Echo Sounder") != 255;
    }

    public Double getDefaultTimeStep() {
        return MRAProperties.defaultTimestep;
    }

    public ImageIcon getIcon() {
        return ImageUtils.getScaledIcon((String)PluginUtils.getPluginIcon(this.getClass()), (int)16, (int)16);
    }

    @Override
    public String getName() {
        return I18n.text((String)PluginUtils.getPluginName(this.getClass()));
    }

    public MRAVisualization.Type getType() {
        return MRAVisualization.Type.VISUALIZATION;
    }

    public void onCleanup() {
        this.mraPanel = null;
    }

    public void onHide() {
    }

    public void onShow() {
    }
}

