/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.echosounder;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import javax.swing.JLabel;
import pt.lsts.neptus.plugins.echosounder.EchoSounderMRA;

public class EchoSounderMRARuler
extends JLabel {
    private static final long serialVersionUID = 1L;
    private EchoSounderMRA echoSounderMRA;
    public static final int RULER_WIDTH = 20;
    protected int maxValue;
    protected int minValue;
    private int rulerHeight;

    public EchoSounderMRARuler(EchoSounderMRA echoSounderMRA) {
        this.echoSounderMRA = echoSounderMRA;
        this.maxValue = echoSounderMRA.maxRange;
        this.minValue = echoSounderMRA.minRange;
    }

    @Override
    protected void paintComponent(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        this.rulerHeight = this.echoSounderMRA.getHeight() - 1;
        Rectangle drawRulerHere = new Rectangle(0, 0, 20, this.rulerHeight);
        g2d.setColor(Color.LIGHT_GRAY);
        g2d.fill(drawRulerHere);
        g2d.setFont(new Font("SansSerif", 0, 8));
        g2d.setColor(Color.BLACK);
        g2d.drawLine(0, 0, 0, this.rulerHeight);
        g2d.drawLine(20, 0, 20, this.rulerHeight);
        double stepRuler = (double)this.rulerHeight / (double)(this.maxValue - this.minValue);
        double step = 0.0;
        for (int i = 0; i <= this.maxValue; ++i) {
            if (i % 10 == 0) {
                g2d.drawLine(14, (int)step, 20, (int)step);
                if (i == this.minValue) {
                    g2d.drawString("" + i, 5, (int)step + 7);
                } else if (i == this.maxValue) {
                    g2d.drawString("" + i, 1, (int)step - 1);
                } else {
                    g2d.drawString("" + i, 1, (int)step + 3);
                }
            } else if (i % 5 == 0) {
                g2d.drawLine(15, (int)step, 20, (int)step);
            } else {
                g2d.drawLine(17, (int)step, 20, (int)step);
            }
            step += stepRuler;
        }
    }
}

