/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.echosounder;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.text.NumberFormat;
import javax.swing.JComponent;
import javax.swing.JPanel;
import pt.lsts.neptus.colormap.ColorMap;
import pt.lsts.neptus.colormap.ColorMapFactory;
import pt.lsts.neptus.util.GuiUtils;

public class MultibeamPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private BufferedImage bi;
    private BufferedImage aux;
    private int lastWidth = 0;
    private int lastHeight = 0;
    private int readingWidth = 3;
    private double[] vals = new double[0];
    protected ColorMap cmap = ColorMapFactory.createGreenRadarColorMap();
    private boolean paused = false;
    private double depth = 0.0;
    private NumberFormat format = GuiUtils.getNeptusDecimalFormat((int)1);
    private double bottomMargin = 25.0;
    private double range = 50.0;
    private String textToDisplay = null;
    private boolean showDepth = true;

    public MultibeamPanel() {
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                super.mousePressed(e);
                MultibeamPanel.this.paused = true;
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                super.mouseReleased(e);
                MultibeamPanel.this.paused = false;
            }
        });
    }

    public void updateBeams(double[] vals, double depth) {
        this.vals = vals;
        this.depth = depth;
        this.showDepth = !Double.isNaN(depth);
        this.repaint();
    }

    @Override
    public void paint(Graphics g) {
        if (this.bi == null || this.lastHeight != this.getHeight() || this.lastWidth != this.getWidth()) {
            this.bi = new BufferedImage(this.getWidth(), this.getHeight(), 1);
            this.aux = new BufferedImage(this.getWidth(), this.getHeight(), 1);
        }
        this.lastWidth = this.getWidth();
        this.lastHeight = this.getHeight();
        this.aux.getGraphics().drawImage(this.bi, 0, 0, this.getWidth() - this.readingWidth, this.getHeight(), this.readingWidth, 0, this.getWidth(), this.getHeight(), null);
        this.bi = this.aux;
        Graphics2D g2d = (Graphics2D)this.bi.getGraphics();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        double bottom = this.showDepth ? this.bottomMargin : 0.0;
        double yInc = ((double)this.getHeight() - bottom) / (double)this.vals.length;
        g2d.translate(this.getWidth() - this.readingWidth, 0);
        for (int i = 0; i < this.vals.length; ++i) {
            g2d.setColor(this.cmap.getColor(this.vals[this.vals.length - i - 1] * 4.0));
            Rectangle2D.Double rect = new Rectangle2D.Double(0.0, 0.0, i * this.getHeight() / this.vals.length, yInc);
            g2d.fill(rect);
            g2d.translate(0.0, yInc);
        }
        if (this.showDepth) {
            g2d.setColor(this.cmap.getColor(0.0));
            Rectangle2D.Double d = new Rectangle2D.Double(0.0, 0.0, this.readingWidth, this.bottomMargin);
            g2d.fill(d);
            g2d.setColor(this.cmap.getColor(1.0));
            d = new Rectangle2D.Double(0.0, this.depth / this.range * this.bottomMargin, this.readingWidth, this.readingWidth);
            g2d.fill(d);
        }
        if (!this.paused) {
            g.drawImage(this.bi, 0, 0, this);
            if (this.showDepth) {
                g.setColor(Color.yellow);
                g.drawString("altitude: " + this.format.format(this.depth) + "m", 2, (int)((double)this.getHeight() - this.bottomMargin + 12.0));
            }
        }
        if (this.textToDisplay != null) {
            ((Graphics2D)g).setTransform(new AffineTransform());
            g.drawString(this.textToDisplay, 5, 15);
        }
    }

    public void setColorMap(ColorMap cmap) {
        this.cmap = cmap;
    }

    public void setRange(double range) {
        this.range = range;
    }

    public void setTextToDisplay(String textToDisplay) {
        this.textToDisplay = textToDisplay;
    }

    public static void main(String[] args) {
        final MultibeamPanel mbp = new MultibeamPanel();
        GuiUtils.testFrame((JComponent)mbp);
        Thread t = new Thread(){

            @Override
            public void run() {
                while (true) {
                    try {
                        while (true) {
                            double[] vals = new double[100];
                            for (int i = 0; i < vals.length; ++i) {
                                vals[i] = Math.random();
                            }
                            mbp.updateBeams(vals, Double.NaN);
                            Thread.sleep(10L);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        continue;
                    }
                    break;
                }
            }
        };
        t.start();
    }
}

