/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.sidescan;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.TimeZone;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.plaf.basic.BasicSliderUI;
import net.miginfocom.swing.MigLayout;
import pt.lsts.neptus.gui.Timeline;
import pt.lsts.neptus.gui.TimelineChangeListener;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.mra.LogMarker;
import pt.lsts.neptus.mra.MRAPanel;
import pt.lsts.neptus.mra.api.SidescanParser;
import pt.lsts.neptus.mra.api.SidescanParserFactory;
import pt.lsts.neptus.mra.importers.IMraLogGroup;
import pt.lsts.neptus.mra.plots.LogMarkerListener;
import pt.lsts.neptus.mra.visualizations.MRAVisualization;
import pt.lsts.neptus.plugins.PluginDescription;
import pt.lsts.neptus.plugins.sidescan.SidescanPanel;
import pt.lsts.neptus.util.ImageUtils;
import pt.lsts.neptus.util.llf.LogUtils;

@PluginDescription(author="jqcorreia", name="Sidescan Analyzer", icon="pt/lsts/neptus/plugins/echosounder/echosounder.png")
public class SidescanAnalyzer
extends JPanel
implements MRAVisualization,
TimelineChangeListener,
LogMarkerListener {
    private static final long serialVersionUID = 1L;
    protected MRAPanel mraPanel;
    private Timeline timeline;
    private long firstPingTime;
    private long lastPingTime;
    private long currentTime;
    private long lastUpdateTime;
    private ArrayList<SidescanPanel> sidescanPanels = new ArrayList();
    private ArrayList<LogMarker> markerList = new ArrayList();
    private SidescanParser ssParser;
    protected SimpleDateFormat fmt = new SimpleDateFormat("HH:mm:ss.SSS");

    public SidescanAnalyzer(MRAPanel panel) {
        this.mraPanel = panel;
    }

    public void initialize(IMraLogGroup source) {
        this.ssParser = SidescanParserFactory.build((IMraLogGroup)source);
        this.firstPingTime = this.ssParser.firstPingTimestamp();
        this.lastPingTime = this.ssParser.lastPingTimestamp();
        this.lastUpdateTime = this.firstPingTime;
        for (Integer subsys : this.ssParser.getSubsystemList()) {
            this.sidescanPanels.add(new SidescanPanel(this, this.ssParser, subsys));
        }
        this.fmt.setTimeZone(TimeZone.getTimeZone("UTC"));
        this.timeline = new Timeline(0, (int)(this.lastPingTime - this.firstPingTime), 30, 1000, false);
        this.timeline.getSlider().setValue(0);
        this.timeline.addTimelineChangeListener((TimelineChangeListener)this);
        this.timeline.getSlider().setUI(new BasicSliderUI(this.timeline.getSlider()){

            @Override
            public void paintTicks(Graphics g) {
                super.paintTicks(g);
                for (LogMarker m : SidescanAnalyzer.this.markerList) {
                    long mtime = new Double(m.getTimestamp()).longValue();
                    g.drawLine(this.xPositionForValue((int)(mtime - SidescanAnalyzer.this.firstPingTime)), 0, this.xPositionForValue((int)(mtime - SidescanAnalyzer.this.firstPingTime)), SidescanAnalyzer.this.timeline.getSlider().getHeight() / 2);
                }
            }
        });
        this.setLayout((LayoutManager)new MigLayout());
        for (SidescanPanel p : this.sidescanPanels) {
            this.add((Component)p, "w 100%, h 100%, wrap");
        }
        this.add((Component)this.timeline, "w 100%, split");
    }

    public Component getComponent(IMraLogGroup source, double timestep) {
        this.initialize(source);
        this.revalidate();
        this.repaint();
        return this;
    }

    public Timeline getTimeline() {
        return this.timeline;
    }

    public void setTimeline(Timeline timeline) {
        this.timeline = timeline;
    }

    public void timelineChanged(int value) {
        try {
            if (Math.abs((long)value - this.currentTime) > (long)(66 * this.timeline.getSpeed())) {
                for (SidescanPanel p : this.sidescanPanels) {
                    p.clearLines();
                }
                this.lastUpdateTime = value;
            } else {
                this.lastUpdateTime = this.currentTime;
            }
            this.currentTime = value;
            if (this.currentTime + this.firstPingTime >= this.lastPingTime) {
                this.timeline.pause();
            }
            for (SidescanPanel p : this.sidescanPanels) {
                try {
                    p.updateImage(this.currentTime, this.lastUpdateTime);
                    p.repaint();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.timeline.setTime(this.firstPingTime + this.currentTime);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean canBeApplied(IMraLogGroup source) {
        return LogUtils.hasIMCSidescan((IMraLogGroup)source) || source.getFile("Data.jsf") != null || source.getLog("SidescanPing") != null;
    }

    @Override
    public String getName() {
        return I18n.text((String)"Sidescan Analyzer");
    }

    public ImageIcon getIcon() {
        return ImageUtils.getScaledIcon((String)"pt/lsts/neptus/plugins/echosounder/echosounder.png", (int)16, (int)16);
    }

    public Double getDefaultTimeStep() {
        return 0.0;
    }

    public boolean supportsVariableTimeSteps() {
        return false;
    }

    public MRAVisualization.Type getType() {
        return MRAVisualization.Type.VISUALIZATION;
    }

    public ArrayList<LogMarker> getMarkerList() {
        return this.markerList;
    }

    public void onCleanup() {
        this.sidescanPanels.clear();
        this.removeAll();
        this.mraPanel = null;
        this.markerList.clear();
    }

    public void onHide() {
        this.timeline.pause();
    }

    public void onShow() {
    }

    public void addLogMarker(LogMarker e) {
        this.markerList.add(e);
    }

    public void removeLogMarker(LogMarker e) {
        this.markerList.remove(e);
    }

    public void GotoMarker(LogMarker marker) {
    }
}

