/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.sidescan;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.io.File;
import java.io.FileWriter;
import java.util.Vector;
import org.imgscalr.Scalr;
import pt.lsts.imc.IMCMessage;
import pt.lsts.imc.SonarData;
import pt.lsts.imc.lsf.LsfIndex;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.colormap.ColorMap;
import pt.lsts.neptus.colormap.ColorMapFactory;
import pt.lsts.neptus.comm.IMCUtils;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.mra.importers.IMraLogGroup;
import pt.lsts.neptus.mra.replay.LogReplayComponent;
import pt.lsts.neptus.mra.replay.LogReplayLayer;
import pt.lsts.neptus.plugins.sidescan.SidescanTile;
import pt.lsts.neptus.plugins.sidescan.SlantRangeImageFilter;
import pt.lsts.neptus.renderer2d.StateRenderer2D;
import pt.lsts.neptus.types.coord.LocationType;

public class SidescanOverlay
implements LogReplayLayer {
    File dir = null;
    boolean producing = false;
    Vector<SidescanTile> tiles = null;

    public void cleanup() {
    }

    public String getName() {
        return I18n.text((String)"Sidescan Layer");
    }

    public String[] getObservedMessages() {
        return null;
    }

    public boolean getVisibleByDefault() {
        return false;
    }

    public boolean canBeApplied(IMraLogGroup source, LogReplayComponent.Context context) {
        return source.getLog("SonarData") != null;
    }

    public void onMessage(IMCMessage message) {
    }

    protected void loadTiles() {
        NeptusLog.pub().info((Object)"loading tiles...");
        this.tiles = new Vector();
        for (File f : this.dir.listFiles()) {
            if (!f.getName().endsWith(".tile")) continue;
            try {
                this.tiles.add(new SidescanTile(f));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        NeptusLog.pub().info((Object)("loaded " + this.tiles.size() + " tiles"));
    }

    protected void generateTiles(IMraLogGroup source) {
        NeptusLog.pub().info((Object)"generating tiles...");
        this.createTiles(source);
        try {
            FileWriter fw = new FileWriter(new File(source.getFile("mra"), "/sss/tiles.generated"));
            fw.write("done!");
            fw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void parse(final IMraLogGroup source) {
        if (source.getFile("mra/sss") == null) {
            File f = new File(source.getFile("mra"), "sss");
            f.mkdirs();
        }
        this.dir = source.getFile("mra/sss");
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                SidescanOverlay.this.producing = true;
                if (source.getFile("mra/sss/tiles.generated") == null) {
                    SidescanOverlay.this.generateTiles(source);
                }
                SidescanOverlay.this.loadTiles();
                SidescanOverlay.this.producing = false;
            }
        });
        t.setName("Sidescan Overlay Tile loader");
        t.setDaemon(true);
        t.start();
    }

    protected boolean createTiles(IMraLogGroup source) {
        File outputDir = source.getFile("mra/sss");
        LsfIndex index = source.getLsfIndex();
        int tileHeight = 20;
        BufferedImage curImage = null;
        ColorMap bronze = ColorMapFactory.createBronzeColormap();
        int tileNumber = 1;
        int tileH = 0;
        IMCMessage start = null;
        IMCMessage end = null;
        double curSpeedSum = 0.0;
        double curAltSum = 0.0;
        int i = index.getFirstMessageOfType("SonarData");
        while (i != -1) {
            try {
                SonarData ping = (SonarData)index.getMessage(i, SonarData.class);
                int stateIndex = index.getMsgIndexAt("EstimatedState", index.timeOf(i));
                IMCMessage state = null;
                if (stateIndex != -1) {
                    state = index.getMessage(stateIndex);
                    curSpeedSum += state.getDouble("u");
                    curAltSum += state.getDouble("alt");
                }
                if (ping.getType() == SonarData.TYPE.SIDESCAN) {
                    byte[] data = ping.getData();
                    if (curImage == null || tileH >= tileHeight) {
                        if (tileH == tileHeight) {
                            end = state;
                            double length = curSpeedSum / (double)(tileH - 2);
                            double alt = curAltSum / (double)tileH;
                            curAltSum = 0.0;
                            curSpeedSum = 0.0;
                            curImage = Scalr.apply((BufferedImage)curImage, (BufferedImageOp[])new BufferedImageOp[]{new SlantRangeImageFilter(alt, ping.getMaxRange(), curImage.getWidth())});
                            LocationType startLoc = IMCUtils.getLocation((IMCMessage)start);
                            LocationType endLoc = IMCUtils.getLocation((IMCMessage)end);
                            if (length > 0.0 && Math.abs(endLoc.getDistanceInMeters(startLoc) - length) < 5.0) {
                                SidescanTile tile = new SidescanTile(curImage, startLoc, ping.getMaxRange() * 2, start.getDouble("psi"), endLoc.getDistanceInMeters(startLoc));
                                tile.saveToFile(new File(outputDir, "tile" + tileNumber + ".tile"));
                                ++tileNumber;
                            }
                        }
                        start = state;
                        tileH = 0;
                        if (ping.getBitsPerPoint() == 16) {
                            curImage = new BufferedImage(data.length / 2, tileHeight, 2);
                        } else if (ping.getBitsPerPoint() == 8) {
                            curImage = new BufferedImage(data.length / 2, tileHeight, 2);
                        } else {
                            System.err.println("the number of bits per point of this sidescan is not supported.");
                            return false;
                        }
                    }
                    if (ping.getBitsPerPoint() == 8) {
                        for (int x = 0; x < data.length; x += 2) {
                            curImage.setRGB(x / 2, tileHeight - tileH - 1, bronze.getColor((double)((data[x] & 0xFF) + (data[x + 1] & 0xFF)) / 510.0).getRGB());
                        }
                    }
                    ++tileH;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            i = index.getNextMessageOfType("SonarData", i);
        }
        return true;
    }

    public void paint(Graphics2D g, StateRenderer2D renderer) {
        if (this.producing) {
            g.setColor(Color.red.darker());
            g.drawString("Sidescan layer is processing...", 60, 20);
        } else {
            for (SidescanTile t : this.tiles) {
                Point2D p = renderer.getScreenPosition(t.getBottomCenter());
                AffineTransform tr = new AffineTransform();
                tr.translate(p.getX(), p.getY());
                tr.rotate(t.rotation - renderer.getRotation());
                tr.scale((double)renderer.getZoom() * (t.width / 300.0), (double)renderer.getZoom() * (t.width / 300.0));
                tr.translate(-150.0, 0.0);
                g.drawImage(t.getTile(), tr, null);
            }
        }
    }
}

