/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.sidescan;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.io.File;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;
import org.imgscalr.Scalr;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.console.plugins.PropertiesProviders.SidescanConfig;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.mra.LogMarker;
import pt.lsts.neptus.mra.SidescanLogMarker;
import pt.lsts.neptus.mra.api.SidescanLine;
import pt.lsts.neptus.mra.api.SidescanParameters;
import pt.lsts.neptus.mra.api.SidescanParser;
import pt.lsts.neptus.mra.api.SidescanPoint;
import pt.lsts.neptus.mra.replay.MraVehiclePosHud;
import pt.lsts.neptus.plugins.sidescan.SidescanAnalyzer;
import pt.lsts.neptus.plugins.sidescan.SidescanToolbar;
import pt.lsts.neptus.plugins.sidescan.SlantRangeImageFilter;
import pt.lsts.neptus.types.coord.CoordinateUtil;
import pt.lsts.neptus.types.coord.LocationType;
import pt.lsts.neptus.util.GuiUtils;
import pt.lsts.neptus.util.ImageUtils;
import pt.lsts.neptus.util.MathMiscUtils;
import pt.lsts.neptus.util.VideoCreator;
import pt.lsts.neptus.util.llf.LsfReportProperties;

public class SidescanPanel
extends JPanel
implements MouseListener,
MouseMotionListener {
    private static final long serialVersionUID = 1L;
    private static final int ZOOM_BOX_SIZE = 100;
    private static final int ZOOM_LAYER_BOX_SIZE = 300;
    private SidescanAnalyzer parent;
    SidescanConfig config = new SidescanConfig();
    private SidescanToolbar toolbar = new SidescanToolbar(this);
    private SidescanParameters sidescanParams = new SidescanParameters(0.0, 0.0);
    private InteractionMode imode = InteractionMode.INFO;
    private MraVehiclePosHud posHud;
    private JPanel view = new JPanel(){
        private static final long serialVersionUID = 1L;

        @Override
        protected void paintComponent(Graphics g) {
            try {
                super.paintComponent(g);
                if (SidescanPanel.this.image != null && SidescanPanel.this.layer != null) {
                    g.drawImage(SidescanPanel.this.image, 0, 0, null);
                    Graphics2D lg2d = (Graphics2D)SidescanPanel.this.layer.getGraphics();
                    lg2d.setBackground(new Color(255, 255, 255, 0));
                    lg2d.clearRect(0, 0, SidescanPanel.this.layer.getWidth(), SidescanPanel.this.layer.getHeight());
                    if (SidescanPanel.this.measure && !SidescanPanel.this.parent.getTimeline().isRunning()) {
                        SidescanPanel.this.drawMeasure(SidescanPanel.this.layer.getGraphics());
                    } else if (SidescanPanel.this.parent.getTimeline().isRunning()) {
                        SidescanPanel.this.pointList.clear();
                    }
                    if (SidescanPanel.this.zoom) {
                        Graphics2D gz = (Graphics2D)g.create();
                        gz.setColor(Color.WHITE);
                        SidescanPanel.this.drawZoom(gz);
                    }
                    if (SidescanPanel.this.info) {
                        SidescanPanel.this.drawInfo(SidescanPanel.this.layer.getGraphics());
                    }
                    SidescanPanel.this.drawMarks(SidescanPanel.this.layer.getGraphics());
                    SidescanPanel.this.drawRuler(SidescanPanel.this.layer.getGraphics());
                    g.drawImage(SidescanPanel.this.layer, 0, 0, null);
                    if (SidescanPanel.this.config.showPositionHud) {
                        SidescanPanel.this.posHud.setPathColor(SidescanPanel.this.config.pathColor);
                        g.drawImage(SidescanPanel.this.posHud.getImage((double)(SidescanPanel.this.firstPingTime + SidescanPanel.this.currentTime) / 1000.0), 0, this.getHeight() - SidescanPanel.this.config.hudSize, null);
                    }
                    if (SidescanPanel.this.record) {
                        SidescanPanel.this.creator.addFrame(SidescanPanel.this.image, SidescanPanel.this.firstPingTime + SidescanPanel.this.currentTime);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    };
    private BufferedImage image;
    private BufferedImage layer;
    private Graphics2D g2d;
    private long firstPingTime;
    private long currentTime;
    private long prevPingTime;
    private float range = 0.0f;
    private BufferedImage bufferedCache;
    private boolean zoom = false;
    private boolean measure = false;
    private boolean info = false;
    private ArrayList<SidescanPoint> pointList = new ArrayList();
    private boolean marking = false;
    private int initialX;
    private int initialY;
    private int mouseX;
    private int mouseY;
    private SidescanLine mouseSidescanLine;
    private BufferedImage mouseLocationImage = ImageUtils.createCompatibleImage((int)120, (int)60, (int)2);
    private List<SidescanLine> lineList = Collections.synchronizedList(new ArrayList());
    private NumberFormat altFormat = GuiUtils.getNeptusDecimalFormat((int)1);
    private SidescanParser ssParser;
    private String altStr = I18n.text((String)"Altitude");
    private String rollStr = I18n.text((String)"Roll");
    private int rangeStep;
    private int subsystem;
    private VideoCreator creator;
    protected boolean record = false;

    public SidescanPanel(SidescanAnalyzer analyzer, SidescanParser parser, int subsystem) {
        this.parent = analyzer;
        this.ssParser = parser;
        this.initialize();
        this.subsystem = subsystem;
        this.posHud = new MraVehiclePosHud(analyzer.mraPanel.getSource(), this.config.hudSize, this.config.hudSize);
    }

    private void initialize() {
        this.prevPingTime = this.firstPingTime = this.ssParser.firstPingTimestamp();
        this.view.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                SidescanPanel.this.image = ImageUtils.createCompatibleImage((int)SidescanPanel.this.view.getWidth(), (int)SidescanPanel.this.view.getHeight(), (int)1);
                SidescanPanel.this.bufferedCache = ImageUtils.createCompatibleImage((int)SidescanPanel.this.view.getWidth(), (int)SidescanPanel.this.view.getHeight(), (int)1);
                SidescanPanel.this.g2d = (Graphics2D)SidescanPanel.this.image.getGraphics();
                SidescanPanel.this.layer = ImageUtils.createCompatibleImage((int)SidescanPanel.this.view.getWidth(), (int)SidescanPanel.this.view.getHeight(), (int)3);
            }
        });
        this.view.addMouseListener(this);
        this.view.addMouseMotionListener(this);
        this.setLayout((LayoutManager)new MigLayout("ins 0, gap 5"));
        this.add((Component)this.toolbar, "w 100%, wrap");
        this.add((Component)this.view, "w 100%, h 100%");
    }

    void record(boolean r) {
        this.record = r;
        if (r) {
            try {
                this.creator = new VideoCreator(new File(this.parent.mraPanel.getSource().getFile("Data.lsf").getParent() + "/mra/Sidescan_" + this.subsystem + ".mp4"), 800, 600);
                NeptusLog.pub().info((Object)"RECORDING TO Sidescan.mp4");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            this.creator.closeStreams();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateImage(long currentTime, long lastUpdateTime) {
        int yref = 0;
        this.currentTime = currentTime;
        ArrayList drawList = new ArrayList();
        ArrayList<SidescanLine> removeList = new ArrayList<SidescanLine>();
        this.sidescanParams.setNormalization(this.config.normalization);
        this.sidescanParams.setTvgGain(this.config.tvgGain);
        ArrayList list = this.ssParser.getLinesBetween(this.firstPingTime + lastUpdateTime, this.firstPingTime + currentTime, this.subsystem, this.sidescanParams);
        drawList.addAll(list);
        for (SidescanLine l : drawList) {
            if (l.range != this.getRange()) {
                this.setRange(l.range);
            }
            if (this.config.speedCorrection) {
                double horizontalScale;
                double verticalScale = horizontalScale = (double)((float)this.image.getWidth() / (l.range * 2.0f));
                double secondsElapsed = (float)(l.timestampMillis - this.prevPingTime) / 1000.0f;
                double speed = l.state.getU();
                int size = (int)(secondsElapsed * speed * verticalScale);
                l.ysize = size <= 0 || secondsElapsed > 0.5 ? 1 : size;
            } else {
                l.ysize = 1;
            }
            this.prevPingTime = l.timestampMillis;
            yref += l.ysize;
        }
        if (yref <= this.image.getHeight()) {
            ImageUtils.copySrcIntoDst((BufferedImage)this.image, (BufferedImage)this.bufferedCache, (int)0, (int)0, (int)this.image.getWidth(), (int)(this.image.getHeight() - yref), (int)0, (int)0, (int)this.image.getWidth(), (int)this.image.getHeight());
            this.g2d.drawImage((Image)this.bufferedCache, 0, yref, null);
        } else {
            yref = this.image.getHeight() - 1;
        }
        int d = 0;
        for (SidescanLine sidescanLine : drawList) {
            sidescanLine.ypos = yref - d;
            d += sidescanLine.ysize;
            sidescanLine.image = new BufferedImage(sidescanLine.data.length, 1, 1);
            for (int c = 0; c < sidescanLine.data.length; ++c) {
                sidescanLine.image.setRGB(c, 0, this.config.colorMap.getColor(sidescanLine.data[c]).getRGB());
            }
            if (this.config.slantRangeCorrection) {
                sidescanLine.image = Scalr.apply((BufferedImage)sidescanLine.image, (BufferedImageOp[])new BufferedImageOp[]{new SlantRangeImageFilter(sidescanLine.state.getAltitude(), sidescanLine.range, sidescanLine.image.getWidth())});
            }
            this.g2d.drawImage(ImageUtils.getScaledImage((Image)sidescanLine.image, (int)this.image.getWidth(), (int)sidescanLine.ysize, (boolean)true), 0, sidescanLine.ypos, null);
        }
        List<SidescanLine> list2 = this.lineList;
        synchronized (list2) {
            for (SidescanLine sidescanLine : this.lineList) {
                sidescanLine.ypos += yref;
                if (sidescanLine.ypos <= this.image.getHeight()) continue;
                removeList.add(sidescanLine);
            }
            this.lineList.addAll(drawList);
            this.lineList.removeAll(removeList);
        }
        drawList.clear();
        removeList.clear();
    }

    private void drawZoom(Graphics g) {
        if (this.mouseX == -1 && this.mouseY == -1) {
            return;
        }
        int X = (int)MathMiscUtils.clamp((double)this.mouseX, (double)50.0, (double)(this.image.getWidth() - 50));
        int Y = (int)MathMiscUtils.clamp((double)this.mouseY, (double)50.0, (double)(this.image.getHeight() - 50));
        BufferedImage zoomImage = this.image.getSubimage(X - 50, Y - 50, 100, 100);
        BufferedImage zoomLayerImage = this.layer.getSubimage(X - 50, Y - 50, 100, 100);
        g.drawImage(ImageUtils.getFasterScaledInstance((BufferedImage)zoomImage, (int)300, (int)300), this.image.getWidth() - 301, this.image.getHeight() - 301, null);
        g.drawImage(ImageUtils.getFasterScaledInstance((BufferedImage)zoomLayerImage, (int)300, (int)300), this.layer.getWidth() - 301, this.layer.getHeight() - 301, null);
        g.drawRect(X - 50, Y - 50, 100, 100);
    }

    private void drawInfo(Graphics g) {
        if (this.mouseSidescanLine != null) {
            LocationType loc = this.convertImagePointXToLocation(this.mouseX, this.mouseSidescanLine);
            Graphics2D location2d = (Graphics2D)this.mouseLocationImage.getGraphics();
            location2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            location2d.clearRect(0, 0, this.mouseLocationImage.getWidth(), this.mouseLocationImage.getHeight());
            location2d.drawString(CoordinateUtil.dmToLatString((double[])CoordinateUtil.decimalDegreesToDM((double)loc.getLatitudeDegs())), 5, 15);
            location2d.drawString(CoordinateUtil.dmToLonString((double[])CoordinateUtil.decimalDegreesToDM((double)loc.getLongitudeDegs())), 5, 26);
            location2d.drawString(this.altStr + ": " + this.altFormat.format(this.mouseSidescanLine.state.getAltitude()), 5, 37);
            location2d.drawString(this.rollStr + ": " + this.altFormat.format(Math.toDegrees(this.mouseSidescanLine.state.getRoll())), 5, 48);
            location2d.drawString(CoordinateUtil.dmToLatString((double[])CoordinateUtil.decimalDegreesToDM((double)loc.getLatitudeDegs())), 5, 15);
            location2d.drawString(CoordinateUtil.dmToLonString((double[])CoordinateUtil.decimalDegreesToDM((double)loc.getLongitudeDegs())), 5, 26);
            location2d.drawString(this.altStr + ": " + this.altFormat.format(this.mouseSidescanLine.state.getAltitude()) + " m", 5, 37);
            location2d.drawString(this.rollStr + ": " + this.altFormat.format(Math.toDegrees(this.mouseSidescanLine.state.getRoll())) + "\u00b0", 5, 48);
            g.drawImage(this.mouseLocationImage, 10, 20, null);
        }
    }

    private void drawMeasure(Graphics g) {
        int c = 0;
        SidescanPoint prevPoint = null;
        g.setColor(Color.GREEN);
        g.drawRect(3, 3, 6, 6);
        for (SidescanPoint point : this.pointList) {
            int pointX = this.convertSidescanLinePointXToImagePointX(point.x, this.mouseSidescanLine.xsize);
            if (c == 0) {
                g.drawRect(pointX - 3, point.y - 3, 6, 6);
            } else {
                int prevPointX = this.convertSidescanLinePointXToImagePointX(prevPoint.x, prevPoint.xsize);
                double distance = prevPoint.location.getDistanceInMeters(point.location);
                distance = (double)((int)(distance * 1000.0)) / 1000.0;
                g.drawLine(prevPointX, prevPoint.y, pointX, point.y);
                g.drawRect(pointX - 3, point.y - 3, 6, 6);
                g.setColor(Color.BLACK);
                g.drawString(distance + "m", (prevPointX + pointX) / 2 + 3, (prevPoint.y + point.y) / 2 - 1);
                g.setColor(Color.GREEN);
                g.drawString(distance + "m", (prevPointX + pointX) / 2 + 4, (prevPoint.y + point.y) / 2);
            }
            prevPoint = point;
            ++c;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drawMarks(Graphics g2) {
        if (this.marking) {
            int x = Math.min(this.initialX, this.mouseX);
            int y = Math.min(this.initialY, this.mouseY);
            int w = Math.max(this.initialX, this.mouseX) - Math.min(this.initialX, this.mouseX);
            int h = Math.max(this.initialY, this.mouseY) - Math.min(this.initialY, this.mouseY);
            g2.drawRect(x, y, w, h);
        }
        SidescanLine old = null;
        Graphics2D g = (Graphics2D)g2.create();
        for (LogMarker m : this.parent.getMarkerList()) {
            long timestamp = new Double(m.getTimestamp()).longValue();
            Color color = Color.WHITE;
            Color colorConstrast = Color.BLACK;
            List<SidescanLine> list = this.lineList;
            synchronized (list) {
                for (SidescanLine line : this.lineList) {
                    if (old != null && timestamp >= old.timestampMillis && timestamp <= line.timestampMillis) {
                        if (m instanceof SidescanLogMarker) {
                            SidescanLogMarker slm = (SidescanLogMarker)m;
                            double scale = (float)(this.image.getWidth() / 2) / line.range;
                            int x = (int)((double)(this.image.getWidth() / 2) + slm.x * scale);
                            g.setColor(color);
                            g.drawRect(x - slm.w / 2, line.ypos - slm.h / 2, slm.w, slm.h);
                            g.setColor(colorConstrast);
                            g.drawString(m.getLabel(), x - slm.w / 2 - 1, line.ypos - slm.h / 2 - 10 - 1);
                            g.setColor(color);
                            g.drawString(m.getLabel(), x - slm.w / 2, line.ypos - slm.h / 2 - 10);
                            break;
                        }
                        g.setColor(color);
                        g.fillRect(0, line.ypos - 1, 10, 2);
                        g.fillRect(line.image.getWidth(null) - 10, line.ypos - 1, 10, 2);
                        g.setColor(colorConstrast);
                        g.drawString(m.getLabel(), -1, line.ypos - 10 - 1);
                        g.setColor(color);
                        g.drawString(m.getLabel(), 0, line.ypos - 10);
                        break;
                    }
                    old = line;
                }
            }
        }
        g.dispose();
    }

    private void drawRuler(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        int fontSize = 11;
        int maxesSize = 15;
        g2d.drawLine(0, 0, this.layer.getWidth(), 0);
        Rectangle drawRulerHere = new Rectangle(0, 0, this.layer.getWidth(), maxesSize);
        g2d.setColor(Color.LIGHT_GRAY);
        g2d.fill(drawRulerHere);
        g2d.setFont(new Font("SansSerif", 0, fontSize));
        g2d.setColor(Color.BLACK);
        g2d.drawLine(0, 0, this.layer.getWidth(), 0);
        g2d.drawLine(this.layer.getWidth() / 2, 0, this.layer.getWidth() / 2, maxesSize);
        g2d.drawString("0", this.layer.getWidth() / 2 - 10, fontSize);
        g2d.drawLine(0, 0, 0, 15);
        g2d.drawString("" + (int)this.range, 2, 11);
        g2d.drawLine(this.layer.getWidth() - 1, 0, this.layer.getWidth() - 1, maxesSize);
        g2d.drawString("" + (int)this.range, this.layer.getWidth() - 20, fontSize);
        double step = (float)this.layer.getWidth() / (this.range * 2.0f / (float)this.rangeStep);
        double r = this.rangeStep;
        int c1 = (int)((double)(this.layer.getWidth() / 2) - step);
        int c2 = (int)((double)(this.layer.getWidth() / 2) + step);
        while (c1 > 0) {
            g2d.drawLine(c1, 0, c1, maxesSize);
            g2d.drawLine(c2, 0, c2, maxesSize);
            g2d.drawString("" + (int)r, c1 + 5, fontSize);
            g2d.drawString("" + (int)r, c2 - 20, fontSize);
            c1 = (int)((double)c1 - step);
            c2 = (int)((double)c2 + step);
            r += (double)this.rangeStep;
        }
    }

    private int convertSidescanLinePointXToImagePointX(int sidescanLineX, SidescanLine sidescanLine) {
        return this.convertSidescanLinePointXToImagePointX(sidescanLineX, sidescanLine.xsize);
    }

    private int convertSidescanLinePointXToImagePointX(int sidescanLineX, int sidescanLineXSize) {
        return (int)((float)sidescanLineX / ((float)sidescanLineXSize / (float)this.image.getWidth()));
    }

    private int convertImagePointXToSidescanLinePointX(int imageMouseX, SidescanLine sidescanLine) {
        return this.convertImagePointXToSidescanLinePointX(imageMouseX, sidescanLine.xsize);
    }

    private int convertImagePointXToSidescanLinePointX(int imageMouseX, int sidescanLineXSize) {
        return (int)((float)imageMouseX * ((float)sidescanLineXSize / (float)this.image.getWidth()));
    }

    private SidescanPoint convertImagePointXToSidescanPoint(int imageMouseX, SidescanLine sidescanLine) {
        return sidescanLine.calcPointForCoord(this.convertImagePointXToSidescanLinePointX(imageMouseX, sidescanLine));
    }

    private LocationType convertImagePointXToLocation(int imageMouseX, SidescanLine sidescanLine) {
        return this.convertImagePointXToSidescanPoint((int)imageMouseX, (SidescanLine)sidescanLine).location;
    }

    public float getRange() {
        return this.range;
    }

    public void setRange(float range) {
        this.range = range;
        this.rangeStep = 10;
    }

    public BufferedImage getImage() {
        return this.image;
    }

    public void clearLines() {
        this.lineList.clear();
        this.image.getGraphics().clearRect(0, 0, this.image.getWidth(), this.image.getHeight());
    }

    public void setInteractionMode(InteractionMode imode) {
        this.measure = false;
        this.pointList.clear();
        this.imode = imode;
    }

    public void setZoom(boolean zoomSelected) {
        this.zoom = zoomSelected;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mouseMoved(MouseEvent e) {
        this.mouseX = e.getX();
        this.mouseY = e.getY();
        int y = e.getY();
        List<SidescanLine> list = this.lineList;
        synchronized (list) {
            for (SidescanLine line : this.lineList) {
                if (y < line.ypos || y > line.ypos + line.ysize) continue;
                this.mouseSidescanLine = line;
                ((JPanel)e.getSource()).repaint();
            }
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.mouseX = e.getX();
        this.mouseY = e.getY();
        int y = e.getY();
        for (SidescanLine line : this.lineList.toArray(new SidescanLine[0])) {
            if (y < line.ypos || y > line.ypos + line.ysize) continue;
            this.mouseSidescanLine = line;
            ((JPanel)e.getSource()).repaint();
        }
        ((JPanel)e.getSource()).repaint();
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.mouseX = e.getX();
        this.mouseY = e.getY();
        if (e.getButton() == 1) {
            for (SidescanLine line : this.lineList) {
                if (this.mouseY < line.ypos || this.mouseY > line.ypos + line.ysize) continue;
                this.mouseSidescanLine = line;
                ((JPanel)e.getSource()).repaint();
                break;
            }
            if (this.imode == InteractionMode.MARK && !this.parent.getTimeline().isRunning()) {
                if (LsfReportProperties.generatingReport) {
                    GuiUtils.infoMessage((Component)this.getRootPane(), (String)I18n.text((String)"Can not add Marks"), (String)I18n.text((String)"Can not add Marks - Generating Report."));
                    return;
                }
                this.marking = true;
                this.initialX = this.mouseX;
                this.initialY = this.mouseY;
            } else if (this.imode == InteractionMode.MEASURE && !this.parent.getTimeline().isRunning()) {
                this.measure = true;
                int x = this.convertImagePointXToSidescanLinePointX(this.mouseX, this.mouseSidescanLine);
                this.pointList.add(this.mouseSidescanLine.calcPointForCoord(x));
                if (this.pointList.size() > 2) {
                    this.pointList.clear();
                }
            } else if (this.imode == InteractionMode.INFO) {
                this.info = true;
            }
            ((JPanel)e.getSource()).repaint();
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.info = false;
        if (this.marking) {
            String res = JOptionPane.showInputDialog("Insert marker name");
            if (res != null) {
                if (this.initialX == this.mouseX && this.initialY == this.mouseY) {
                    SidescanLine sl = null;
                    for (SidescanLine line : this.lineList) {
                        if (this.initialY < line.ypos || this.initialY > line.ypos + line.ysize) continue;
                        sl = line;
                        break;
                    }
                    int x = this.convertImagePointXToSidescanLinePointX(this.initialX, sl);
                    int y = this.convertImagePointXToSidescanLinePointX(this.initialY, sl);
                    SidescanPoint point = sl.calcPointForCoord(x);
                    double distanceToNadir = sl.state.getPosition().getDistanceInMeters(point.location);
                    this.parent.mraPanel.addMarker((LogMarker)new SidescanLogMarker(res, (double)sl.timestampMillis, point.location.getLatitudeRads(), point.location.getLongitudeRads(), distanceToNadir *= (double)(x > sl.xsize / 2 ? 1 : -1), (double)y, Math.abs(this.mouseX - this.initialX), Math.abs(this.mouseY - this.initialY), this.subsystem, this.config.colorMap));
                } else {
                    SidescanLine lInit = null;
                    for (SidescanLine line : this.lineList) {
                        if (this.initialY < line.ypos || this.initialY > line.ypos + line.ysize) continue;
                        lInit = line;
                        break;
                    }
                    int initialPointXSidescan = this.convertImagePointXToSidescanLinePointX(this.initialX, lInit);
                    int mousePointXSidescan = this.convertImagePointXToSidescanLinePointX(this.mouseX, this.mouseSidescanLine);
                    int x = (mousePointXSidescan + initialPointXSidescan) / 2;
                    int y = (this.mouseY + this.initialY) / 2;
                    SidescanLine l = null;
                    for (SidescanLine line : this.lineList) {
                        if (y < line.ypos || y > line.ypos + line.ysize) continue;
                        l = line;
                        break;
                    }
                    SidescanPoint point = l.calcPointForCoord(x);
                    double distanceToNadir = l.state.getPosition().getDistanceInMeters(point.location);
                    distanceToNadir *= (double)(x > l.xsize / 2 ? 1 : -1);
                    int x1 = Math.min(mousePointXSidescan, initialPointXSidescan);
                    int x2 = Math.max(mousePointXSidescan, initialPointXSidescan);
                    SidescanPoint p1 = l.calcPointForCoord(x1);
                    SidescanPoint p2 = l.calcPointForCoord(x2);
                    double d1 = l.state.getPosition().getDistanceInMeters(p1.location);
                    d1 *= (double)(x1 > l.xsize / 2 ? 1 : -1);
                    double d2 = l.state.getPosition().getDistanceInMeters(p2.location);
                    d2 *= (double)(x2 > l.xsize / 2 ? 1 : -1);
                    double wMeters = (d2 += (double)l.range) - (d1 += (double)l.range);
                    this.parent.mraPanel.addMarker((LogMarker)new SidescanLogMarker(res, (double)l.timestampMillis, point.location.getLatitudeRads(), point.location.getLongitudeRads(), distanceToNadir, (double)y, Math.abs(this.mouseX - this.initialX), Math.abs(this.mouseY - this.initialY), wMeters, this.subsystem, this.config.colorMap));
                }
            }
            this.marking = false;
        }
        if (this.imode != InteractionMode.MEASURE) {
            this.measure = false;
            this.pointList.clear();
        }
        ((JPanel)e.getSource()).repaint();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.mouseY = -1;
        this.mouseX = -1;
        this.repaint();
    }

    static enum InteractionMode {
        NONE,
        INFO,
        MARK,
        MEASURE;

    }
}

