/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.sidescan;

import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.RenderedImage;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import javax.imageio.ImageIO;
import org.imgscalr.Scalr;
import pt.lsts.neptus.types.coord.LocationType;

public class SidescanTile {
    protected static final int version = 1;
    protected BufferedImage tile;
    protected LocationType downCenter;
    protected double rotation;
    protected double width;
    protected double length;

    public SidescanTile(BufferedImage image, LocationType loc, double width, double rotation, double length) {
        this.tile = image;
        this.width = width;
        this.length = length;
        this.rotation = rotation;
        this.downCenter = new LocationType(loc);
    }

    public SidescanTile(File source) throws Exception {
        FileInputStream fis = new FileInputStream(source);
        DataInputStream dis = new DataInputStream(fis);
        int version = dis.readInt();
        if (version != 1) {
            fis.close();
            throw new Exception("Incompatible format");
        }
        this.downCenter = new LocationType(dis.readDouble(), dis.readDouble());
        this.rotation = dis.readDouble();
        this.width = dis.readDouble();
        this.length = dis.readDouble();
        this.tile = ImageIO.read(fis);
        fis.close();
    }

    public void saveToFile(File destination) throws Exception {
        FileOutputStream output = new FileOutputStream(destination);
        DataOutputStream dos = new DataOutputStream(output);
        dos.writeInt(1);
        this.downCenter.convertToAbsoluteLatLonDepth();
        dos.writeDouble(this.downCenter.getLatitudeDegs());
        dos.writeDouble(this.downCenter.getLongitudeDegs());
        dos.writeDouble(this.rotation);
        dos.writeDouble(this.width);
        dos.writeDouble(this.length);
        ImageIO.write((RenderedImage)Scalr.resize((BufferedImage)this.tile, (Scalr.Mode)Scalr.Mode.FIT_EXACT, (int)300, (int)((int)(300.0 / this.width * this.length)), (BufferedImageOp[])new BufferedImageOp[0]), "png", output);
        output.close();
    }

    public BufferedImage getTile() {
        return this.tile;
    }

    public void setTile(BufferedImage tile) {
        this.tile = tile;
    }

    public LocationType getBottomCenter() {
        return this.downCenter;
    }

    public void setBottomCenter(LocationType center) {
        this.downCenter = center;
    }

    public double getRotation() {
        return this.rotation;
    }

    public void setRotation(double rotation) {
        this.rotation = rotation;
    }
}

