/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.sidescan;

import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import pt.lsts.neptus.gui.PropertiesEditor;
import pt.lsts.neptus.gui.PropertiesProvider;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.plugins.sidescan.SidescanPanel;

public class SidescanToolbar
extends JToolBar {
    private static final long serialVersionUID = 1L;
    SidescanPanel panel;
    ButtonGroup bgroup = new ButtonGroup();
    JToggleButton btnMeasure = new JToggleButton(I18n.text((String)"Measure"));
    JToggleButton btnInfo = new JToggleButton(I18n.text((String)"Info"));
    JToggleButton btnZoom = new JToggleButton(I18n.text((String)"Zoom"));
    JToggleButton btnMark = new JToggleButton(I18n.text((String)"Mark"));
    JToggleButton btnRecord = new JToggleButton(I18n.text((String)"Record"));
    JLabel lblNormalization = new JLabel(I18n.text((String)"Normalization"));
    JLabel lblTVG = new JLabel(I18n.textc((String)"TVG", (String)"Time Variable Gain"));
    JTextField txtNormalization = new JTextField();
    JTextField txtTVG = new JTextField();
    JButton btnConfig = new JButton(new AbstractAction(I18n.textc((String)"Config", (String)"Configuration")){
        private static final long serialVersionUID = -878895322319699542L;

        @Override
        public void actionPerformed(ActionEvent e) {
            PropertiesEditor.editProperties((PropertiesProvider)SidescanToolbar.this.panel.config, (Window)SwingUtilities.getWindowAncestor(SidescanToolbar.this.panel), (boolean)true);
            SidescanToolbar.this.panel.config.saveProps();
        }
    });
    ActionListener alMode = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            SidescanPanel.InteractionMode imode = SidescanPanel.InteractionMode.NONE;
            if (SidescanToolbar.this.btnInfo.isSelected()) {
                imode = SidescanPanel.InteractionMode.INFO;
            }
            if (SidescanToolbar.this.btnMark.isSelected()) {
                imode = SidescanPanel.InteractionMode.MARK;
            }
            if (SidescanToolbar.this.btnMeasure.isSelected()) {
                imode = SidescanPanel.InteractionMode.MEASURE;
            }
            SidescanToolbar.this.panel.setInteractionMode(imode);
            SidescanToolbar.this.panel.setZoom(SidescanToolbar.this.btnZoom.isSelected());
        }
    };
    ActionListener alGains = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            SidescanToolbar.this.panel.config.tvgGain = new Double(SidescanToolbar.this.txtTVG.getText());
            SidescanToolbar.this.panel.config.normalization = new Double(SidescanToolbar.this.txtNormalization.getText());
            SidescanToolbar.this.panel.record(SidescanToolbar.this.btnRecord.isSelected());
        }
    };

    public SidescanToolbar(SidescanPanel panel) {
        this.panel = panel;
        this.buildToolbar();
    }

    private void buildToolbar() {
        this.btnInfo.setSelected(true);
        this.bgroup.add(this.btnInfo);
        this.bgroup.add(this.btnMeasure);
        this.bgroup.add(this.btnMark);
        this.add(this.btnInfo);
        this.add(this.btnMeasure);
        this.add(this.btnMark);
        this.add(this.btnZoom);
        this.addSeparator();
        this.add(this.lblNormalization);
        this.add(this.txtNormalization);
        this.add(this.lblTVG);
        this.add(this.txtTVG);
        this.addSeparator();
        this.add(this.btnConfig);
        this.add(this.btnRecord);
        this.btnInfo.addActionListener(this.alMode);
        this.btnZoom.addActionListener(this.alMode);
        this.btnMeasure.addActionListener(this.alMode);
        this.btnMark.addActionListener(this.alMode);
        this.btnRecord.addActionListener(this.alGains);
        this.txtNormalization.addActionListener(this.alGains);
        this.txtTVG.addActionListener(this.alGains);
        this.txtNormalization.setText(this.panel.config.normalization + "");
        this.txtTVG.setText(this.panel.config.tvgGain + "");
    }
}

