/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.sidescan;

import com.jhlabs.image.TransformFilter;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.io.File;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTabbedPane;
import org.imgscalr.Scalr;
import pt.lsts.neptus.util.GuiUtils;

public class SlantRangeImageFilter
extends TransformFilter {
    protected double height;
    protected double range;
    protected double imgWidth;

    public SlantRangeImageFilter(double height, double range, int imgWidth) {
        this.imgWidth = imgWidth;
        this.height = height * 2.0;
        this.range = range;
    }

    protected void transformInverse(int x, int y, float[] out) {
        double h = this.height * (this.imgWidth / (this.range * 2.0));
        double d = Math.abs(this.imgWidth / 2.0 - (double)x);
        out[1] = y;
        out[0] = (double)x < this.imgWidth / 2.0 ? (float)(this.imgWidth / 2.0 - Math.sqrt(d * d + h * h)) : (float)(this.imgWidth / 2.0 + Math.sqrt(d * d + h * h));
    }

    public void setHeight(double height) {
        this.height = height * 2.0;
    }

    public static void main(String[] args) throws Exception {
        BufferedImage original = ImageIO.read(new File("/home/jqcorreia/Downloads/sidescan_example.png"));
        JTabbedPane tabs = new JTabbedPane();
        BufferedImage result = Scalr.apply((BufferedImage)original, (BufferedImageOp[])new BufferedImageOp[]{new SlantRangeImageFilter(5.0, 30.0, original.getWidth())});
        tabs.add("Original", new JLabel(new ImageIcon(original)));
        tabs.add("Processed", new JLabel(new ImageIcon(result)));
        GuiUtils.testFrame((JComponent)tabs);
    }
}

