/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.gige;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentLinkedQueue;

public class GigeManager {
    public static final int CONTROL_PORT = 3956;
    public static final int LISTEN_CONTROL_PORT = 3957;
    public static final int LISTEN_STREAM_PORT = 59517;
    public static final int CMD_WRITEREG = 130;
    public static final int CMD_READREG = 128;
    public static final int CMD_RESENDREQUEST = 64;
    public static final int REG_CCP = 2560;
    public static final int REG_S0_DEST_PORT = 3328;
    public static final int REG_S0_SOURCE_PORT = 3356;
    public static final int REG_S0_DEST_ADDR = 3352;
    public static final int REG_HEARTBEAT_TIMEOUT = 2360;
    DatagramSocket controlSocket = null;
    DatagramSocket receiveSocket = null;
    InetAddress IPAddress;
    int packetSize;
    ArrayList<GigeDatagramListener> listenerList = new ArrayList();
    ConcurrentLinkedQueue<DatagramPacket> queue = new ConcurrentLinkedQueue();
    TimerTask heartbeat = new TimerTask(){

        @Override
        public void run() {
            try {
                GigeManager.this.readRegister(2560);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    };
    Timer timer;
    Thread receivingThread;
    public static int seq_num = 1;

    public GigeManager(String host) {
        try {
            this.controlSocket = new DatagramSocket(3957);
            this.receiveSocket = new DatagramSocket(59517);
            this.IPAddress = InetAddress.getByName(host);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void addDatagramListener(GigeDatagramListener l) {
        this.listenerList.add(l);
    }

    public void connect(String destIp) throws IOException {
        int version = this.readRegister(0);
        System.out.println("GigE Version: " + (version >> 16 & 0xFFFF) + "." + (version & 0xFF));
        System.out.println("Device Mode: " + this.readRegister(4));
        System.out.println("Device Name: " + this.readRegisterString(72, 4) + this.readRegisterString(80, 4) + this.readRegisterString(84, 4) + this.readRegisterString(88, 4));
        System.out.println("S0 Source port: " + this.readRegister(3356));
        System.out.println("S0 Destination port:" + this.readRegister(3328));
        System.out.println("S0 Acquisition Mode:" + this.readRegister(78080));
        System.out.println("Write CCP: " + this.writeRegister(2560, 2));
        System.out.println("CCP : " + this.readRegister(2560));
        System.out.println(this.writeRegister(3328, 59517));
        System.out.println("S0 Destination port:" + this.readRegister(3328));
        System.out.println(this.writeRegister(3352, this.ipToInt(destIp)));
        int address = this.readRegister(3352);
        System.out.println("Destination 32bit IP address for Channel 0: " + address);
        this.packetSize = (this.readRegister(3332) & 0xFFFF) - 28;
        System.out.println("Packet size: " + this.packetSize);
        this.timer = new Timer(false);
        TimerTask heartbeat = new TimerTask(){

            @Override
            public void run() {
                try {
                    GigeManager.this.readRegister(2560);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        };
        this.timer.scheduleAtFixedRate(heartbeat, 0L, 1000L);
        this.receivingThread = new Thread(new Runnable(){

            @Override
            public void run() {
                byte[] buf = new byte[5000];
                block2: while (true) {
                    DatagramPacket packet = new DatagramPacket(buf, buf.length);
                    try {
                        GigeManager.this.receiveSocket.receive(packet);
                        Iterator<GigeDatagramListener> i$ = GigeManager.this.listenerList.iterator();
                        while (true) {
                            if (!i$.hasNext()) continue block2;
                            GigeDatagramListener listener = i$.next();
                            listener.receivedDatagram(packet);
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        continue;
                    }
                    break;
                }
            }
        });
        this.receivingThread.start();
    }

    public void startStream() {
        try {
            System.out.println("Write acquisition start register: " + this.writeRegister(54036, 1));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void stopStream() {
        try {
            System.out.println("Write acquisition stop register: " + this.writeRegister(78112, 1));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public boolean writeRegister(int register, int data) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream os = new DataOutputStream(baos);
        os.writeByte(66);
        os.writeByte(1);
        os.writeShort(130);
        os.writeShort(8);
        os.writeShort(seq_num++);
        os.writeInt(register);
        os.writeInt(data);
        byte[] sendData = baos.toByteArray();
        DatagramPacket sendPacket = new DatagramPacket(sendData, sendData.length, this.IPAddress, 3956);
        this.controlSocket.send(sendPacket);
        byte[] receiveData = new byte[1024];
        DatagramPacket receivePacket = new DatagramPacket(receiveData, receiveData.length);
        this.controlSocket.receive(receivePacket);
        ByteBuffer buf = ByteBuffer.wrap(receiveData);
        return buf.getShort(10) > 0;
    }

    public boolean writeRegisterLong(int register, long data) throws IOException {
        for (int i = 0; i < 2; ++i) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream os = new DataOutputStream(baos);
            os.writeByte(66);
            os.writeByte(1);
            os.writeShort(130);
            os.writeShort(8);
            os.writeShort(seq_num++);
            os.writeInt(register + i * 2);
            os.writeInt((int)(data >> i * 16 & 0xFFFFL));
            byte[] sendData = baos.toByteArray();
            DatagramPacket sendPacket = new DatagramPacket(sendData, sendData.length, this.IPAddress, 3956);
            this.controlSocket.send(sendPacket);
            byte[] receiveData = new byte[1024];
            DatagramPacket receivePacket = new DatagramPacket(receiveData, receiveData.length);
            this.controlSocket.receive(receivePacket);
        }
        return true;
    }

    public int readRegister(int register) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream os = new DataOutputStream(baos);
        os.writeByte(66);
        os.writeByte(1);
        os.writeShort(128);
        os.writeShort(4);
        os.writeShort(seq_num++);
        os.writeInt(register);
        byte[] sendData = baos.toByteArray();
        DatagramPacket sendPacket = new DatagramPacket(sendData, sendData.length, this.IPAddress, 3956);
        this.controlSocket.send(sendPacket);
        byte[] receiveData = new byte[1024];
        DatagramPacket receivePacket = new DatagramPacket(receiveData, receiveData.length);
        this.controlSocket.receive(receivePacket);
        ByteBuffer buf = ByteBuffer.wrap(receiveData);
        return buf.getInt(8);
    }

    public String readRegisterString(int register, int size) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream os = new DataOutputStream(baos);
        os.writeByte(66);
        os.writeByte(1);
        os.writeShort(128);
        os.writeShort(4);
        os.writeShort(seq_num++);
        os.writeInt(register);
        byte[] sendData = baos.toByteArray();
        DatagramPacket sendPacket = new DatagramPacket(sendData, sendData.length, this.IPAddress, 3956);
        this.controlSocket.send(sendPacket);
        byte[] receiveData = new byte[1024];
        DatagramPacket receivePacket = new DatagramPacket(receiveData, receiveData.length);
        this.controlSocket.receive(receivePacket);
        ByteBuffer buf = ByteBuffer.wrap(receiveData);
        byte[] dst = new byte[size];
        buf.position(8);
        buf.get(dst, 0, size);
        return new String(dst);
    }

    public void requestResend(int firstPackageId, int lastPackageId, int blockID) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream os = new DataOutputStream(baos);
        os.writeByte(66);
        os.writeByte(0);
        os.writeShort(64);
        os.writeShort(12);
        os.writeShort(seq_num++);
        os.writeShort(0);
        os.writeShort(blockID);
        os.writeInt(firstPackageId);
        os.writeInt(lastPackageId);
        byte[] sendData = baos.toByteArray();
        DatagramPacket sendPacket = new DatagramPacket(sendData, sendData.length, this.IPAddress, 3956);
        this.controlSocket.send(sendPacket);
    }

    public int ipToInt(String addr) {
        String[] addrArray = addr.split("\\.");
        int num = 0;
        for (int i = 0; i < addrArray.length; ++i) {
            int power = 3 - i;
            num = (int)((double)num + (double)(Integer.parseInt(addrArray[i]) % 256) * Math.pow(256.0, power));
        }
        return num;
    }

    public int getPacketSize() {
        return this.packetSize;
    }

    public static interface GigeDatagramListener {
        public void receivedDatagram(DatagramPacket var1);
    }
}

