/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.gige;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.io.File;
import java.io.IOException;
import java.net.DatagramPacket;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.miginfocom.swing.MigLayout;
import pt.lsts.neptus.console.ConsoleLayout;
import pt.lsts.neptus.console.ConsolePanel;
import pt.lsts.neptus.plugins.PluginDescription;
import pt.lsts.neptus.plugins.Popup;
import pt.lsts.neptus.plugins.gige.GigeManager;
import pt.lsts.neptus.util.VideoCreator;

@PluginDescription(name="GiGe Panel", description="GiGe Panel")
@Popup(name="GiGe Panel", pos=Popup.POSITION.CENTER, width=800, height=600, accelerator=116)
public class GigePanel
extends ConsolePanel
implements GigeManager.GigeDatagramListener {
    private static final long serialVersionUID = 1L;
    static int recordNum = 0;
    BufferedImage image = new BufferedImage(720, 480, 10);
    JPanel panel = new JPanel(){
        private static final long serialVersionUID = 1L;

        @Override
        protected void paintComponent(Graphics g) {
            g.drawImage(GigePanel.this.image, 0, 0, null);
            if (GigePanel.this.recording) {
                GigePanel.this.creator.addFrame(GigePanel.this.image, System.currentTimeMillis());
            }
        }
    };
    DataBufferByte dbb = (DataBufferByte)this.image.getRaster().getDataBuffer();
    byte[] ib = this.dbb.getData();
    GigeManager manager;
    ByteBuffer bb;
    ArrayList<Integer> receivedList = new ArrayList();
    boolean debug = true;
    boolean recording = false;
    VideoCreator creator;
    private JButton start = new JButton(new AbstractAction("Start"){
        private static final long serialVersionUID = -6416906682002548227L;

        @Override
        public void actionPerformed(ActionEvent e) {
            GigePanel.this.manager.startStream();
        }
    });
    private JButton stop = new JButton(new AbstractAction("Stop"){
        private static final long serialVersionUID = 6761584339646110219L;

        @Override
        public void actionPerformed(ActionEvent e) {
            GigePanel.this.manager.stopStream();
        }
    });
    private JButton connect = new JButton(new AbstractAction("Connect"){
        private static final long serialVersionUID = -4026628689363444940L;

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                GigePanel.this.manager.connect(GigePanel.this.ipField.getText());
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
    });
    JTextField ipField = new JTextField();
    private JButton record = new JButton(new AbstractAction("Record"){
        private static final long serialVersionUID = 791901689647495239L;

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!GigePanel.this.recording) {
                GigePanel.this.recording = true;
                try {
                    GigePanel.this.creator = new VideoCreator(new File("ROV_" + recordNum++ + ".mp4"), 720, 480);
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
                GigePanel.this.record.setText("Recording");
            } else {
                GigePanel.this.creator.closeStreams();
                GigePanel.this.recording = false;
                GigePanel.this.record.setText("Record");
            }
        }
    });
    int currentBlockId = -1;
    boolean trailerReceived = false;
    int numPackets = 0;

    public GigePanel(ConsoleLayout console) {
        super(console);
    }

    public void initSubPanel() {
        this.manager = new GigeManager("10.0.10.72");
        this.manager.addDatagramListener(this);
        this.setLayout((LayoutManager)new MigLayout());
        this.setLayout((LayoutManager)new MigLayout());
        this.add(this.panel, "w 720!, h 480!, wrap");
        this.add(this.connect, "split");
        this.add(this.start, "");
        this.add(this.stop, "");
        this.add(this.record, "wrap");
        this.add(this.ipField, "w 100");
    }

    public void cleanSubPanel() {
        if (this.manager != null) {
            this.manager.stopStream();
            this.manager = null;
        }
    }

    @Override
    public void receivedDatagram(DatagramPacket packet) {
        try {
            byte[] buf = packet.getData();
            this.bb = ByteBuffer.wrap(buf);
            int type = this.bb.get(4) & 0xF;
            if (type == 1) {
                if (!this.trailerReceived && this.currentBlockId != -1) {
                    this.manager.requestResend(this.numPackets + 1, this.numPackets + 1, this.currentBlockId);
                    return;
                }
                this.trailerReceived = false;
                this.currentBlockId = this.bb.getShort(2);
                this.receivedList.clear();
                int sizeX = this.bb.getInt(24);
                int sizeY = this.bb.getInt(28);
                this.numPackets = sizeX * sizeY / (this.manager.packetSize - 8);
                if (this.debug) {
                    System.out.println("Leader of block ID: " + this.currentBlockId);
                    System.out.println("Payload type : " + this.bb.getShort(10));
                    System.out.println("Timestamp: " + this.bb.getLong(12));
                    System.out.println("Pixelformat: " + this.bb.getInt(20));
                    System.out.println("sx: " + this.bb.getInt(24));
                    System.out.println("sy: " + this.bb.getInt(28));
                    System.out.println("offx: " + this.bb.getInt(32));
                    System.out.println("offy: " + this.bb.getInt(36));
                    System.out.println("padx: " + this.bb.getShort(40));
                    System.out.println("pady: " + this.bb.getShort(42));
                    System.out.println("interleaving: " + (this.bb.get(8) & 0xF));
                    System.out.println("Number of packets in this block: " + this.numPackets);
                }
                this.panel.repaint();
            }
            if (type == 2) {
                int pid = this.bb.getInt(4) & 0xFFFFFF;
                System.out.println("Trailer of block ID: " + this.bb.getShort(2) + " pId : " + pid);
                for (int i = 1; i < pid; ++i) {
                    if (this.receivedList.contains(i)) continue;
                    System.out.println("Missing packet : " + i);
                    this.manager.requestResend(i, i, this.currentBlockId);
                }
                this.trailerReceived = true;
            }
            if (type == 3) {
                int pID = this.bb.getInt(4) & 0xFFFFFF;
                if (this.receivedList.contains(pID)) {
                    System.out.println("Repeated packet ID!");
                    return;
                }
                if (this.bb.getShort(2) != this.currentBlockId) {
                    System.out.println("wrong block! " + this.bb.getShort(2) + " " + this.currentBlockId);
                    return;
                }
                int x = (this.manager.getPacketSize() - 8) * (pID - 1);
                for (int index = 8; index < packet.getLength(); ++index) {
                    byte value;
                    this.ib[x] = value = this.bb.get(index);
                    ++x;
                }
                this.receivedList.add(pID);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        GigePanel panel = new GigePanel(null);
        panel.initSubPanel();
        frame.setLayout((LayoutManager)new MigLayout());
        frame.setSize(800, 600);
        frame.add((Component)((Object)panel), "w 800, h 600");
        frame.setVisible(true);
    }
}

