/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.scripting.jsai;

import org.web3d.vrml.lang.FieldException;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLNodeListener;
import org.web3d.vrml.nodes.VRMLNodeType;
import vrml.field.ConstMFFloat;

class JSAIConstMFFloat
extends ConstMFFloat
implements VRMLNodeListener {
    private VRMLNodeType node;
    private int fieldIndex;

    JSAIConstMFFloat(VRMLNodeType vRMLNodeType, int n) {
        this.node = vRMLNodeType;
        this.fieldIndex = n;
        this.valueChanged = true;
        this.updateLocalData();
        this.node.addNodeListener(this);
    }

    public void getValue(float[] fArray) {
        this.updateLocalData();
        super.getValue(fArray);
    }

    public float get1Value(int n) {
        this.updateLocalData();
        return super.get1Value(n);
    }

    public Object clone() {
        return new JSAIConstMFFloat(this.node, this.fieldIndex);
    }

    public String toString() {
        this.updateLocalData();
        return super.toString();
    }

    public void fieldChanged(int n) {
        if (n != this.fieldIndex) {
            return;
        }
        this.valueChanged = true;
    }

    private void updateLocalData() {
        if (!this.valueChanged) {
            return;
        }
        try {
            VRMLFieldData vRMLFieldData = this.node.getFieldValue(this.fieldIndex);
            if (vRMLFieldData == null) {
                return;
            }
            if (vRMLFieldData.numElements == 0) {
                this.numElements = 0;
                this.data = new float[0];
            } else {
                this.setValue(vRMLFieldData.numElements, vRMLFieldData.floatArrayValue);
            }
            this.valueChanged = false;
        }
        catch (FieldException fieldException) {
            // empty catch block
        }
    }

    private void setValue(int n, float[] fArray) {
        if (n > this.data.length) {
            this.data = new float[n];
        }
        System.arraycopy(fArray, 0, this.data, 0, n);
        this.numElements = n;
    }
}

