/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.scripting.jsai;

import org.web3d.vrml.lang.FieldException;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLNodeListener;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.scripting.jsai.FieldFactory;
import org.web3d.vrml.scripting.jsai.JSAINode;
import org.web3d.vrml.scripting.jsai.NodeField;
import vrml.BaseNode;
import vrml.Browser;
import vrml.field.ConstMFNode;

class JSAIConstMFNode
extends ConstMFNode
implements VRMLNodeListener,
NodeField {
    private VRMLNodeType node;
    private int fieldIndex;
    private FieldFactory fieldFactory;
    private Browser browser;

    JSAIConstMFNode(VRMLNodeType vRMLNodeType, int n) {
        this.node = vRMLNodeType;
        this.fieldIndex = n;
        this.node.addNodeListener(this);
    }

    public void initialize(Browser browser, FieldFactory fieldFactory) {
        this.browser = browser;
        this.fieldFactory = fieldFactory;
        this.valueChanged = true;
        this.updateLocalData();
    }

    public void getValue(BaseNode[] baseNodeArray) {
        this.updateLocalData();
        super.getValue(baseNodeArray);
    }

    public BaseNode get1Value(int n) {
        this.updateLocalData();
        return super.get1Value(n);
    }

    public String toString() {
        this.updateLocalData();
        return super.toString();
    }

    public Object clone() {
        return new JSAIConstMFNode(this.node, this.fieldIndex);
    }

    public void fieldChanged(int n) {
        if (n != this.fieldIndex) {
            return;
        }
        this.valueChanged = true;
    }

    private void updateLocalData() {
        if (!this.valueChanged) {
            return;
        }
        try {
            VRMLFieldData vRMLFieldData = this.node.getFieldValue(this.fieldIndex);
            if (vRMLFieldData == null) {
                return;
            }
            if (vRMLFieldData.numElements == 0) {
                this.numElements = 0;
                this.data = new BaseNode[0];
            } else {
                VRMLNodeType[] vRMLNodeTypeArray = (VRMLNodeType[])vRMLFieldData.nodeArrayValue;
                if (this.numElements != vRMLFieldData.numElements) {
                    this.numElements = vRMLFieldData.numElements;
                    this.data = new BaseNode[this.numElements];
                }
                for (int i = 0; i < this.numElements; ++i) {
                    this.data[i] = new JSAINode(vRMLNodeTypeArray[i], this.browser, this.fieldFactory);
                }
            }
            this.valueChanged = false;
        }
        catch (FieldException fieldException) {
            // empty catch block
        }
    }
}

