/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.scripting.jsai;

import org.web3d.vrml.lang.FieldException;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLNodeListener;
import org.web3d.vrml.nodes.VRMLNodeType;
import vrml.field.ConstMFString;

class JSAIConstMFString
extends ConstMFString
implements VRMLNodeListener {
    private VRMLNodeType node;
    private int fieldIndex;

    JSAIConstMFString(VRMLNodeType vRMLNodeType, int n) {
        this.node = vRMLNodeType;
        this.fieldIndex = n;
        this.valueChanged = true;
        this.updateLocalData();
        this.node.addNodeListener(this);
    }

    public void getValue(String[] stringArray) {
        this.updateLocalData();
        super.getValue(stringArray);
    }

    public String get1Value(int n) {
        this.updateLocalData();
        return super.get1Value(n);
    }

    public String toString() {
        this.updateLocalData();
        return super.toString();
    }

    public Object clone() {
        return new JSAIConstMFString(this.node, this.fieldIndex);
    }

    public void fieldChanged(int n) {
        if (n != this.fieldIndex) {
            return;
        }
        this.valueChanged = true;
    }

    private void updateLocalData() {
        if (!this.valueChanged) {
            return;
        }
        try {
            VRMLFieldData vRMLFieldData = this.node.getFieldValue(this.fieldIndex);
            if (vRMLFieldData == null) {
                return;
            }
            if (vRMLFieldData.numElements == 0) {
                this.numElements = 0;
                this.data = new String[0];
            } else {
                this.setValue(vRMLFieldData.numElements, vRMLFieldData.stringArrayValue);
            }
            this.valueChanged = false;
        }
        catch (FieldException fieldException) {
            // empty catch block
        }
    }

    private void setValue(int n, String[] stringArray) {
        if (n > this.data.length) {
            this.data = new String[n];
        }
        System.arraycopy(stringArray, 0, this.data, 0, n);
        this.numElements = n;
    }
}

