/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.scripting.jsai;

import org.web3d.vrml.lang.FieldException;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLNodeListener;
import org.web3d.vrml.nodes.VRMLNodeType;
import vrml.field.ConstMFVec2f;
import vrml.field.SFVec2f;

class JSAIConstMFVec2f
extends ConstMFVec2f
implements VRMLNodeListener {
    private VRMLNodeType node;
    private int fieldIndex;

    JSAIConstMFVec2f(VRMLNodeType vRMLNodeType, int n) {
        this.node = vRMLNodeType;
        this.fieldIndex = n;
        this.valueChanged = true;
        this.updateLocalData();
        this.node.addNodeListener(this);
    }

    public void getValue(float[][] fArray) {
        this.updateLocalData();
        super.getValue(fArray);
    }

    public void getValue(float[] fArray) {
        this.updateLocalData();
        super.getValue(fArray);
    }

    public void get1Value(int n, float[] fArray) {
        this.updateLocalData();
        super.get1Value(n, fArray);
    }

    public void get1Value(int n, SFVec2f sFVec2f) {
        this.updateLocalData();
        super.get1Value(n, sFVec2f);
    }

    public String toString() {
        this.updateLocalData();
        return super.toString();
    }

    public Object clone() {
        return new JSAIConstMFVec2f(this.node, this.fieldIndex);
    }

    public void fieldChanged(int n) {
        if (n != this.fieldIndex) {
            return;
        }
        this.valueChanged = true;
    }

    private void updateLocalData() {
        if (!this.valueChanged) {
            return;
        }
        try {
            VRMLFieldData vRMLFieldData = this.node.getFieldValue(this.fieldIndex);
            if (vRMLFieldData == null) {
                return;
            }
            if (vRMLFieldData.numElements == 0) {
                this.numElements = 0;
                this.data = new float[0];
            } else {
                this.setValue(vRMLFieldData.numElements * 2, vRMLFieldData.floatArrayValue);
            }
            this.valueChanged = false;
        }
        catch (FieldException fieldException) {
            // empty catch block
        }
    }

    private void setValue(int n, float[] fArray) {
        if (n > this.data.length) {
            this.data = new float[n];
        }
        this.numElements = n / 2;
        System.arraycopy(fArray, 0, this.data, 0, n);
    }
}

