/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.scripting.jsai;

import org.web3d.vrml.lang.FieldException;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLNodeListener;
import org.web3d.vrml.nodes.VRMLNodeType;
import vrml.field.ConstSFImage;

class JSAIConstSFImage
extends ConstSFImage
implements VRMLNodeListener {
    private VRMLNodeType node;
    private int fieldIndex;

    JSAIConstSFImage(VRMLNodeType vRMLNodeType, int n) {
        this.node = vRMLNodeType;
        this.fieldIndex = n;
        this.valueChanged = true;
        this.updateLocalData();
        this.node.addNodeListener(this);
    }

    public int getWidth() {
        this.updateLocalData();
        return this.imageWidth;
    }

    public int getHeight() {
        this.updateLocalData();
        return this.imageHeight;
    }

    public int getComponents() {
        this.updateLocalData();
        return this.imageComponents;
    }

    public void getPixels(byte[] byArray) {
        this.updateLocalData();
        System.out.println("Fetching SFImage pixels not implemented");
    }

    public Object clone() {
        return new JSAIConstSFImage(this.node, this.fieldIndex);
    }

    public void fieldChanged(int n) {
        if (n != this.fieldIndex) {
            return;
        }
        this.valueChanged = true;
    }

    private void updateLocalData() {
        if (!this.valueChanged) {
            return;
        }
        try {
            VRMLFieldData vRMLFieldData = this.node.getFieldValue(this.fieldIndex);
            if (vRMLFieldData == null) {
                this.imageWidth = 0;
                this.imageHeight = 0;
                this.imageComponents = 0;
            } else {
                this.imageWidth = vRMLFieldData.intArrayValue[0];
                this.imageHeight = vRMLFieldData.intArrayValue[1];
                this.imageComponents = vRMLFieldData.intArrayValue[2];
            }
        }
        catch (FieldException fieldException) {
            // empty catch block
        }
    }
}

