/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.scripting.jsai;

import org.web3d.vrml.lang.FieldException;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLNodeListener;
import org.web3d.vrml.nodes.VRMLNodeType;
import vrml.field.ConstSFRotation;

class JSAIConstSFRotation
extends ConstSFRotation
implements VRMLNodeListener {
    private VRMLNodeType node;
    private int fieldIndex;

    JSAIConstSFRotation(VRMLNodeType vRMLNodeType, int n) {
        this.node = vRMLNodeType;
        this.fieldIndex = n;
        this.valueChanged = true;
        this.updateLocalData();
        this.node.addNodeListener(this);
    }

    public void getValue(float[] fArray) {
        this.updateLocalData();
        fArray[0] = this.data[0];
        fArray[1] = this.data[1];
        fArray[2] = this.data[2];
        fArray[3] = this.data[3];
    }

    public Object clone() {
        return new JSAIConstSFRotation(this.node, this.fieldIndex);
    }

    public void fieldChanged(int n) {
        if (n != this.fieldIndex) {
            return;
        }
        this.valueChanged = true;
    }

    private void updateLocalData() {
        if (!this.valueChanged) {
            return;
        }
        try {
            VRMLFieldData vRMLFieldData = this.node.getFieldValue(this.fieldIndex);
            if (vRMLFieldData == null || vRMLFieldData.numElements == 0) {
                this.data[0] = 0.0f;
                this.data[1] = 0.0f;
                this.data[2] = 1.0f;
                this.data[3] = 0.0f;
            } else {
                this.data[0] = vRMLFieldData.floatArrayValue[0];
                this.data[1] = vRMLFieldData.floatArrayValue[1];
                this.data[2] = vRMLFieldData.floatArrayValue[2];
                this.data[3] = vRMLFieldData.floatArrayValue[3];
            }
            this.valueChanged = false;
        }
        catch (FieldException fieldException) {
            // empty catch block
        }
    }
}

