/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.scripting.jsai;

import org.web3d.util.ArrayUtils;
import org.web3d.vrml.lang.FieldException;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLNodeListener;
import org.web3d.vrml.nodes.VRMLNodeType;
import vrml.field.ConstSFColor;
import vrml.field.MFColor;
import vrml.field.SFColor;

class JSAIMFColor
extends MFColor
implements VRMLNodeListener {
    private VRMLNodeType node;
    private int fieldIndex;

    JSAIMFColor(VRMLNodeType vRMLNodeType, int n) {
        this.node = vRMLNodeType;
        this.fieldIndex = n;
        this.valueChanged = true;
        this.updateLocalData();
        this.node.addNodeListener(this);
    }

    public void getValue(float[][] fArray) {
        this.updateLocalData();
        ArrayUtils.raise3(this.data, this.numElements * 3, fArray);
    }

    public void getValue(float[] fArray) {
        this.updateLocalData();
        System.arraycopy(this.data, 0, fArray, 0, this.numElements * 3);
    }

    public void get1Value(int n, float[] fArray) {
        this.updateLocalData();
        int n2 = n * 3;
        fArray[0] = this.data[0];
        fArray[1] = this.data[1];
        fArray[2] = this.data[2];
    }

    public void get1Value(int n, SFColor sFColor) {
        this.updateLocalData();
        int n2 = n * 3;
        sFColor.setValue(this.data[n2], this.data[n2 + 1], this.data[n2 + 2]);
    }

    public void setValue(float[][] fArray) {
        super.setValue(fArray);
        this.updateCoreData();
    }

    public void setValue(float[] fArray) {
        super.setValue(fArray);
        this.updateCoreData();
    }

    public void setValue(int n, float[] fArray) {
        super.setValue(n, fArray);
        this.updateCoreData();
    }

    public void setValue(MFColor mFColor) {
        super.setValue(mFColor);
        this.updateCoreData();
    }

    public void set1Value(int n, ConstSFColor constSFColor) {
        super.set1Value(n, constSFColor);
        this.updateCoreData();
    }

    public void set1Value(int n, SFColor sFColor) {
        super.set1Value(n, sFColor);
        this.updateCoreData();
    }

    public void set1Value(int n, float f, float f2, float f3) {
        super.set1Value(n, f, f2, f3);
        this.updateCoreData();
    }

    public void addValue(ConstSFColor constSFColor) {
        super.addValue(constSFColor);
        this.updateCoreData();
    }

    public void addValue(SFColor sFColor) {
        super.addValue(sFColor);
        this.updateCoreData();
    }

    public void addValue(float f, float f2, float f3) {
        super.addValue(f, f2, f3);
        this.updateCoreData();
    }

    public void insertValue(int n, ConstSFColor constSFColor) {
        super.insertValue(n, constSFColor);
        this.updateCoreData();
    }

    public void insertValue(int n, SFColor sFColor) {
        super.insertValue(n, sFColor);
        this.updateCoreData();
    }

    public void insertValue(int n, float f, float f2, float f3) {
        super.insertValue(n, f, f2, f3);
        this.updateCoreData();
    }

    public void clear() {
        System.out.println("JSAIMFColor clear not implemented yet");
    }

    public void delete(int n) {
        super.delete(n);
        this.updateCoreData();
    }

    public Object clone() {
        return new JSAIMFColor(this.node, this.fieldIndex);
    }

    public String toString() {
        this.updateLocalData();
        return super.toString();
    }

    public void fieldChanged(int n) {
        if (n != this.fieldIndex) {
            return;
        }
        this.valueChanged = true;
    }

    private void updateLocalData() {
        if (!this.valueChanged) {
            return;
        }
        try {
            VRMLFieldData vRMLFieldData = this.node.getFieldValue(this.fieldIndex);
            if (vRMLFieldData == null) {
                return;
            }
            if (vRMLFieldData.numElements == 0) {
                this.numElements = 0;
                this.data = new float[0];
            } else {
                super.setValue(vRMLFieldData.numElements * 3, vRMLFieldData.floatArrayValue);
            }
            this.valueChanged = false;
        }
        catch (FieldException fieldException) {
            // empty catch block
        }
    }

    private void updateCoreData() {
        try {
            this.node.setValue(this.fieldIndex, this.data, this.numElements * 3);
        }
        catch (FieldException fieldException) {
            // empty catch block
        }
    }
}

