/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.scripting.jsai;

import org.web3d.vrml.lang.FieldException;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLNodeListener;
import org.web3d.vrml.nodes.VRMLNodeType;
import vrml.field.ConstMFInt32;
import vrml.field.ConstSFInt32;
import vrml.field.MFInt32;
import vrml.field.SFInt32;

class JSAIMFInt32
extends MFInt32
implements VRMLNodeListener {
    private VRMLNodeType node;
    private int fieldIndex;

    JSAIMFInt32(VRMLNodeType vRMLNodeType, int n) {
        this.node = vRMLNodeType;
        this.fieldIndex = n;
        this.valueChanged = true;
        this.updateLocalData();
        this.node.addNodeListener(this);
    }

    public void getValue(int[] nArray) {
        this.updateLocalData();
        super.getValue(nArray);
    }

    public int get1Value(int n) {
        this.updateLocalData();
        return super.get1Value(n);
    }

    public void setValue(int[] nArray) {
        super.setValue(nArray);
        this.updateCoreData();
    }

    public void setValue(int n, int[] nArray) {
        super.setValue(nArray);
        this.updateCoreData();
    }

    public void setValue(MFInt32 mFInt32) {
        super.setValue(mFInt32);
        this.updateCoreData();
    }

    public void setValue(ConstMFInt32 constMFInt32) {
        super.setValue(constMFInt32);
        this.updateCoreData();
    }

    public void set1Value(int n, int n2) {
        super.set1Value(n, n2);
        this.updateCoreData();
    }

    public void set1Value(int n, ConstSFInt32 constSFInt32) {
        super.set1Value(n, constSFInt32);
        this.updateCoreData();
    }

    public void set1Value(int n, SFInt32 sFInt32) {
        super.set1Value(n, sFInt32);
        this.updateCoreData();
    }

    public void addValue(int n) {
        super.addValue(n);
        this.updateCoreData();
    }

    public void addValue(ConstSFInt32 constSFInt32) {
        super.addValue(constSFInt32);
        this.updateCoreData();
    }

    public void addValue(SFInt32 sFInt32) {
        super.addValue(sFInt32);
        this.updateCoreData();
    }

    public void insertValue(int n, int n2) {
        super.insertValue(n, n2);
        this.updateCoreData();
    }

    public void insertValue(int n, ConstSFInt32 constSFInt32) {
        super.insertValue(n, constSFInt32);
        this.updateCoreData();
    }

    public void insertValue(int n, SFInt32 sFInt32) {
        super.insertValue(n, sFInt32);
        this.updateCoreData();
    }

    public void clear() {
        System.out.println("JSAIMFInt32 clear not implemented yet");
    }

    public void delete(int n) {
        super.delete(n);
        this.updateCoreData();
    }

    public String toString() {
        this.updateLocalData();
        return super.toString();
    }

    public Object clone() {
        return new JSAIMFInt32(this.node, this.fieldIndex);
    }

    public void fieldChanged(int n) {
        if (n != this.fieldIndex) {
            return;
        }
        this.valueChanged = true;
    }

    private void updateLocalData() {
        if (!this.valueChanged) {
            return;
        }
        try {
            VRMLFieldData vRMLFieldData = this.node.getFieldValue(this.fieldIndex);
            if (vRMLFieldData == null) {
                return;
            }
            if (vRMLFieldData.numElements == 0) {
                this.numElements = 0;
                this.data = new int[0];
            } else {
                super.setValue(vRMLFieldData.numElements, vRMLFieldData.intArrayValue);
            }
            this.valueChanged = false;
        }
        catch (FieldException fieldException) {
            // empty catch block
        }
    }

    private void updateCoreData() {
        try {
            this.node.setValue(this.fieldIndex, this.data, this.numElements);
        }
        catch (FieldException fieldException) {
            // empty catch block
        }
    }
}

