/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.scripting.jsai;

import org.web3d.vrml.lang.FieldException;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLNodeListener;
import org.web3d.vrml.nodes.VRMLNodeType;
import vrml.field.ConstMFString;
import vrml.field.ConstSFString;
import vrml.field.MFString;
import vrml.field.SFString;

class JSAIMFString
extends MFString
implements VRMLNodeListener {
    private VRMLNodeType node;
    private int fieldIndex;

    JSAIMFString(VRMLNodeType vRMLNodeType, int n) {
        this.node = vRMLNodeType;
        this.fieldIndex = n;
        this.node.addNodeListener(this);
        this.valueChanged = true;
        this.updateLocalData();
    }

    public void getValue(String[] stringArray) {
        this.updateLocalData();
        super.getValue(stringArray);
    }

    public String get1Value(int n) {
        this.updateLocalData();
        return super.get1Value(n);
    }

    public void setValue(String[] stringArray) {
        super.setValue(stringArray);
        this.updateCoreData();
    }

    public void setValue(int n, String[] stringArray) {
        super.setValue(n, stringArray);
        this.updateCoreData();
    }

    public void setValue(MFString mFString) {
        super.setValue(mFString);
        this.updateCoreData();
    }

    public void setValue(ConstMFString constMFString) {
        super.setValue(constMFString);
        this.updateCoreData();
    }

    public void set1Value(int n, String string) {
        super.set1Value(n, string);
        this.updateCoreData();
    }

    public void set1Value(int n, ConstSFString constSFString) {
        super.set1Value(n, constSFString);
        this.updateCoreData();
    }

    public void set1Value(int n, SFString sFString) {
        super.set1Value(n, sFString);
        this.updateCoreData();
    }

    public void addValue(String string) {
        super.addValue(string);
        this.updateCoreData();
    }

    public void addValue(ConstSFString constSFString) {
        super.addValue(constSFString);
        this.updateCoreData();
    }

    public void addValue(SFString sFString) {
        super.addValue(sFString);
        this.updateCoreData();
    }

    public void insertValue(int n, String string) {
        super.insertValue(n, string);
        this.updateCoreData();
    }

    public void insertValue(int n, ConstSFString constSFString) {
        super.insertValue(n, constSFString);
        this.updateCoreData();
    }

    public void insertValue(int n, SFString sFString) {
        super.insertValue(n, sFString);
        this.updateCoreData();
    }

    public void clear() {
        System.out.println("JSAIMFString clear not implemented yet");
    }

    public void delete(int n) {
        super.delete(n);
        this.updateCoreData();
    }

    public String toString() {
        this.updateLocalData();
        return super.toString();
    }

    public Object clone() {
        return new JSAIMFString(this.node, this.fieldIndex);
    }

    public void fieldChanged(int n) {
        if (n != this.fieldIndex) {
            return;
        }
        this.valueChanged = true;
    }

    private void updateLocalData() {
        if (!this.valueChanged) {
            return;
        }
        try {
            VRMLFieldData vRMLFieldData = this.node.getFieldValue(this.fieldIndex);
            if (vRMLFieldData == null) {
                return;
            }
            if (vRMLFieldData.numElements == 0) {
                this.numElements = 0;
                this.data = new String[0];
            } else {
                super.setValue(vRMLFieldData.numElements, vRMLFieldData.stringArrayValue);
            }
            this.valueChanged = false;
        }
        catch (FieldException fieldException) {
            // empty catch block
        }
    }

    private void updateCoreData() {
        try {
            this.node.setValue(this.fieldIndex, this.data, this.numElements);
        }
        catch (FieldException fieldException) {
            // empty catch block
        }
    }
}

