/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.scripting.jsai;

import org.web3d.vrml.lang.FieldException;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLNodeListener;
import org.web3d.vrml.nodes.VRMLNodeType;
import vrml.field.ConstMFTime;
import vrml.field.ConstSFTime;
import vrml.field.MFTime;
import vrml.field.SFTime;

class JSAIMFTime
extends MFTime
implements VRMLNodeListener {
    private VRMLNodeType node;
    private int fieldIndex;

    JSAIMFTime(VRMLNodeType vRMLNodeType, int n) {
        this.node = vRMLNodeType;
        this.fieldIndex = n;
        this.valueChanged = true;
        this.updateLocalData();
        this.node.addNodeListener(this);
    }

    public void getValue(double[] dArray) {
        this.updateLocalData();
        super.getValue(dArray);
    }

    public double get1Value(int n) {
        this.updateLocalData();
        return super.get1Value(n);
    }

    public void setValue(double[] dArray) {
        super.setValue(dArray);
        this.updateCoreData();
    }

    public void setValue(int n, double[] dArray) {
        super.setValue(dArray);
        this.updateCoreData();
    }

    public void setValue(MFTime mFTime) {
        super.setValue(mFTime);
        this.updateCoreData();
    }

    public void setValue(ConstMFTime constMFTime) {
        super.setValue(constMFTime);
        this.updateCoreData();
    }

    public void set1Value(int n, double d) {
        super.set1Value(n, d);
        this.updateCoreData();
    }

    public void set1Value(int n, ConstSFTime constSFTime) {
        super.set1Value(n, constSFTime);
        this.updateCoreData();
    }

    public void set1Value(int n, SFTime sFTime) {
        super.set1Value(n, sFTime);
        this.updateCoreData();
    }

    public void addValue(double d) {
        super.addValue(d);
        this.updateCoreData();
    }

    public void addValue(ConstSFTime constSFTime) {
        super.addValue(constSFTime);
        this.updateCoreData();
    }

    public void addValue(SFTime sFTime) {
        super.addValue(sFTime);
        this.updateCoreData();
    }

    public void insertValue(int n, double d) {
        super.insertValue(n, d);
        this.updateCoreData();
    }

    public void insertValue(int n, ConstSFTime constSFTime) {
        super.insertValue(n, constSFTime);
        this.updateCoreData();
    }

    public void insertValue(int n, SFTime sFTime) {
        super.insertValue(n, sFTime);
        this.updateCoreData();
    }

    public void clear() {
        System.out.println("JSAIMFTime clear not implemented yet");
    }

    public void delete(int n) {
        super.delete(n);
        this.updateCoreData();
    }

    public String toString() {
        this.updateLocalData();
        return super.toString();
    }

    public Object clone() {
        return new JSAIMFTime(this.node, this.fieldIndex);
    }

    public void fieldChanged(int n) {
        if (n != this.fieldIndex) {
            return;
        }
        this.valueChanged = true;
    }

    private void updateLocalData() {
        if (!this.valueChanged) {
            return;
        }
        try {
            VRMLFieldData vRMLFieldData = this.node.getFieldValue(this.fieldIndex);
            if (vRMLFieldData == null) {
                return;
            }
            if (vRMLFieldData.numElements == 0) {
                this.numElements = 0;
                this.data = new double[0];
            } else {
                super.setValue(vRMLFieldData.numElements, vRMLFieldData.doubleArrayValue);
            }
            this.valueChanged = false;
        }
        catch (FieldException fieldException) {
            // empty catch block
        }
    }

    private void updateCoreData() {
        try {
            this.node.setValue(this.fieldIndex, this.data, this.numElements);
        }
        catch (FieldException fieldException) {
            // empty catch block
        }
    }
}

