/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.scripting.jsai;

import org.web3d.vrml.lang.FieldException;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLNodeListener;
import org.web3d.vrml.nodes.VRMLNodeType;
import vrml.field.ConstMFVec2f;
import vrml.field.ConstSFVec2f;
import vrml.field.MFVec2f;
import vrml.field.SFVec2f;

class JSAIMFVec2f
extends MFVec2f
implements VRMLNodeListener {
    private VRMLNodeType node;
    private int fieldIndex;

    JSAIMFVec2f(VRMLNodeType vRMLNodeType, int n) {
        this.node = vRMLNodeType;
        this.fieldIndex = n;
        this.valueChanged = true;
        this.updateLocalData();
        this.node.addNodeListener(this);
    }

    public void getValue(float[][] fArray) {
        this.updateLocalData();
        super.getValue(fArray);
    }

    public void getValue(float[] fArray) {
        this.updateLocalData();
        super.getValue(fArray);
    }

    public void get1Value(int n, float[] fArray) {
        this.updateLocalData();
        super.get1Value(n, fArray);
    }

    public void get1Value(int n, SFVec2f sFVec2f) {
        this.updateLocalData();
        super.get1Value(n, sFVec2f);
    }

    public void setValue(float[][] fArray) {
        super.setValue(fArray);
        this.updateCoreData();
    }

    public void setValue(float[] fArray) {
        super.setValue(fArray);
        this.updateCoreData();
    }

    public void setValue(int n, float[] fArray) {
        super.setValue(n, fArray);
        this.updateCoreData();
    }

    public void setValue(MFVec2f mFVec2f) {
        super.setValue(mFVec2f);
        this.updateCoreData();
    }

    public void setValue(ConstMFVec2f constMFVec2f) {
        super.setValue(constMFVec2f);
        this.updateCoreData();
    }

    public void set1Value(int n, float f, float f2) {
        super.set1Value(n, f, f2);
        this.updateCoreData();
    }

    public void set1Value(int n, ConstSFVec2f constSFVec2f) {
        super.set1Value(n, constSFVec2f);
        this.updateCoreData();
    }

    public void set1Value(int n, SFVec2f sFVec2f) {
        super.set1Value(n, sFVec2f);
        this.updateCoreData();
    }

    public void addValue(float f, float f2) {
        super.addValue(f, f2);
        this.updateCoreData();
    }

    public void addValue(ConstSFVec2f constSFVec2f) {
        super.addValue(constSFVec2f);
        this.updateCoreData();
    }

    public void addValue(SFVec2f sFVec2f) {
        super.addValue(sFVec2f);
        this.updateCoreData();
    }

    public void insertValue(int n, float f, float f2) {
        super.insertValue(n, f, f2);
        this.updateCoreData();
    }

    public void insertValue(int n, ConstSFVec2f constSFVec2f) {
        super.insertValue(n, constSFVec2f);
        this.updateCoreData();
    }

    public void insertValue(int n, SFVec2f sFVec2f) {
        super.insertValue(n, sFVec2f);
        this.updateCoreData();
    }

    public void clear() {
        System.out.println("JSAIMFVec2f clear not implemented yet");
    }

    public void delete(int n) {
        super.delete(n);
        this.updateCoreData();
    }

    public String toString() {
        this.updateLocalData();
        return super.toString();
    }

    public Object clone() {
        return new JSAIMFVec2f(this.node, this.fieldIndex);
    }

    public void fieldChanged(int n) {
        if (n != this.fieldIndex) {
            return;
        }
        this.valueChanged = true;
    }

    private void updateLocalData() {
        if (!this.valueChanged) {
            return;
        }
        try {
            VRMLFieldData vRMLFieldData = this.node.getFieldValue(this.fieldIndex);
            if (vRMLFieldData == null) {
                return;
            }
            if (vRMLFieldData.numElements == 0) {
                this.numElements = 0;
                this.data = new float[0];
            } else {
                super.setValue(vRMLFieldData.numElements * 2, vRMLFieldData.floatArrayValue);
            }
            this.valueChanged = false;
        }
        catch (FieldException fieldException) {
            // empty catch block
        }
    }

    private void updateCoreData() {
        try {
            this.node.setValue(this.fieldIndex, this.data, this.numElements * 2);
        }
        catch (FieldException fieldException) {
            // empty catch block
        }
    }
}

