/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.scripting.jsai;

import org.web3d.vrml.lang.FieldException;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLNodeListener;
import org.web3d.vrml.nodes.VRMLNodeType;
import vrml.field.ConstSFFloat;
import vrml.field.SFFloat;

class JSAISFFloat
extends SFFloat
implements VRMLNodeListener {
    private VRMLNodeType node;
    private int fieldIndex;

    JSAISFFloat(VRMLNodeType vRMLNodeType, int n) {
        this.node = vRMLNodeType;
        this.fieldIndex = n;
        this.valueChanged = true;
        this.updateLocalData();
        this.node.addNodeListener(this);
    }

    public float getValue() {
        this.updateLocalData();
        return this.data;
    }

    public void setValue(float f) {
        this.data = f;
        try {
            this.node.setValue(this.fieldIndex, f);
        }
        catch (FieldException fieldException) {
            // empty catch block
        }
    }

    public void setValue(SFFloat sFFloat) {
        this.data = sFFloat.getValue();
        try {
            this.node.setValue(this.fieldIndex, this.data);
        }
        catch (FieldException fieldException) {
            // empty catch block
        }
    }

    public void setValue(ConstSFFloat constSFFloat) {
        this.data = constSFFloat.getValue();
        try {
            this.node.setValue(this.fieldIndex, this.data);
        }
        catch (FieldException fieldException) {
            // empty catch block
        }
    }

    public Object clone() {
        return new JSAISFFloat(this.node, this.fieldIndex);
    }

    public void fieldChanged(int n) {
        if (n != this.fieldIndex) {
            return;
        }
        this.valueChanged = true;
    }

    private void updateLocalData() {
        if (!this.valueChanged) {
            return;
        }
        try {
            VRMLFieldData vRMLFieldData = this.node.getFieldValue(this.fieldIndex);
            this.data = vRMLFieldData == null ? 0.0f : vRMLFieldData.floatValue;
            this.valueChanged = true;
        }
        catch (FieldException fieldException) {
            // empty catch block
        }
    }
}

