/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.scripting.jsai;

import org.web3d.vrml.lang.FieldException;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLNodeListener;
import org.web3d.vrml.nodes.VRMLNodeType;
import vrml.field.ConstSFString;
import vrml.field.SFString;

class JSAISFString
extends SFString
implements VRMLNodeListener {
    private VRMLNodeType node;
    private int fieldIndex;

    JSAISFString(VRMLNodeType vRMLNodeType, int n) {
        this.node = vRMLNodeType;
        this.fieldIndex = n;
        this.valueChanged = true;
        this.updateLocalData();
        this.node.addNodeListener(this);
    }

    public String getValue() {
        this.updateLocalData();
        return this.data;
    }

    public void setValue(String string) {
        this.data = string;
        try {
            this.node.setValue(this.fieldIndex, string);
        }
        catch (FieldException fieldException) {
            // empty catch block
        }
    }

    public void setValue(SFString sFString) {
        this.data = sFString.getValue();
        try {
            this.node.setValue(this.fieldIndex, this.data);
        }
        catch (FieldException fieldException) {
            // empty catch block
        }
    }

    public void setValue(ConstSFString constSFString) {
        this.data = constSFString.getValue();
        try {
            this.node.setValue(this.fieldIndex, this.data);
        }
        catch (FieldException fieldException) {
            // empty catch block
        }
    }

    public Object clone() {
        return new JSAISFString(this.node, this.fieldIndex);
    }

    public void fieldChanged(int n) {
        if (n != this.fieldIndex) {
            return;
        }
        this.valueChanged = true;
    }

    private void updateLocalData() {
        if (!this.valueChanged) {
            return;
        }
        try {
            VRMLFieldData vRMLFieldData = this.node.getFieldValue(this.fieldIndex);
            this.data = vRMLFieldData == null ? null : vRMLFieldData.stringValue;
            this.valueChanged = true;
        }
        catch (FieldException fieldException) {
            // empty catch block
        }
    }
}

