/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.scripting.jsai;

import org.web3d.vrml.lang.FieldException;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLNodeListener;
import org.web3d.vrml.nodes.VRMLNodeType;
import vrml.field.ConstSFTime;
import vrml.field.SFTime;

class JSAISFTime
extends SFTime
implements VRMLNodeListener {
    private VRMLNodeType node;
    private int fieldIndex;

    JSAISFTime(VRMLNodeType vRMLNodeType, int n) {
        this.node = vRMLNodeType;
        this.fieldIndex = n;
        this.valueChanged = true;
        this.updateLocalData();
        this.node.addNodeListener(this);
    }

    public double getValue() {
        this.updateLocalData();
        return this.data;
    }

    public void setValue(double d) {
        this.data = d;
        try {
            this.node.setValue(this.fieldIndex, d);
        }
        catch (FieldException fieldException) {
            // empty catch block
        }
    }

    public void setValue(SFTime sFTime) {
        this.data = sFTime.getValue();
        try {
            this.node.setValue(this.fieldIndex, this.data);
        }
        catch (FieldException fieldException) {
            // empty catch block
        }
    }

    public void setValue(ConstSFTime constSFTime) {
        this.data = constSFTime.getValue();
        try {
            this.node.setValue(this.fieldIndex, this.data);
        }
        catch (FieldException fieldException) {
            // empty catch block
        }
    }

    public Object clone() {
        return new JSAISFTime(this.node, this.fieldIndex);
    }

    public void fieldChanged(int n) {
        if (n != this.fieldIndex) {
            return;
        }
        this.valueChanged = true;
    }

    private void updateLocalData() {
        if (!this.valueChanged) {
            return;
        }
        try {
            VRMLFieldData vRMLFieldData = this.node.getFieldValue(this.fieldIndex);
            this.data = vRMLFieldData == null ? 0.0 : vRMLFieldData.doubleValue;
            this.valueChanged = false;
        }
        catch (FieldException fieldException) {
            // empty catch block
        }
    }
}

