/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.scripting.jsai;

import java.io.IOException;
import java.util.HashMap;
import org.web3d.browser.BrowserCore;
import org.web3d.util.DefaultErrorReporter;
import org.web3d.util.ErrorReporter;
import org.web3d.vrml.lang.BasicScene;
import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.lang.VRMLException;
import org.web3d.vrml.lang.VRMLExecutionSpace;
import org.web3d.vrml.lang.VRMLNodeFactory;
import org.web3d.vrml.nodes.FrameStateManager;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.nodes.loader.WorldLoaderManager;
import org.web3d.vrml.nodes.runtime.RouteManager;
import org.web3d.vrml.sav.VRMLParseException;
import org.web3d.vrml.scripting.browser.VRML97CommonBrowser;
import org.web3d.vrml.scripting.jsai.JSAIFieldFactory;
import org.web3d.vrml.scripting.jsai.JSAINode;
import vrml.BaseNode;
import vrml.Browser;
import vrml.InvalidEventInException;
import vrml.InvalidVRMLSyntaxException;

class ScriptBrowser
extends Browser {
    private ErrorReporter errorReporter;
    private JSAIFieldFactory fieldFactory;
    private VRMLExecutionSpace execSpace;
    private VRML97CommonBrowser realBrowser;

    ScriptBrowser(VRMLExecutionSpace vRMLExecutionSpace, BrowserCore browserCore, RouteManager routeManager, FrameStateManager frameStateManager, WorldLoaderManager worldLoaderManager) {
        BasicScene basicScene = vRMLExecutionSpace.getContainedScene();
        VRMLNodeFactory vRMLNodeFactory = basicScene.getNodeFactory();
        this.realBrowser = new VRML97CommonBrowser(browserCore, routeManager, frameStateManager, worldLoaderManager, vRMLNodeFactory);
        this.execSpace = vRMLExecutionSpace;
        this.fieldFactory = new JSAIFieldFactory();
        this.errorReporter = DefaultErrorReporter.getDefaultReporter();
        this.realBrowser.setErrorReporter(this.errorReporter);
    }

    public String getDescription() {
        return this.realBrowser.getDescription();
    }

    public void setDescription(String string) {
        this.realBrowser.setDescription(string);
    }

    public String getName() {
        return this.realBrowser.getName();
    }

    public String getVersion() {
        return this.realBrowser.getVersion();
    }

    public float getCurrentSpeed() {
        return this.realBrowser.getCurrentSpeed();
    }

    public float getCurrentFrameRate() {
        return this.realBrowser.getCurrentFrameRate();
    }

    public String getWorldURL() {
        return this.realBrowser.getWorldURL();
    }

    public void replaceWorld(BaseNode[] baseNodeArray) {
        String string = baseNodeArray[0].getBrowser().getWorldURL();
        int n = baseNodeArray.length;
        VRMLNodeType[] vRMLNodeTypeArray = new VRMLNodeType[n];
        for (int i = 0; i < n; ++i) {
            vRMLNodeTypeArray[i] = baseNodeArray[i].getImplNode();
        }
        this.realBrowser.replaceWorld(vRMLNodeTypeArray);
    }

    public BaseNode[] createVrmlFromString(String string) throws InvalidVRMLSyntaxException {
        BaseNode[] baseNodeArray = null;
        try {
            VRMLNodeType[] vRMLNodeTypeArray = this.realBrowser.createVrmlFromString(string, this.execSpace);
            if (vRMLNodeTypeArray == null || vRMLNodeTypeArray.length == 0) {
                throw new InvalidVRMLSyntaxException("No node declarations");
            }
            baseNodeArray = new BaseNode[vRMLNodeTypeArray.length];
            for (int i = 0; i < vRMLNodeTypeArray.length; ++i) {
                baseNodeArray[i] = new JSAINode(vRMLNodeTypeArray[i], this, this.fieldFactory);
            }
        }
        catch (VRMLParseException vRMLParseException) {
            throw new InvalidVRMLSyntaxException(vRMLParseException.getMessage());
        }
        catch (VRMLException vRMLException) {
            throw new InvalidVRMLSyntaxException(vRMLException.getMessage());
        }
        catch (IOException iOException) {
            throw new InvalidVRMLSyntaxException(iOException.getMessage());
        }
        return baseNodeArray;
    }

    public void createVrmlFromURL(String[] stringArray, BaseNode baseNode, String string) throws InvalidVRMLSyntaxException {
        VRMLNodeType vRMLNodeType = baseNode.getImplNode();
        try {
            this.realBrowser.createVrmlFromURL(stringArray, vRMLNodeType, string);
        }
        catch (InvalidFieldException invalidFieldException) {
            throw new InvalidEventInException("Unknown field: " + string);
        }
    }

    public void addRoute(BaseNode baseNode, String string, BaseNode baseNode2, String string2) {
        VRMLNodeType vRMLNodeType = baseNode.getImplNode();
        VRMLNodeType vRMLNodeType2 = baseNode2.getImplNode();
        try {
            this.realBrowser.addRoute(this.execSpace, vRMLNodeType, string, vRMLNodeType2, string2);
        }
        catch (InvalidFieldException invalidFieldException) {
            throw new InvalidEventInException(invalidFieldException.getMessage());
        }
    }

    public void deleteRoute(BaseNode baseNode, String string, BaseNode baseNode2, String string2) {
        VRMLNodeType vRMLNodeType = baseNode.getImplNode();
        VRMLNodeType vRMLNodeType2 = baseNode2.getImplNode();
        try {
            this.realBrowser.deleteRoute(this.execSpace, vRMLNodeType, string, vRMLNodeType2, string2);
        }
        catch (InvalidFieldException invalidFieldException) {
            throw new InvalidEventInException(invalidFieldException.getMessage());
        }
    }

    public void loadURL(String[] stringArray, String[] stringArray2) throws InvalidVRMLSyntaxException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        int n = stringArray2 == null ? 0 : stringArray2.length;
        for (int i = 0; i < n; ++i) {
            int n2 = stringArray2[i].indexOf(61);
            String string = stringArray2[i].substring(0, n2);
            String string2 = stringArray2[i].substring(n2 + 1);
            hashMap.put(string, string2);
        }
        this.realBrowser.loadURL(stringArray, hashMap);
    }

    public void setErrorReporter(ErrorReporter errorReporter) {
        this.errorReporter = errorReporter;
        if (errorReporter == null) {
            this.errorReporter = DefaultErrorReporter.getDefaultReporter();
        }
        this.realBrowser.setErrorReporter(errorReporter);
    }
}

