/*
 * Decompiled with CFR 0.152.
 */
package vrml.field;

import vrml.MField;
import vrml.field.ConstMFInt32;
import vrml.field.ConstSFInt32;
import vrml.field.SFInt32;

public class MFInt32
extends MField {
    protected static final int ARRAY_INC = 5;
    protected int[] data;

    public MFInt32() {
        this.data = new int[5];
        this.numElements = 0;
    }

    public MFInt32(int[] nArray) {
        this.numElements = nArray.length;
        this.data = new int[this.numElements];
        System.arraycopy(nArray, 0, this.data, 0, this.numElements);
    }

    public MFInt32(int n, int[] nArray) {
        this.numElements = n;
        this.data = new int[n];
        System.arraycopy(nArray, 0, this.data, 0, n);
    }

    public void getValue(int[] nArray) {
        System.arraycopy(this.data, 0, nArray, 0, this.numElements);
    }

    public int get1Value(int n) {
        if (n >= this.numElements) {
            throw new IllegalArgumentException("Index > numElements");
        }
        return this.data[n];
    }

    public void setValue(int[] nArray) {
        if (nArray.length > this.data.length) {
            this.data = new int[nArray.length];
        }
        System.arraycopy(nArray, 0, this.data, 0, nArray.length);
        this.numElements = nArray.length;
    }

    public void setValue(int n, int[] nArray) {
        if (n > this.data.length) {
            this.data = new int[n];
        }
        System.arraycopy(nArray, 0, this.data, 0, n);
        this.numElements = n;
    }

    public void setValue(MFInt32 mFInt32) {
        int n = mFInt32.getSize();
        if (n > this.data.length) {
            this.data = new int[n];
        }
        mFInt32.getValue(this.data);
    }

    public void setValue(ConstMFInt32 constMFInt32) {
        int n = constMFInt32.getSize();
        if (n > this.data.length) {
            this.data = new int[n];
        }
        constMFInt32.getValue(this.data);
    }

    public void set1Value(int n, int n2) {
        if (n >= this.numElements) {
            throw new ArrayIndexOutOfBoundsException("Index > numElements");
        }
        this.data[n] = n2;
    }

    public void set1Value(int n, ConstSFInt32 constSFInt32) {
        if (n >= this.numElements) {
            throw new ArrayIndexOutOfBoundsException("Index > numElements");
        }
        this.data[n] = constSFInt32.getValue();
    }

    public void set1Value(int n, SFInt32 sFInt32) {
        if (n >= this.numElements) {
            throw new ArrayIndexOutOfBoundsException("Index > numElements");
        }
        this.data[n] = sFInt32.getValue();
    }

    public void addValue(int n) {
        this.realloc();
        this.data[this.numElements++] = n;
    }

    public void addValue(SFInt32 sFInt32) {
        this.realloc();
        this.data[this.numElements++] = sFInt32.getValue();
    }

    public void addValue(ConstSFInt32 constSFInt32) {
        this.realloc();
        this.data[this.numElements++] = constSFInt32.getValue();
    }

    public void insertValue(int n, int n2) {
        if (n >= this.numElements) {
            throw new ArrayIndexOutOfBoundsException("Index > numElements");
        }
        this.makeHole(n);
        this.data[n] = n2;
        ++this.numElements;
    }

    public void insertValue(int n, ConstSFInt32 constSFInt32) {
        if (n >= this.numElements) {
            throw new ArrayIndexOutOfBoundsException("Index > numElements");
        }
        this.makeHole(n);
        this.data[n] = constSFInt32.getValue();
        ++this.numElements;
    }

    public void insertValue(int n, SFInt32 sFInt32) {
        if (n >= this.numElements) {
            throw new ArrayIndexOutOfBoundsException("Index > numElements");
        }
        this.makeHole(n);
        this.data[n] = sFInt32.getValue();
        ++this.numElements;
    }

    public void clear() {
        this.numElements = 0;
    }

    public void delete(int n) {
        if (n < 0 || n >= this.numElements) {
            throw new ArrayIndexOutOfBoundsException("Invalid index");
        }
        int n2 = n * 3;
        int n3 = this.numElements * 3 - n2;
        if (n3 != 0) {
            System.arraycopy(this.data, n2 + 3, this.data, n2, n3);
        }
        --this.numElements;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("[\n  ");
        int n = 0;
        for (int i = 0; i < this.numElements; ++i) {
            stringBuffer.append(this.data[n++]);
            stringBuffer.append(' ');
            if (i % 6 != 0) continue;
            stringBuffer.append("\n  ");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public Object clone() {
        return new MFInt32(this.numElements, this.data);
    }

    private void realloc() {
        if (this.numElements >= this.data.length) {
            int n = this.numElements + 5;
            int[] nArray = new int[n];
            System.arraycopy(this.data, 0, nArray, 0, this.data.length);
            this.data = nArray;
        }
    }

    private void makeHole(int n) {
        int n2 = this.numElements - n;
        if (this.numElements >= this.data.length) {
            int n3 = this.numElements + 5;
            int[] nArray = new int[n3];
            System.arraycopy(this.data, 0, nArray, 0, n - 1);
            System.arraycopy(this.data, n, nArray, n + 1, n2);
            this.data = nArray;
        } else {
            System.arraycopy(this.data, n, this.data, n + 1, n2);
        }
    }
}

