/*
 * Decompiled with CFR 0.152.
 */
package vrml.field;

import vrml.BaseNode;
import vrml.MField;
import vrml.field.ConstMFNode;
import vrml.field.ConstSFNode;
import vrml.field.SFNode;

public class MFNode
extends MField {
    protected static final int ARRAY_INC = 5;
    protected BaseNode[] data;

    public MFNode() {
        this.data = new BaseNode[5];
        this.numElements = 0;
    }

    public MFNode(BaseNode[] baseNodeArray) {
        this.numElements = baseNodeArray.length;
        this.data = new BaseNode[this.numElements];
        System.arraycopy(baseNodeArray, 0, this.data, 0, this.numElements);
    }

    public MFNode(int n, BaseNode[] baseNodeArray) {
        this.numElements = n;
        this.data = new BaseNode[n];
        System.arraycopy(baseNodeArray, 0, this.data, 0, n);
    }

    public void getValue(BaseNode[] baseNodeArray) {
        System.arraycopy(this.data, 0, baseNodeArray, 0, this.numElements);
    }

    public BaseNode get1Value(int n) {
        if (n >= this.numElements) {
            throw new IllegalArgumentException("Index > numElements");
        }
        return this.data[n];
    }

    public void setValue(BaseNode[] baseNodeArray) {
        if (baseNodeArray.length > this.data.length) {
            this.data = new BaseNode[baseNodeArray.length];
        }
        System.arraycopy(baseNodeArray, 0, this.data, 0, baseNodeArray.length);
        this.numElements = baseNodeArray.length;
    }

    public void setValue(int n, BaseNode[] baseNodeArray) {
        if (n > this.data.length) {
            this.data = new BaseNode[n];
        }
        System.arraycopy(baseNodeArray, 0, this.data, 0, n);
        this.numElements = n;
    }

    public void setValue(MFNode mFNode) {
        int n = mFNode.getSize();
        if (n > this.data.length) {
            this.data = new BaseNode[n];
        }
        mFNode.getValue(this.data);
        this.numElements = n;
    }

    public void setValue(ConstMFNode constMFNode) {
        int n = constMFNode.getSize();
        if (n > this.data.length) {
            this.data = new BaseNode[n];
        }
        constMFNode.getValue(this.data);
        this.numElements = n;
    }

    public void set1Value(int n, BaseNode baseNode) {
        if (n >= this.numElements) {
            throw new ArrayIndexOutOfBoundsException("Index > numElements");
        }
        this.data[n] = baseNode;
    }

    public void set1Value(int n, ConstSFNode constSFNode) {
        if (n >= this.numElements) {
            throw new ArrayIndexOutOfBoundsException("Index > numElements");
        }
        this.data[n] = constSFNode.getValue();
    }

    public void set1Value(int n, SFNode sFNode) {
        if (n >= this.numElements) {
            throw new ArrayIndexOutOfBoundsException("Index > numElements");
        }
        this.data[n] = sFNode.getValue();
    }

    public void addValue(BaseNode baseNode) {
        this.realloc();
        this.data[this.numElements++] = baseNode;
    }

    public void addValue(SFNode sFNode) {
        this.realloc();
        this.data[this.numElements++] = sFNode.getValue();
    }

    public void addValue(ConstSFNode constSFNode) {
        this.realloc();
        this.data[this.numElements++] = constSFNode.getValue();
    }

    public void insertValue(int n, BaseNode baseNode) {
        if (n >= this.numElements) {
            throw new ArrayIndexOutOfBoundsException("Index > numElements");
        }
        this.makeHole(n);
        this.data[n] = baseNode;
        ++this.numElements;
    }

    public void insertValue(int n, ConstSFNode constSFNode) {
        if (n >= this.numElements) {
            throw new ArrayIndexOutOfBoundsException("Index > numElements");
        }
        this.makeHole(n);
        this.data[n] = constSFNode.getValue();
        ++this.numElements;
    }

    public void insertValue(int n, SFNode sFNode) {
        if (n >= this.numElements) {
            throw new ArrayIndexOutOfBoundsException("Index > numElements");
        }
        this.makeHole(n);
        this.data[n] = sFNode.getValue();
        ++this.numElements;
    }

    public void clear() {
        this.numElements = 0;
    }

    public void delete(int n) {
        if (n < 0 || n >= this.numElements) {
            throw new ArrayIndexOutOfBoundsException("Invalid index");
        }
        int n2 = n * 3;
        int n3 = this.numElements * 3 - n2;
        if (n3 != 0) {
            System.arraycopy(this.data, n2 + 3, this.data, n2, n3);
        }
        --this.numElements;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("[\n  ");
        int n = 0;
        for (int i = 0; i < this.numElements; ++i) {
            stringBuffer.append(this.data[n++]);
            stringBuffer.append(' ');
            if (i % 6 != 0) continue;
            stringBuffer.append("\n  ");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public Object clone() {
        return new MFNode(this.numElements, this.data);
    }

    private void realloc() {
        if (this.numElements >= this.data.length) {
            int n = this.numElements + 5;
            BaseNode[] baseNodeArray = new BaseNode[n];
            System.arraycopy(this.data, 0, baseNodeArray, 0, this.data.length);
            this.data = baseNodeArray;
        }
    }

    private void makeHole(int n) {
        int n2 = this.numElements - n;
        if (this.numElements >= this.data.length) {
            int n3 = this.numElements + 5;
            BaseNode[] baseNodeArray = new BaseNode[n3];
            System.arraycopy(this.data, 0, baseNodeArray, 0, n - 1);
            System.arraycopy(this.data, n, baseNodeArray, n + 1, n2);
            this.data = baseNodeArray;
        } else {
            System.arraycopy(this.data, n, this.data, n + 1, n2);
        }
    }
}

