/*
 * Decompiled with CFR 0.152.
 */
package vrml.field;

import vrml.MField;
import vrml.field.ConstMFTime;
import vrml.field.ConstSFTime;
import vrml.field.SFTime;

public class MFTime
extends MField {
    protected static final int ARRAY_INC = 5;
    protected double[] data;

    public MFTime() {
        this.data = new double[5];
        this.numElements = 0;
    }

    public MFTime(double[] dArray) {
        this.numElements = dArray.length;
        this.data = new double[this.numElements];
        System.arraycopy(dArray, 0, this.data, 0, this.numElements);
    }

    public MFTime(int n, double[] dArray) {
        this.numElements = n;
        this.data = new double[n];
        System.arraycopy(dArray, 0, this.data, 0, n);
    }

    public void getValue(double[] dArray) {
        System.arraycopy(this.data, 0, dArray, 0, this.numElements);
    }

    public double get1Value(int n) {
        if (n >= this.numElements) {
            throw new IllegalArgumentException("Index > numElements");
        }
        return this.data[n];
    }

    public void setValue(double[] dArray) {
        if (dArray.length > this.data.length) {
            this.data = new double[dArray.length];
        }
        System.arraycopy(dArray, 0, this.data, 0, dArray.length);
        this.numElements = dArray.length;
    }

    public void setValue(int n, double[] dArray) {
        if (n > this.data.length) {
            this.data = new double[n];
        }
        System.arraycopy(dArray, 0, this.data, 0, n);
        this.numElements = n;
    }

    public void setValue(MFTime mFTime) {
        int n = mFTime.getSize();
        if (n > this.data.length) {
            this.data = new double[n];
        }
        mFTime.getValue(this.data);
    }

    public void setValue(ConstMFTime constMFTime) {
        int n = constMFTime.getSize();
        if (n > this.data.length) {
            this.data = new double[n];
        }
        constMFTime.getValue(this.data);
    }

    public void set1Value(int n, double d) {
        if (n >= this.numElements) {
            throw new ArrayIndexOutOfBoundsException("Index > numElements");
        }
        this.data[n] = d;
    }

    public void set1Value(int n, ConstSFTime constSFTime) {
        if (n >= this.numElements) {
            throw new ArrayIndexOutOfBoundsException("Index > numElements");
        }
        this.data[n] = constSFTime.getValue();
    }

    public void set1Value(int n, SFTime sFTime) {
        if (n >= this.numElements) {
            throw new ArrayIndexOutOfBoundsException("Index > numElements");
        }
        this.data[n] = sFTime.getValue();
    }

    public void addValue(double d) {
        this.realloc();
        this.data[this.numElements++] = d;
    }

    public void addValue(SFTime sFTime) {
        this.realloc();
        this.data[this.numElements++] = sFTime.getValue();
    }

    public void addValue(ConstSFTime constSFTime) {
        this.realloc();
        this.data[this.numElements++] = constSFTime.getValue();
    }

    public void insertValue(int n, double d) {
        if (n >= this.numElements) {
            throw new ArrayIndexOutOfBoundsException("Index > numElements");
        }
        this.makeHole(n);
        this.data[n] = d;
        ++this.numElements;
    }

    public void insertValue(int n, ConstSFTime constSFTime) {
        if (n >= this.numElements) {
            throw new ArrayIndexOutOfBoundsException("Index > numElements");
        }
        this.makeHole(n);
        this.data[n] = constSFTime.getValue();
        ++this.numElements;
    }

    public void insertValue(int n, SFTime sFTime) {
        if (n >= this.numElements) {
            throw new ArrayIndexOutOfBoundsException("Index > numElements");
        }
        this.makeHole(n);
        this.data[n] = sFTime.getValue();
        ++this.numElements;
    }

    public void clear() {
        this.numElements = 0;
    }

    public void delete(int n) {
        if (n < 0 || n >= this.numElements) {
            throw new ArrayIndexOutOfBoundsException("Invalid index");
        }
        int n2 = n * 3;
        int n3 = this.numElements * 3 - n2;
        if (n3 != 0) {
            System.arraycopy(this.data, n2 + 3, this.data, n2, n3);
        }
        --this.numElements;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("[\n  ");
        int n = 0;
        for (int i = 0; i < this.numElements; ++i) {
            stringBuffer.append(this.data[n++]);
            stringBuffer.append(' ');
            if (i % 6 != 0) continue;
            stringBuffer.append("\n  ");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public Object clone() {
        return new MFTime(this.numElements, this.data);
    }

    private void realloc() {
        if (this.numElements >= this.data.length) {
            int n = this.numElements + 5;
            double[] dArray = new double[n];
            System.arraycopy(this.data, 0, dArray, 0, this.data.length);
            this.data = dArray;
        }
    }

    private void makeHole(int n) {
        int n2 = this.numElements - n;
        if (this.numElements >= this.data.length) {
            int n3 = this.numElements + 5;
            double[] dArray = new double[n3];
            System.arraycopy(this.data, 0, dArray, 0, n - 1);
            System.arraycopy(this.data, n, dArray, n + 1, n2);
            this.data = dArray;
        } else {
            System.arraycopy(this.data, n, this.data, n + 1, n2);
        }
    }
}

