/*
 * Decompiled with CFR 0.152.
 */
package vrml.field;

import org.web3d.util.ArrayUtils;
import vrml.MField;
import vrml.field.ConstMFVec2f;
import vrml.field.ConstSFVec2f;
import vrml.field.SFVec2f;

public class MFVec2f
extends MField {
    protected static final int ARRAY_INC = 10;
    protected float[] data;

    public MFVec2f() {
        this.data = new float[10];
        this.numElements = 0;
    }

    public MFVec2f(float[][] fArray) {
        this.data = new float[fArray.length * 2];
        ArrayUtils.flatten2(fArray, fArray.length, this.data);
        this.numElements = fArray.length;
    }

    public MFVec2f(float[] fArray) {
        if (fArray.length < 2) {
            throw new IllegalArgumentException("Array length less than 2");
        }
        this.numElements = fArray.length / 2;
        int n = this.numElements * 2;
        this.data = new float[n];
        System.arraycopy(fArray, 0, this.data, 0, n);
    }

    public MFVec2f(int n, float[] fArray) {
        if (fArray.length < 2) {
            throw new IllegalArgumentException("Array length less than 2");
        }
        this.numElements = n / 2;
        this.data = new float[fArray.length];
        System.arraycopy(fArray, 0, this.data, 0, fArray.length);
    }

    public void getValue(float[][] fArray) {
        ArrayUtils.raise2(this.data, this.numElements, fArray);
    }

    public void getValue(float[] fArray) {
        System.arraycopy(this.data, 0, fArray, 0, this.numElements * 2);
    }

    public void get1Value(int n, float[] fArray) {
        if (n >= this.numElements) {
            throw new IllegalArgumentException("Index > numElements");
        }
        int n2 = n * 2;
        fArray[0] = this.data[n2++];
        fArray[1] = this.data[n2];
    }

    public void get1Value(int n, SFVec2f sFVec2f) {
        if (n >= this.numElements) {
            throw new IllegalArgumentException("Index > numElements");
        }
        int n2 = n * 2;
        sFVec2f.setValue(this.data[n2], this.data[n2 + 1]);
    }

    public void setValue(float[][] fArray) {
        if (fArray.length > this.numElements) {
            this.data = new float[fArray.length * 2];
        }
        this.numElements = fArray.length;
        ArrayUtils.flatten2(fArray, this.numElements, this.data);
    }

    public void setValue(float[] fArray) {
        int n = fArray.length / 2;
        if (n > this.numElements) {
            this.data = new float[n * 2];
        }
        this.numElements = n;
        System.arraycopy(fArray, 0, this.data, 0, n * 2);
    }

    public void setValue(int n, float[] fArray) {
        if (n > this.data.length) {
            this.data = new float[n];
        }
        this.numElements = n / 2;
        System.arraycopy(fArray, 0, this.data, 0, n);
    }

    public void setValue(MFVec2f mFVec2f) {
        int n = mFVec2f.getSize();
        if (n > this.numElements) {
            this.data = new float[n * 2];
        }
        this.numElements = n;
        mFVec2f.getValue(this.data);
    }

    public void setValue(ConstMFVec2f constMFVec2f) {
        int n = constMFVec2f.getSize();
        if (n > this.numElements) {
            this.data = new float[n * 2];
        }
        this.numElements = n;
        constMFVec2f.getValue(this.data);
    }

    public void set1Value(int n, ConstSFVec2f constSFVec2f) {
        if (n >= this.numElements) {
            throw new IllegalArgumentException("Index > numElements");
        }
        int n2 = n * 2;
        this.data[n2++] = constSFVec2f.getX();
        this.data[n2] = constSFVec2f.getY();
    }

    public void set1Value(int n, SFVec2f sFVec2f) {
        if (n >= this.numElements) {
            throw new IllegalArgumentException("Index > numElements");
        }
        int n2 = n * 2;
        this.data[n2++] = sFVec2f.getX();
        this.data[n2] = sFVec2f.getY();
    }

    public void set1Value(int n, float f, float f2) {
        if (n >= this.numElements) {
            throw new IllegalArgumentException("Index > numElements");
        }
        int n2 = n * 2;
        this.data[n2++] = f;
        this.data[n2] = f2;
    }

    public void addValue(ConstSFVec2f constSFVec2f) {
        int n = this.numElements * 2;
        this.realloc();
        ++this.numElements;
        this.data[n++] = constSFVec2f.getX();
        this.data[n] = constSFVec2f.getY();
    }

    public void addValue(SFVec2f sFVec2f) {
        int n = this.numElements * 2;
        this.realloc();
        ++this.numElements;
        this.data[n++] = sFVec2f.getX();
        this.data[n] = sFVec2f.getY();
    }

    public void addValue(float f, float f2) {
        int n = this.numElements * 2;
        this.realloc();
        ++this.numElements;
        this.data[n++] = f;
        this.data[n] = f2;
    }

    public void insertValue(int n, ConstSFVec2f constSFVec2f) {
        if (n >= this.numElements) {
            throw new IllegalArgumentException("Index > numElements");
        }
        int n2 = n * 2;
        this.makeHole(n2);
        ++this.numElements;
        this.data[n2++] = constSFVec2f.getX();
        this.data[n2] = constSFVec2f.getY();
    }

    public void insertValue(int n, SFVec2f sFVec2f) {
        if (n >= this.numElements) {
            throw new IllegalArgumentException("Index > numElements");
        }
        int n2 = n * 2;
        this.makeHole(n2);
        ++this.numElements;
        this.data[n2++] = sFVec2f.getX();
        this.data[n2] = sFVec2f.getY();
    }

    public void insertValue(int n, float f, float f2) {
        if (n >= this.numElements) {
            throw new IllegalArgumentException("Index > numElements");
        }
        int n2 = n * 2;
        this.makeHole(n2);
        ++this.numElements;
        this.data[n2++] = f;
        this.data[n2] = f2;
    }

    public void clear() {
        this.numElements = 0;
    }

    public void delete(int n) {
        if (n < 0 || n >= this.numElements) {
            throw new ArrayIndexOutOfBoundsException("Invalid index");
        }
        int n2 = n * 2;
        int n3 = this.numElements * 2 - n2;
        if (n3 != 0) {
            System.arraycopy(this.data, n2 + 2, this.data, n2, n3);
        }
        --this.numElements;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("[\n  ");
        int n = 0;
        for (int i = 0; i < this.numElements; ++i) {
            stringBuffer.append(this.data[n++]);
            stringBuffer.append(' ');
            stringBuffer.append(this.data[n++]);
            stringBuffer.append(' ');
            if (i % 4 != 0) continue;
            stringBuffer.append("\n  ");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public Object clone() {
        return new MFVec2f(this.numElements * 2, this.data);
    }

    private void realloc() {
        int n = this.numElements * 2;
        if (n >= this.data.length) {
            int n2 = n + 10;
            float[] fArray = new float[n2];
            System.arraycopy(this.data, 0, fArray, 0, this.data.length);
            this.data = fArray;
        }
    }

    private void makeHole(int n) {
        int n2 = this.numElements * 2;
        int n3 = n2 - n;
        if (n2 >= this.data.length) {
            int n4 = n2 + 10;
            float[] fArray = new float[n4];
            System.arraycopy(this.data, 0, fArray, 0, n - 1);
            System.arraycopy(this.data, n, fArray, n + 2, n3);
            this.data = fArray;
        } else {
            System.arraycopy(this.data, n, this.data, n + 2, n3);
        }
    }
}

