/*
 * Decompiled with CFR 0.152.
 */
package vrml.field;

import org.web3d.util.ArrayUtils;
import vrml.MField;
import vrml.field.ConstMFVec3f;
import vrml.field.ConstSFVec3f;
import vrml.field.SFVec3f;

public class MFVec3f
extends MField {
    protected static final int ARRAY_INC = 15;
    protected float[] data;

    public MFVec3f() {
        this.data = new float[15];
        this.numElements = 0;
    }

    public MFVec3f(float[][] fArray) {
        this.data = new float[fArray.length * 3];
        ArrayUtils.flatten2(fArray, fArray.length, this.data);
        this.numElements = fArray.length;
    }

    public MFVec3f(float[] fArray) {
        if (fArray.length < 3) {
            throw new IllegalArgumentException("Array length less than 3");
        }
        this.numElements = fArray.length / 3;
        int n = this.numElements * 3;
        this.data = new float[n];
        System.arraycopy(fArray, 0, this.data, 0, n);
    }

    public MFVec3f(int n, float[] fArray) {
        if (fArray.length < 3) {
            throw new IllegalArgumentException("Array length less than 3");
        }
        this.numElements = n / 3;
        this.data = new float[fArray.length];
        System.arraycopy(fArray, 0, this.data, 0, fArray.length);
    }

    public void getValue(float[][] fArray) {
        ArrayUtils.raise3(this.data, this.numElements, fArray);
    }

    public void getValue(float[] fArray) {
        System.arraycopy(this.data, 0, fArray, 0, this.numElements * 3);
    }

    public void get1Value(int n, float[] fArray) {
        if (n >= this.numElements) {
            throw new IllegalArgumentException("Index > numElements");
        }
        int n2 = n * 3;
        fArray[0] = this.data[n2++];
        fArray[1] = this.data[n2++];
        fArray[2] = this.data[n2];
    }

    public void get1Value(int n, SFVec3f sFVec3f) {
        if (n >= this.numElements) {
            throw new IllegalArgumentException("Index > numElements");
        }
        int n2 = n * 3;
        sFVec3f.setValue(this.data[n2], this.data[n2 + 1], this.data[n2 + 2]);
    }

    public void setValue(float[][] fArray) {
        if (fArray.length > this.numElements) {
            this.data = new float[fArray.length * 3];
        }
        this.numElements = fArray.length;
        ArrayUtils.flatten3(fArray, this.numElements, this.data);
    }

    public void setValue(float[] fArray) {
        int n = fArray.length / 3;
        if (n > this.numElements) {
            this.data = new float[n * 3];
        }
        this.numElements = n;
        System.arraycopy(fArray, 0, this.data, 0, n * 3);
    }

    public void setValue(int n, float[] fArray) {
        if (n > this.data.length) {
            this.data = new float[n];
        }
        this.numElements = n / 3;
        System.arraycopy(fArray, 0, this.data, 0, n);
    }

    public void setValue(MFVec3f mFVec3f) {
        int n = mFVec3f.getSize();
        if (n > this.numElements) {
            this.data = new float[n * 3];
        }
        this.numElements = n;
        mFVec3f.getValue(this.data);
    }

    public void setValue(ConstMFVec3f constMFVec3f) {
        int n = constMFVec3f.getSize();
        if (n > this.numElements) {
            this.data = new float[n * 3];
        }
        this.numElements = n;
        constMFVec3f.getValue(this.data);
    }

    public void set1Value(int n, ConstSFVec3f constSFVec3f) {
        if (n >= this.numElements) {
            throw new IllegalArgumentException("Index > numElements");
        }
        int n2 = n * 3;
        this.data[n2++] = constSFVec3f.getX();
        this.data[n2++] = constSFVec3f.getY();
        this.data[n2] = constSFVec3f.getZ();
    }

    public void set1Value(int n, SFVec3f sFVec3f) {
        if (n >= this.numElements) {
            throw new IllegalArgumentException("Index > numElements");
        }
        int n2 = n * 3;
        this.data[n2++] = sFVec3f.getX();
        this.data[n2++] = sFVec3f.getY();
        this.data[n2] = sFVec3f.getZ();
    }

    public void set1Value(int n, float f, float f2, float f3) {
        if (n >= this.numElements) {
            throw new IllegalArgumentException("Index > numElements");
        }
        int n2 = n * 3;
        this.data[n2++] = f;
        this.data[n2++] = f2;
        this.data[n2] = f3;
    }

    public void addValue(ConstSFVec3f constSFVec3f) {
        int n = this.numElements * 3;
        this.realloc();
        ++this.numElements;
        this.data[n++] = constSFVec3f.getX();
        this.data[n++] = constSFVec3f.getY();
        this.data[n] = constSFVec3f.getZ();
    }

    public void addValue(SFVec3f sFVec3f) {
        int n = this.numElements * 3;
        this.realloc();
        ++this.numElements;
        this.data[n++] = sFVec3f.getX();
        this.data[n++] = sFVec3f.getY();
        this.data[n] = sFVec3f.getZ();
    }

    public void addValue(float f, float f2, float f3) {
        int n = this.numElements * 3;
        this.realloc();
        ++this.numElements;
        this.data[n++] = f;
        this.data[n++] = f2;
        this.data[n] = f3;
    }

    public void insertValue(int n, ConstSFVec3f constSFVec3f) {
        if (n >= this.numElements) {
            throw new IllegalArgumentException("Index > numElements");
        }
        int n2 = n * 3;
        this.makeHole(n2);
        ++this.numElements;
        this.data[n2++] = constSFVec3f.getX();
        this.data[n2++] = constSFVec3f.getY();
        this.data[n2] = constSFVec3f.getZ();
    }

    public void insertValue(int n, SFVec3f sFVec3f) {
        if (n >= this.numElements) {
            throw new IllegalArgumentException("Index > numElements");
        }
        int n2 = n * 3;
        this.makeHole(n2);
        ++this.numElements;
        this.data[n2++] = sFVec3f.getX();
        this.data[n2++] = sFVec3f.getY();
        this.data[n2] = sFVec3f.getZ();
    }

    public void insertValue(int n, float f, float f2, float f3) {
        if (n >= this.numElements) {
            throw new IllegalArgumentException("Index > numElements");
        }
        int n2 = n * 3;
        this.makeHole(n2);
        ++this.numElements;
        this.data[n2++] = f;
        this.data[n2++] = f2;
        this.data[n2] = f3;
    }

    public void clear() {
        this.numElements = 0;
    }

    public void delete(int n) {
        if (n < 0 || n >= this.numElements) {
            throw new ArrayIndexOutOfBoundsException("Invalid index");
        }
        int n2 = n * 3;
        int n3 = this.numElements * 3 - n2;
        if (n3 != 0) {
            System.arraycopy(this.data, n2 + 3, this.data, n2, n3);
        }
        --this.numElements;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("[\n  ");
        int n = 0;
        for (int i = 0; i < this.numElements; ++i) {
            stringBuffer.append(this.data[n++]);
            stringBuffer.append(' ');
            stringBuffer.append(this.data[n++]);
            stringBuffer.append(' ');
            stringBuffer.append(this.data[n++]);
            stringBuffer.append(' ');
            if (i % 4 != 0) continue;
            stringBuffer.append("\n  ");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public Object clone() {
        return new MFVec3f(this.numElements * 3, this.data);
    }

    private void realloc() {
        int n = this.numElements * 3;
        if (n >= this.data.length) {
            int n2 = n + 15;
            float[] fArray = new float[n2];
            System.arraycopy(this.data, 0, fArray, 0, this.data.length);
            this.data = fArray;
        }
    }

    private void makeHole(int n) {
        int n2 = this.numElements * 3;
        int n3 = n2 - n;
        if (n2 >= this.data.length) {
            int n4 = n2 + 15;
            float[] fArray = new float[n4];
            System.arraycopy(this.data, 0, fArray, 0, n - 1);
            System.arraycopy(this.data, n, fArray, n + 3, n3);
            this.data = fArray;
        } else {
            System.arraycopy(this.data, n, this.data, n + 3, n3);
        }
    }
}

