/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.client.j2se;

import com.google.zxing.BinaryBitmap;
import com.google.zxing.MultiFormatReader;
import com.google.zxing.ReaderException;
import com.google.zxing.Result;
import com.google.zxing.client.j2se.BufferedImageLuminanceSource;
import com.google.zxing.common.HybridBinarizer;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;

public final class GUIRunner
extends JFrame {
    private final JLabel imageLabel = new JLabel();
    private final JTextArea textArea = new JTextArea();

    private GUIRunner() {
        this.textArea.setEditable(false);
        this.textArea.setMaximumSize(new Dimension(400, 200));
        JPanel panel = new JPanel();
        panel.setLayout(new FlowLayout());
        panel.add(this.imageLabel);
        panel.add(this.textArea);
        this.setTitle("ZXing");
        this.setSize(400, 400);
        this.setDefaultCloseOperation(3);
        this.setContentPane(panel);
        this.setLocationRelativeTo(null);
    }

    public static void main(String[] args) throws MalformedURLException {
        GUIRunner runner = new GUIRunner();
        runner.setVisible(true);
        runner.chooseImage();
    }

    private void chooseImage() throws MalformedURLException {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.showOpenDialog(this);
        File file = fileChooser.getSelectedFile();
        ImageIcon imageIcon = new ImageIcon(file.toURI().toURL());
        this.setSize(imageIcon.getIconWidth(), imageIcon.getIconHeight() + 100);
        this.imageLabel.setIcon(imageIcon);
        String decodeText = GUIRunner.getDecodeText(file);
        this.textArea.setText(decodeText);
    }

    private static String getDecodeText(File file) {
        Result result;
        BufferedImage image;
        try {
            image = ImageIO.read(file);
        }
        catch (IOException ioe) {
            return ioe.toString();
        }
        if (image == null) {
            return "Could not decode image";
        }
        BufferedImageLuminanceSource source = new BufferedImageLuminanceSource(image);
        BinaryBitmap bitmap = new BinaryBitmap(new HybridBinarizer(source));
        try {
            result = new MultiFormatReader().decode(bitmap);
        }
        catch (ReaderException re) {
            return re.toString();
        }
        return result.getText();
    }
}

