/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.gps;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.plugins.gps.device.Device;
import pt.lsts.neptus.util.GuiUtils;

public class ConfigDialog
extends JDialog {
    private JComboBox<String> portComboBox;
    private JComboBox<?> baudComboBox;
    private JComboBox<?> frameComboBox;
    private String port;
    private String baud;
    private String frame;
    private boolean canceled = false;

    public ConfigDialog(Component owner, String title) throws Exception {
        super(SwingUtilities.getWindowAncestor(owner), title);
        Vector<String> devices = Device.enumerate();
        if (devices.size() == 0) {
            throw new Exception(I18n.text((String)"No serial ports available"));
        }
        this.portComboBox = new JComboBox<String>(devices);
        this.baudComboBox = new JComboBox<String>(Device.BAUD_RATES);
        this.frameComboBox = new JComboBox<String>(Device.FRAME_TYPES);
        final JButton okButton = new JButton(I18n.text((String)"OK"));
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConfigDialog.this.baud = (String)ConfigDialog.this.baudComboBox.getSelectedItem();
                ConfigDialog.this.port = (String)ConfigDialog.this.portComboBox.getSelectedItem();
                ConfigDialog.this.frame = (String)ConfigDialog.this.frameComboBox.getSelectedItem();
                ConfigDialog.this.close();
            }
        });
        GuiUtils.reactEnterKeyPress((JButton)okButton);
        this.addWindowFocusListener(new WindowAdapter(){

            @Override
            public void windowGainedFocus(WindowEvent e) {
                okButton.requestFocusInWindow();
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                ConfigDialog.this.canceled = true;
            }
        });
        this.setDefaultCloseOperation(2);
        JButton cancelButton = new JButton(I18n.text((String)"Cancel"));
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConfigDialog.this.canceled = true;
                ConfigDialog.this.close();
            }
        });
        GuiUtils.reactEscapeKeyPress((JButton)cancelButton);
        GridLayout layout = new GridLayout(4, 2, 10, 10);
        JPanel panel = new JPanel(layout);
        EmptyBorder border = new EmptyBorder(20, 20, 20, 20);
        panel.setBorder(border);
        panel.add(new JLabel(I18n.text((String)"Serial Port")));
        panel.add(this.portComboBox);
        panel.add(new JLabel(I18n.text((String)"Baud Rate")));
        panel.add(this.baudComboBox);
        panel.add(new JLabel(I18n.text((String)"Frame Type")));
        panel.add(this.frameComboBox);
        panel.add(okButton);
        panel.add(cancelButton);
        this.setContentPane(panel);
        this.pack();
        this.setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
    }

    public String getPort() {
        return this.port;
    }

    public String getBaud() {
        return this.baud;
    }

    public String getFrame() {
        return this.frame;
    }

    public boolean open(String aPort, String aBaud, String aFrame) {
        this.portComboBox.setSelectedItem(aPort);
        if (this.portComboBox.getSelectedIndex() == -1) {
            this.portComboBox.setSelectedIndex(0);
        }
        this.baudComboBox.setSelectedItem(aBaud);
        if (this.baudComboBox.getSelectedIndex() == -1) {
            this.baudComboBox.setSelectedIndex(0);
        }
        this.frameComboBox.setSelectedItem(aFrame);
        if (this.frameComboBox.getSelectedIndex() == -1) {
            this.frameComboBox.setSelectedIndex(0);
        }
        GuiUtils.centerParent((Window)this, (Window)this.getOwner());
        this.setVisible(true);
        return !this.canceled;
    }

    public void close() {
        this.setVisible(false);
        this.dispose();
    }
}

