/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.gps;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import java.util.HashMap;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.Timer;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.console.ConsoleLayout;
import pt.lsts.neptus.console.ConsolePanel;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.mystate.MyState;
import pt.lsts.neptus.plugins.NeptusProperty;
import pt.lsts.neptus.plugins.PluginDescription;
import pt.lsts.neptus.plugins.PluginsLoader;
import pt.lsts.neptus.plugins.Popup;
import pt.lsts.neptus.plugins.gps.ConfigDialog;
import pt.lsts.neptus.plugins.gps.device.Device;
import pt.lsts.neptus.plugins.gps.device.Fix;
import pt.lsts.neptus.plugins.gps.device.FixListener;
import pt.lsts.neptus.types.coord.CoordinateUtil;
import pt.lsts.neptus.types.coord.LocationType;
import pt.lsts.neptus.util.ConsoleParse;

@Popup(pos=Popup.POSITION.RIGHT, width=200, height=100, accelerator=71)
@PluginDescription(name="GPS Device Panel", author="Ricardo Martins", icon="images/buttons/gpsbutton.png", description="Panel that reads NMEA sentences from a GPS device", documentation="gps-panel/gps-panel.html")
public class GPSDevicePanel
extends ConsolePanel
implements ActionListener,
FixListener {
    private static final String MSG_NOT_CONNECTED = "<html>" + I18n.text((String)"Not Connected") + "</html>";
    private static final String MSG_WAIT_DATA = "<html>" + I18n.text((String)"Waiting for Data...") + "</html>";
    private static final String ERR_NO_INPUT = "<html><font color='red'>" + I18n.text((String)"No Valid Data") + "</font></html>";
    private static final String WAR_NO_FIX = "<html><font color='#ec5114'>" + I18n.text((String)"No Valid Solution") + "</font></html>";
    private static final DecimalFormat DECIMAL_FORMAT = new DecimalFormat("0.00");
    @NeptusProperty(name="Input Timeout (s)")
    public int watchDogTimeoutSegs = 5;
    @NeptusProperty(name="Preferred Width")
    public int preferredWidth = 175;
    @NeptusProperty(name="Preferred Height")
    public int preferredHeight = 75;
    @NeptusProperty(name="Serial Port Device")
    public String uartDevice = null;
    @NeptusProperty(name="Serial Port Baud Rate")
    public String uartBaudRate = "4800";
    @NeptusProperty(name="Serial Port Frame Type")
    public String uartFrameType = "8n1";
    @NeptusProperty(name="Use speed to filter heading")
    public boolean useSpeedToFilterHeading = true;
    @NeptusProperty(name="Minimum speed to accept heading (m/s)")
    public double headingSpeedMinimum = 0.1;
    private final Device gpsDevice = new Device(this);
    private final Timer watchDog = new Timer(this.watchDogTimeoutSegs * 1000, this);
    private final JButton actionButton = new JButton();
    private final JPanel mainPanel = new JPanel();
    private JLabel dataLabel;

    public GPSDevicePanel(ConsoleLayout console) {
        super(console);
        this.removeAll();
        this.setLayout(new BorderLayout());
        this.watchDog.setActionCommand(I18n.text((String)"Timeout"));
        this.dataLabel = new JLabel(MSG_NOT_CONNECTED, 0);
        Font dataLabelFont = new Font(this.dataLabel.getFont().getName(), 1, this.dataLabel.getFont().getSize());
        this.dataLabel.setFont(dataLabelFont);
        this.actionButton.addActionListener(this);
        this.changeButton(I18n.text((String)"Connect"), true);
        BorderLayout layout = new BorderLayout();
        layout.setVgap(5);
        this.mainPanel.setLayout(layout);
        this.mainPanel.add((Component)this.dataLabel, "Center");
        this.mainPanel.add((Component)this.actionButton, "South");
        Dimension dim = this.mainPanel.getPreferredSize();
        dim.width = this.preferredWidth;
        this.mainPanel.setPreferredSize(dim);
        this.mainPanel.setSize(dim);
        this.setName(I18n.text((String)"GPS Device"));
        this.add(this.mainPanel, "Center");
        this.setSize(this.preferredWidth, this.preferredHeight);
    }

    public void cleanSubPanel() {
        if (this.gpsDevice.isConnected()) {
            this.gpsDevice.disconnect();
        }
    }

    @Override
    public void onFix(Fix fix) {
        this.watchDog.restart();
        String latitude = CoordinateUtil.latitudeAsString((double)fix.getLatitude());
        String longitude = CoordinateUtil.longitudeAsString((double)fix.getLongitude());
        this.dataLabel.setToolTipText("<html><b>" + I18n.text((String)"Latitude") + "</b>: " + latitude + "<br>" + "<b>" + I18n.text((String)"Longitude") + "</b>: " + longitude + "<br><b>" + I18n.text((String)"Height") + "</b>: " + DECIMAL_FORMAT.format(fix.getHeight()) + "<br><b>" + I18n.text((String)"Satellites") + "</b>: " + fix.getSatellites() + "<br>" + "<b>" + I18n.text((String)"HDOP") + "</b>: " + DECIMAL_FORMAT.format(fix.getHorizontalDilution()) + "<br>" + "<b>" + I18n.text((String)"VDOP") + "</b>: " + DECIMAL_FORMAT.format(fix.getVerticalDilution()) + "<br>" + "<b>" + I18n.text((String)"Vertical Accuracy") + "</b>: " + DECIMAL_FORMAT.format(fix.getVerticalAccuracy()) + "<br>" + "<b>" + I18n.text((String)"Horizontal Accuracy") + "</b>: " + DECIMAL_FORMAT.format(fix.getHorizontalAccuracy()) + "<br>" + "<b>" + I18n.text((String)"Ground Speed") + "</b>: " + DECIMAL_FORMAT.format(fix.getSog()) + "<br>" + "<b>" + I18n.text((String)"Course Over Ground") + "</b>: " + DECIMAL_FORMAT.format(fix.getCog()) + "<br>" + "</html>");
        if (fix.isValid()) {
            LocationType loc = new LocationType();
            loc.setLatitudeDegs(fix.getLatitude());
            loc.setLongitudeDegs(fix.getLongitude());
            loc.setHeight(fix.getHeight());
            if (!this.useSpeedToFilterHeading || !(fix.getCog() <= this.headingSpeedMinimum)) {
                MyState.setHeadingInDegrees((double)fix.getCog());
            }
            MyState.setLocation((LocationType)loc);
            this.dataLabel.setText(latitude + " / " + longitude);
        } else {
            this.dataLabel.setText(WAR_NO_FIX);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (I18n.text((String)"Connect").equals(e.getActionCommand())) {
            if (this.setup()) {
                this.connect();
            }
        } else if (I18n.text((String)"Disconnect").equals(e.getActionCommand())) {
            this.disconnect(MSG_NOT_CONNECTED);
        } else if (I18n.text((String)"Timeout").equals(e.getActionCommand())) {
            this.disconnect(ERR_NO_INPUT);
        }
    }

    private void connect() {
        HashMap<Device.Parameter, String> params = new HashMap<Device.Parameter, String>();
        params.put(Device.Parameter.DEV, this.uartDevice);
        params.put(Device.Parameter.BAUD, this.uartBaudRate);
        params.put(Device.Parameter.FRAME, this.uartFrameType);
        this.changeButton(I18n.text((String)"Connecting"), false);
        try {
            this.gpsDevice.connect(params);
            this.changeButton(I18n.text((String)"Disconnect"), true);
            this.dataLabel.setText(MSG_WAIT_DATA);
            this.watchDog.setDelay(this.watchDogTimeoutSegs * 1000);
            this.watchDog.start();
        }
        catch (Exception e) {
            NeptusLog.pub().info((Object)("<###> " + e));
        }
    }

    private void disconnect(String msg) {
        this.changeButton(I18n.text((String)"Disconnecting"), false);
        this.gpsDevice.disconnect();
        this.dataLabel.setText(msg);
        this.changeButton(I18n.text((String)"Connect"), true);
        this.watchDog.stop();
    }

    private boolean setup() {
        try {
            ConfigDialog dialog = new ConfigDialog((Component)((Object)this), I18n.text((String)"GPS Device Configuration"));
            if (dialog.open(this.uartDevice, this.uartBaudRate, this.uartFrameType)) {
                this.uartDevice = dialog.getPort();
                this.uartBaudRate = dialog.getBaud();
                this.uartFrameType = dialog.getFrame();
                return true;
            }
        }
        catch (Exception e) {
            this.dataLabel.setText("<html><font color='red'>" + e.getMessage() + "</html>");
        }
        return false;
    }

    private void changeButton(String text, boolean enabled) {
        this.actionButton.setText(text);
        this.actionButton.setActionCommand(text);
        this.actionButton.setEnabled(enabled);
    }

    public void initSubPanel() {
    }

    public static void main(String[] args) {
        PluginsLoader.load();
        ConsoleParse.testSubPanel(GPSDevicePanel.class);
    }
}

