/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.gps.device;

import gnu.io.CommPort;
import gnu.io.CommPortIdentifier;
import gnu.io.PortInUseException;
import gnu.io.SerialPort;
import gnu.io.SerialPortEvent;
import gnu.io.SerialPortEventListener;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Vector;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.plugins.gps.device.FixListener;
import pt.lsts.neptus.plugins.gps.device.NMEA;

public class Device
implements SerialPortEventListener {
    public static final String FRAME_8N1 = "8n1";
    public static final String FRAME_8E1 = "8e1";
    public static final String FRAME_8O1 = "8o1";
    public static final String FRAME_8N2 = "8n2";
    public static final String FRAME_7E1 = "7e1";
    public static final String FRAME_7O1 = "7o1";
    public static final String FRAME_7N2 = "7n2";
    public static final String FRAME_7E2 = "7e2";
    public static final String FRAME_7O2 = "7o2";
    public static final String[] FRAME_TYPES = new String[]{"8n1", "8e1", "8o1", "8n2", "7e1", "7o1", "7n2", "7e2", "7o2"};
    public static final String[] BAUD_RATES = new String[]{"2400", "4800", "9600", "19200", "38400", "57600", "115200"};
    private SerialPort handle = null;
    private InputStream inputStream = null;
    private final byte[] buffer = new byte[2048];
    private NMEA parser = null;
    private boolean connected = false;

    public Device(FixListener listener) {
        this.parser = new NMEA(listener);
    }

    public void connect(HashMap<Parameter, String> params) throws Exception {
        CommPortIdentifier portIdentifier = CommPortIdentifier.getPortIdentifier((String)params.get((Object)Parameter.DEV));
        if (portIdentifier.isCurrentlyOwned()) {
            throw new Exception("port '" + portIdentifier.getName() + "' is currently in use");
        }
        CommPort commPort = portIdentifier.open(this.getClass().getName(), 2000);
        if (!(commPort instanceof SerialPort)) {
            throw new Exception("device '" + portIdentifier.getName() + "' is not a serial port");
        }
        this.handle = (SerialPort)commPort;
        int[] args = Device.translateFrameType(params.get((Object)Parameter.FRAME));
        this.handle.setSerialPortParams(Integer.parseInt(params.get((Object)Parameter.BAUD)), args[0], args[1], args[2]);
        this.inputStream = this.handle.getInputStream();
        this.handle.addEventListener((SerialPortEventListener)this);
        this.handle.notifyOnDataAvailable(true);
        this.connected = true;
    }

    public void disconnect() {
        this.handle.removeEventListener();
        this.handle.close();
        this.connected = false;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public synchronized void serialEvent(SerialPortEvent evt) {
        if (evt.getEventType() != 1) {
            return;
        }
        try {
            int amount = Math.min(this.buffer.length, this.inputStream.available());
            int len = this.inputStream.read(this.buffer, 0, amount);
            for (int i = 0; i < len; ++i) {
                try {
                    this.parser.parse(this.buffer[i]);
                    continue;
                }
                catch (Exception e) {
                    NeptusLog.pub().info((Object)("<###> " + e));
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static int[] translateFrameType(String type) throws IllegalArgumentException {
        int[] args = new int[3];
        if (type.charAt(0) == '8') {
            args[0] = 8;
        } else if (type.charAt(0) == '7') {
            args[0] = 7;
        } else {
            throw new IllegalArgumentException("invalid frame type '" + type + "'");
        }
        if (type.charAt(2) == '1') {
            args[1] = 1;
        } else if (type.charAt(2) == '2') {
            args[1] = 2;
        } else {
            throw new IllegalArgumentException("invalid frame type '" + type + "'");
        }
        if (type.charAt(1) == 'o') {
            args[2] = 1;
        } else if (type.charAt(1) == 'e') {
            args[2] = 2;
        } else if (type.charAt(1) == 'n') {
            args[2] = 0;
        } else {
            throw new IllegalArgumentException("invalid frame type '" + type + "'");
        }
        return args;
    }

    public static Vector<String> enumerate() {
        Vector<String> devs = new Vector<String>();
        Enumeration ports = CommPortIdentifier.getPortIdentifiers();
        while (ports.hasMoreElements()) {
            CommPortIdentifier dev = (CommPortIdentifier)ports.nextElement();
            if (dev.getPortType() != 1) continue;
            try {
                CommPort port = dev.open("GPS Enumerator", 50);
                port.close();
                devs.add(dev.getName());
            }
            catch (PortInUseException e) {
                NeptusLog.pub().info((Object)("ERROR: serial port '" + dev.getName() + "' is in use"));
            }
            catch (Exception e) {
                System.err.println("ERROR: failed to open serial port '" + dev.getName() + "'");
                e.printStackTrace();
            }
        }
        return devs;
    }

    public static enum Parameter {
        DEV,
        BAUD,
        FRAME;

    }
}

