/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.gps.device;

import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.Vector;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.plugins.gps.device.Fix;
import pt.lsts.neptus.plugins.gps.device.FixListener;
import pt.lsts.neptus.plugins.gps.device.InvalidChecksumException;
import pt.lsts.neptus.plugins.gps.device.Time;

public class NMEA {
    private final ByteBuffer chunk = ByteBuffer.allocate(1024);
    private final Vector<String> chunks = new Vector();
    private final Fix fix = new Fix();
    private State state;
    private int chunkIdx;
    private byte rcsum;
    private byte ccsum;
    private boolean hasCsum;
    private FixListener listener;

    public NMEA(FixListener aListener) {
        this.listener = aListener;
        this.clear();
    }

    public void parse(byte b) throws InvalidChecksumException {
        switch (this.state) {
            case DOLLAR: {
                if (b != 36) break;
                this.state = State.BODY;
                break;
            }
            case BODY: {
                if (b == 44) {
                    this.ccsum = (byte)(this.ccsum ^ b);
                    this.appendChunk();
                    break;
                }
                if (b == 42) {
                    this.state = State.CSUM1;
                    this.hasCsum = true;
                    this.appendChunk();
                    break;
                }
                if (b == 13) {
                    this.state = State.LF;
                    break;
                }
                this.ccsum = (byte)(this.ccsum ^ b);
                this.chunk.put(b);
                ++this.chunkIdx;
                break;
            }
            case CSUM1: {
                this.rcsum = this.parseNibble(b, 4);
                this.state = State.CSUM2;
                break;
            }
            case CSUM2: {
                this.rcsum = (byte)(this.rcsum | this.parseNibble(b, 0));
                this.state = State.CR;
                break;
            }
            case CR: {
                if (b != 13) break;
                this.state = State.LF;
                break;
            }
            case LF: {
                if (b == 10) {
                    if (this.hasCsum && this.rcsum != this.ccsum) {
                        throw new InvalidChecksumException(this.ccsum, this.rcsum);
                    }
                    this.interpret();
                }
                this.clear();
            }
        }
    }

    private void clear() {
        this.state = State.DOLLAR;
        this.rcsum = 0;
        this.ccsum = 0;
        this.hasCsum = false;
        this.chunk.clear();
        this.chunkIdx = 0;
        this.chunks.clear();
    }

    private void interpret() {
        if ("GPGGA".equals(this.chunks.get(0))) {
            this.interpretGPGGA();
        } else if ("GPVTG".equals(this.chunks.get(0))) {
            this.interpretGPVTG();
        }
    }

    private void interpretGPGGA() {
        int quality = Integer.parseInt(this.chunks.get(6));
        if (quality == 1) {
            this.fix.setType(Fix.Type.STANDALONE);
            this.fix.setValid(true);
        } else if (quality == 2) {
            this.fix.setType(Fix.Type.DIFFERENTIAL);
            this.fix.setValid(true);
        } else {
            this.fix.setType(Fix.Type.STANDALONE);
            this.fix.setValid(false);
        }
        this.fix.setLatitude(this.parseLatitude(this.chunks.get(2), this.chunks.get(3)));
        this.fix.setLongitude(this.parseLongitude(this.chunks.get(4), this.chunks.get(5)));
        this.fix.setHeight(this.parseReal(this.chunks.get(9)) + this.parseReal(this.chunks.get(11)));
        this.fix.setSatellites(this.parseInteger(this.chunks.get(7)));
        this.fix.setHorizontalDilution(this.parseReal(this.chunks.get(8)));
        this.fix.setTime(this.parseTime(this.chunks.get(1)));
        this.listener.onFix(this.fix);
    }

    private void interpretGPVTG() {
        if (this.chunks.get(1).length() > 0) {
            this.fix.setCog(this.parseReal(this.chunks.get(1)));
        }
        double value = this.parseReal(this.chunks.get(7));
        this.fix.setSog(value * 1000.0 / 3600.0);
    }

    private Time parseTime(String str) {
        Time time = new Time();
        try {
            time.setHour(Integer.parseInt(str.substring(0, 2), 10));
            time.setMinutes(Integer.parseInt(str.substring(2, 4), 10));
            time.setSeconds(Double.parseDouble(str.substring(4)));
            return time;
        }
        catch (Exception e) {
            e.printStackTrace();
            return time;
        }
    }

    private double parseReal(String str) {
        try {
            return Double.parseDouble(str);
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0.0;
        }
    }

    private int parseInteger(String str) {
        try {
            return Integer.parseInt(str, 10);
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    private double parseLatitude(String cord, String hemisphere) {
        try {
            int degrees = Integer.parseInt(cord.substring(0, 2));
            double minutes = Double.parseDouble(cord.substring(2));
            double value = (double)degrees + minutes / 60.0;
            if (hemisphere.equals("S")) {
                value = -value;
            }
            return value;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0.0;
        }
    }

    private double parseLongitude(String cord, String hemisphere) {
        try {
            int degrees = Integer.parseInt(cord.substring(0, 3));
            double minutes = Double.parseDouble(cord.substring(3));
            double value = (double)degrees + minutes / 60.0;
            if (hemisphere.equals("W")) {
                value = -value;
            }
            return value;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0.0;
        }
    }

    private byte parseNibble(byte b, int shift) {
        byte rv = 0;
        if (b >= 48 && b <= 57) {
            rv = (byte)(rv | b - 48 << shift);
        } else if (b >= 97 && b <= 102) {
            rv = (byte)(rv | b - 97 + 10 << shift);
        } else if (b >= 65 && b <= 70) {
            rv = (byte)(rv | b - 65 + 10 << shift);
        }
        return rv;
    }

    private void appendChunk() {
        try {
            this.chunks.add(new String(this.chunk.array(), 0, this.chunkIdx, "US-ASCII"));
        }
        catch (UnsupportedEncodingException e) {
            NeptusLog.pub().info((Object)("<###> " + e));
        }
        this.chunk.clear();
        this.chunkIdx = 0;
    }

    private static enum State {
        DOLLAR,
        BODY,
        CSUM1,
        CSUM2,
        CR,
        LF;

    }
}

