/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.scripting.external.buffer;

import java.util.HashMap;
import java.util.LinkedList;
import org.web3d.util.DefaultErrorReporter;
import org.web3d.util.ErrorReporter;
import org.web3d.vrml.nodes.runtime.ExternalView;
import org.web3d.vrml.scripting.external.buffer.ExternalEvent;

public class NetworkEventQueue
implements ExternalView {
    private HashMap queuedEvents;
    public Object eventLock = new Object();
    private boolean queueing;
    protected ErrorReporter errorReporter;
    LinkedList eventQueue = new LinkedList();
    LinkedList waitingQueue;

    public NetworkEventQueue(ErrorReporter errorReporter) {
        this.queuedEvents = new HashMap();
        this.waitingQueue = new LinkedList();
        this.errorReporter = errorReporter == null ? DefaultErrorReporter.getDefaultReporter() : errorReporter;
    }

    public void beginUpdate() {
        this.queueing = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endUpdate() {
        Object object = this.eventLock;
        synchronized (object) {
            if (this.queueing) {
                this.queueing = false;
                this.waitingQueue.addAll(this.eventQueue);
                this.eventQueue.clear();
                this.queuedEvents.clear();
                this.processEvents();
            }
        }
    }

    public ExternalEvent getLast(ExternalEvent externalEvent) {
        return (ExternalEvent)this.queuedEvents.get(externalEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processEvent(ExternalEvent externalEvent) {
        Object object = this.eventLock;
        synchronized (object) {
            if (this.queueing) {
                this.eventQueue.addLast(externalEvent);
                this.queuedEvents.put(externalEvent, externalEvent);
            } else {
                externalEvent.doEvent();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processEvents() {
        LinkedList linkedList;
        Object object = this.eventLock;
        synchronized (object) {
            linkedList = this.waitingQueue;
            this.waitingQueue = new LinkedList();
        }
        while (!linkedList.isEmpty()) {
            object = (ExternalEvent)linkedList.removeFirst();
            try {
                object.doEvent();
            }
            catch (Exception exception) {
                this.errorReporter.errorReport("Error encountered processing buffered event.", exception);
            }
        }
    }

    public void setErrorReporter(ErrorReporter errorReporter) {
        this.errorReporter = errorReporter;
    }
}

