/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.scripting.external.sai;

import java.awt.image.RenderedImage;
import java.awt.image.WritableRenderedImage;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.scripting.external.buffer.ExternalEvent;
import org.web3d.vrml.scripting.external.buffer.ExternalEventQueue;
import org.web3d.vrml.scripting.external.buffer.ExternalOutputBuffer;
import org.web3d.vrml.scripting.external.sai.MFInt32Wrapper;
import org.web3d.vrml.scripting.external.sai.SAIEventAdapterFactory;
import org.web3d.vrml.scripting.external.sai.SFImageWrapper;
import org.web3d.x3d.sai.InvalidFieldException;
import org.web3d.x3d.sai.InvalidFieldValueException;
import org.web3d.x3d.sai.InvalidOperationTimingException;
import org.web3d.x3d.sai.InvalidWritableFieldException;
import org.web3d.x3d.sai.MFImage;

class MFImageWrapper
extends MFInt32Wrapper
implements MFImage,
ExternalEvent,
ExternalOutputBuffer {
    boolean isSetOneValue;
    boolean rogueInputData;
    int storedInputLength;
    int[] storedInputValue;
    int[] storedOutputValue;

    MFImageWrapper(VRMLNodeType vRMLNodeType, int n, ExternalEventQueue externalEventQueue, SAIEventAdapterFactory sAIEventAdapterFactory) {
        super(vRMLNodeType, n, externalEventQueue, sAIEventAdapterFactory);
    }

    MFImageWrapper(VRMLNodeType vRMLNodeType, int n, ExternalEventQueue externalEventQueue, SAIEventAdapterFactory sAIEventAdapterFactory, boolean bl) {
        this(vRMLNodeType, n, externalEventQueue, sAIEventAdapterFactory);
        if (bl) {
            this.loadInputValue();
        } else {
            this.loadOutputValue();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doEvent() {
        try {
            this.theNode.setValue(this.fieldIndex, this.storedInputValue, this.storedInputLength);
        }
        finally {
            this.storedInput = false;
        }
    }

    protected void ensureArraySize(int n) {
        if (this.storedInputValue != null && n < this.storedInputValue.length) {
            return;
        }
        int[] nArray = new int[n];
        if (this.storedInputValue != null) {
            System.arraycopy(this.storedInputValue, 0, nArray, 0, this.storedInputLength);
        }
        this.storedInputValue = nArray;
    }

    public int getComponents(int n) {
        if (this.storedOutput) {
            if (n < 0) {
                throw new ArrayIndexOutOfBoundsException();
            }
            return this.storedOutputValue[MFImageWrapper.findStartOfImage(n, this.storedOutputValue) + 2];
        }
        this.checkReadAccess();
        VRMLFieldData vRMLFieldData = this.theNode.getFieldValue(this.fieldIndex);
        if (n < 0 || n >= this.countActualImages(vRMLFieldData.intArrayValue, vRMLFieldData.numElements)) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return vRMLFieldData.intArrayValue[MFImageWrapper.findStartOfImage(n, vRMLFieldData.intArrayValue) + 2];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertValue(int n, int n2) throws ArrayIndexOutOfBoundsException {
        this.checkReadAccess();
        this.checkWriteAccess();
        Object object = this.theEventQueue.eventLock;
        synchronized (object) {
            MFImageWrapper mFImageWrapper = (MFImageWrapper)this.theEventQueue.getLast(this);
            boolean bl = false;
            if (mFImageWrapper == null || !mFImageWrapper.isSetOneValue) {
                if (!this.storedInput && !this.storedOutput) {
                    mFImageWrapper = this;
                    this.loadInputValue();
                    this.isSetOneValue = true;
                } else {
                    mFImageWrapper = new MFImageWrapper(this.theNode, this.fieldIndex, this.theEventQueue, this.theEventAdapterFactory, true);
                    mFImageWrapper.isSetOneValue = true;
                }
                bl = true;
            }
            mFImageWrapper.ensureArraySize(mFImageWrapper.storedInputLength + 1);
            System.arraycopy(mFImageWrapper.storedInputValue, n, mFImageWrapper.storedInputValue, n + 1, mFImageWrapper.storedInputLength - n);
            mFImageWrapper.storedInputValue[n] = n2;
            ++mFImageWrapper.storedInputLength;
            mFImageWrapper.rogueInputData = true;
            if (bl) {
                this.theEventQueue.processEvent(mFImageWrapper);
            }
        }
    }

    public int getHeight(int n) {
        if (this.storedOutput) {
            if (n < 0) {
                throw new ArrayIndexOutOfBoundsException();
            }
            return this.storedOutputValue[MFImageWrapper.findStartOfImage(n, this.storedOutputValue) + 1];
        }
        this.checkReadAccess();
        VRMLFieldData vRMLFieldData = this.theNode.getFieldValue(this.fieldIndex);
        if (n < 0 || n >= this.countActualImages(vRMLFieldData.intArrayValue, vRMLFieldData.numElements)) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return vRMLFieldData.intArrayValue[MFImageWrapper.findStartOfImage(n, vRMLFieldData.intArrayValue) + 1];
    }

    public WritableRenderedImage getImage(int n) {
        throw new RuntimeException("Not yet implemented");
    }

    public void getPixels(int n, int[] nArray) {
        int[] nArray2;
        if (this.storedOutput) {
            if (n < 0) {
                throw new ArrayIndexOutOfBoundsException();
            }
            nArray2 = this.storedOutputValue;
        } else {
            this.checkReadAccess();
            VRMLFieldData vRMLFieldData = this.theNode.getFieldValue(this.fieldIndex);
            if (n < 0 || n >= this.countActualImages(vRMLFieldData.intArrayValue, vRMLFieldData.numElements)) {
                throw new ArrayIndexOutOfBoundsException();
            }
            nArray2 = vRMLFieldData.intArrayValue;
        }
        int n2 = MFImageWrapper.findStartOfImage(n, nArray2);
        int n3 = nArray2[n2] * nArray2[n2 + 1];
        System.arraycopy(nArray2, n2 + 3, nArray, 0, n3);
    }

    public int getWidth(int n) {
        if (this.storedOutput) {
            if (n < 0) {
                throw new ArrayIndexOutOfBoundsException();
            }
            return this.storedOutputValue[MFImageWrapper.findStartOfImage(n, this.storedOutputValue)];
        }
        this.checkReadAccess();
        VRMLFieldData vRMLFieldData = this.theNode.getFieldValue(this.fieldIndex);
        if (n < 0 || n >= this.countActualImages(vRMLFieldData.intArrayValue, vRMLFieldData.numElements)) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return vRMLFieldData.intArrayValue[MFImageWrapper.findStartOfImage(n, vRMLFieldData.intArrayValue)];
    }

    public void initialize(VRMLNodeType vRMLNodeType, int n) {
        this.theNode = vRMLNodeType;
        this.fieldIndex = n;
    }

    public boolean isConglomerating() {
        return this.isSetOneValue;
    }

    private void loadInputValue() {
        VRMLFieldData vRMLFieldData = this.theNode.getFieldValue(this.fieldIndex);
        int n = vRMLFieldData.numElements;
        if (this.storedInputValue == null || this.storedInputValue.length < n) {
            this.storedInputValue = new int[n];
        }
        System.arraycopy(vRMLFieldData.intArrayValue, 0, this.storedInputValue, 0, n);
        this.storedInput = true;
        this.storedInputLength = this.storedInputValue.length;
    }

    public void loadOutputValue() {
        VRMLFieldData vRMLFieldData = this.theNode.getFieldValue(this.fieldIndex);
        int n = vRMLFieldData.numElements;
        if (this.storedOutputValue == null || this.storedOutputValue.length < n) {
            this.storedOutputValue = new int[n];
        }
        System.arraycopy(vRMLFieldData.intArrayValue, 0, this.storedOutputValue, 0, n);
        this.storedOutput = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeValue(int n) throws ArrayIndexOutOfBoundsException {
        this.checkReadAccess();
        this.checkWriteAccess();
        Object object = this.theEventQueue.eventLock;
        synchronized (object) {
            MFImageWrapper mFImageWrapper = (MFImageWrapper)this.theEventQueue.getLast(this);
            boolean bl = false;
            if (mFImageWrapper == null || !mFImageWrapper.isSetOneValue) {
                if (!this.storedInput && !this.storedOutput) {
                    mFImageWrapper = this;
                    this.loadInputValue();
                    this.isSetOneValue = true;
                } else {
                    mFImageWrapper = new MFImageWrapper(this.theNode, this.fieldIndex, this.theEventQueue, this.theEventAdapterFactory, true);
                    mFImageWrapper.isSetOneValue = true;
                }
                bl = true;
            }
            if (mFImageWrapper.storedInputLength > 0) {
                if (n + 1 < mFImageWrapper.storedInputLength) {
                    System.arraycopy(mFImageWrapper.storedInputValue, n + 1, mFImageWrapper.storedInputValue, n, mFImageWrapper.storedInputLength - n);
                }
                --mFImageWrapper.storedInputLength;
                mFImageWrapper.rogueInputData = true;
                if (bl) {
                    this.theEventQueue.processEvent(mFImageWrapper);
                }
            } else {
                if (bl) {
                    mFImageWrapper.isSetOneValue = false;
                }
                throw new ArrayIndexOutOfBoundsException();
            }
        }
    }

    public void reset() {
        this.theNode = null;
        this.fieldIndex = -1;
        this.storedOutput = false;
        this.rogueInputData = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set1Value(int n, int n2) throws ArrayIndexOutOfBoundsException {
        this.checkReadAccess();
        this.checkWriteAccess();
        if (n2 < 0) {
            throw new IllegalArgumentException("Pixels may not be negative.");
        }
        if (n < 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        Object object = this.theEventQueue.eventLock;
        synchronized (object) {
            MFImageWrapper mFImageWrapper = (MFImageWrapper)this.theEventQueue.getLast(this);
            boolean bl = false;
            if (mFImageWrapper == null || !mFImageWrapper.isSetOneValue) {
                if (!this.storedInput && !this.storedOutput) {
                    mFImageWrapper = this;
                    this.loadInputValue();
                    this.isSetOneValue = true;
                } else {
                    mFImageWrapper = new MFImageWrapper(this.theNode, this.fieldIndex, this.theEventQueue, this.theEventAdapterFactory, true);
                    mFImageWrapper.isSetOneValue = true;
                }
                bl = true;
            }
            mFImageWrapper.storedInputValue[n] = n2;
            mFImageWrapper.rogueInputData = true;
            if (bl) {
                this.theEventQueue.processEvent(mFImageWrapper);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set1Value(int n, int n2, int n3, int n4, int[] nArray) {
        if (n < 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (n2 < 0 || n3 < 0 || n4 < 0 || n4 > 4) {
            throw new IllegalArgumentException();
        }
        this.checkWriteAccess();
        Object object = this.theEventQueue.eventLock;
        synchronized (object) {
            MFImageWrapper mFImageWrapper = (MFImageWrapper)this.theEventQueue.getLast(this);
            if (mFImageWrapper == null || !mFImageWrapper.isSetOneValue) {
                if (!this.storedInput && !this.storedOutput) {
                    if (n >= this.storedInputValue.length) {
                        throw new ArrayIndexOutOfBoundsException();
                    }
                    mFImageWrapper = this;
                    this.loadInputValue();
                    this.isSetOneValue = true;
                } else {
                    mFImageWrapper = new MFImageWrapper(this.theNode, this.fieldIndex, this.theEventQueue, this.theEventAdapterFactory, true);
                    mFImageWrapper.isSetOneValue = true;
                }
                mFImageWrapper.rewriteImageToSize(n, n2, n3);
                int n5 = mFImageWrapper.findStartOfInputImage(n);
                mFImageWrapper.storedInputValue[n5 + 2] = n4;
                if (nArray.length != 0) {
                    System.arraycopy(nArray, 0, mFImageWrapper.storedInputValue, n5 + 3, nArray.length);
                }
                this.theEventQueue.processEvent(mFImageWrapper);
            } else {
                this.checkDataSanity();
                mFImageWrapper.rewriteImageToSize(n, n2, n3);
                int n6 = mFImageWrapper.findStartOfInputImage(n);
                mFImageWrapper.storedInputValue[n6 + 2] = n4;
                if (nArray.length != 0) {
                    System.arraycopy(nArray, 0, mFImageWrapper.storedInputValue, n6 + 3, nArray.length);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setImage(int n, RenderedImage renderedImage) throws InvalidOperationTimingException, InvalidFieldValueException, InvalidWritableFieldException, InvalidFieldException {
        if (n < 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.checkWriteAccess();
        Object object = this.theEventQueue.eventLock;
        synchronized (object) {
            MFImageWrapper mFImageWrapper = (MFImageWrapper)this.theEventQueue.getLast(this);
            if (mFImageWrapper == null || !mFImageWrapper.isSetOneValue) {
                if (!this.storedInput && !this.storedOutput) {
                    if (n < 0) {
                        throw new ArrayIndexOutOfBoundsException();
                    }
                    this.loadInputValue();
                    if (n >= this.storedInputValue.length) {
                        throw new ArrayIndexOutOfBoundsException();
                    }
                    mFImageWrapper = this;
                    this.loadInputValue();
                    this.isSetOneValue = true;
                } else {
                    mFImageWrapper = new MFImageWrapper(this.theNode, this.fieldIndex, this.theEventQueue, this.theEventAdapterFactory, true);
                    mFImageWrapper.isSetOneValue = true;
                }
                mFImageWrapper.rewriteImageToSize(n, renderedImage.getWidth(), renderedImage.getHeight());
                SFImageWrapper.convertRenderedImageToData(renderedImage, mFImageWrapper.storedInputValue, mFImageWrapper.findStartOfInputImage(n));
                this.theEventQueue.processEvent(mFImageWrapper);
            } else {
                this.checkDataSanity();
                mFImageWrapper.rewriteImageToSize(n, renderedImage.getWidth(), renderedImage.getHeight());
                SFImageWrapper.convertRenderedImageToData(renderedImage, mFImageWrapper.storedInputValue, mFImageWrapper.findStartOfInputImage(n));
                mFImageWrapper.size();
            }
        }
    }

    public void setImage(RenderedImage[] renderedImageArray) throws InvalidOperationTimingException, InvalidFieldValueException, InvalidWritableFieldException, InvalidFieldException {
        this.checkWriteAccess();
        throw new RuntimeException("Not yet implemented");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSubImage(int n, RenderedImage renderedImage, int n2, int n3, int n4, int n5, int n6, int n7) throws InvalidOperationTimingException, InvalidFieldValueException, InvalidWritableFieldException, InvalidFieldException {
        this.checkWriteAccess();
        if (n < 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        Object object = this.theEventQueue.eventLock;
        synchronized (object) {
            MFImageWrapper mFImageWrapper = (MFImageWrapper)this.theEventQueue.getLast(this);
            if (mFImageWrapper == null || !mFImageWrapper.isSetOneValue) {
                if (!this.storedInput && !this.storedOutput) {
                    if (n >= this.storedInputValue.length) {
                        throw new ArrayIndexOutOfBoundsException();
                    }
                    mFImageWrapper = this;
                    this.loadInputValue();
                    this.isSetOneValue = true;
                } else {
                    mFImageWrapper = new MFImageWrapper(this.theNode, this.fieldIndex, this.theEventQueue, this.theEventAdapterFactory, true);
                    mFImageWrapper.isSetOneValue = true;
                }
                this.theEventQueue.processEvent(mFImageWrapper);
            } else {
                this.checkDataSanity();
            }
        }
    }

    public void setValue(int[] nArray) {
        this.checkWriteAccess();
        throw new RuntimeException("Not yet implemented");
    }

    public int size() {
        if (this.storedOutput) {
            return this.countActualImages(this.storedOutputValue, this.storedOutputValue.length);
        }
        if (this.storedInput) {
            return this.countActualImages(this.storedInputValue, this.storedInputValue.length);
        }
        VRMLFieldData vRMLFieldData = this.theNode.getFieldValue(this.fieldIndex);
        return this.countActualImages(vRMLFieldData.intArrayValue, vRMLFieldData.numElements);
    }

    int countActualImages(int[] nArray, int n) {
        if (nArray == null) {
            return 0;
        }
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            ++n2;
            n3 = n3 + nArray[n3] * nArray[n3 + 1] + 3;
        }
        if (n3 != nArray.length) {
            throw new RuntimeException("Corrupted MFImage field.");
        }
        return n2;
    }

    int calculateRequiredStorage(int n, int[] nArray) {
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            int n3 = nArray[n2] * nArray[n2 + 1] + 3;
            n2 += n3;
        }
        return n2;
    }

    static int findStartOfImage(int n, int[] nArray) {
        int n2 = 0;
        while (n > 0) {
            int n3 = nArray[n2] * nArray[n2 + 1] + 3;
            n2 += n3;
            --n;
        }
        return n2;
    }

    int findStartOfInputImage(int n) {
        return MFImageWrapper.findStartOfImage(n, this.storedInputValue);
    }

    void checkDataSanity() {
        if (!this.rogueInputData) {
            return;
        }
        try {
            int n;
            for (n = 0; n < this.storedInputValue.length; ++n) {
                if (this.storedInputValue[n] >= 0) continue;
                throw new RuntimeException("Corrupted data generated by user");
            }
            for (n = 0; n < this.storedInputValue.length; n += this.storedInputValue[n] * this.storedInputValue[n] + 3) {
            }
            if (n != this.storedInputValue.length) {
                throw new RuntimeException("Corrupted data generated by user");
            }
            this.rogueInputData = false;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new RuntimeException("Corrupted data generated by user");
        }
    }

    void rewriteImageToSize(int n, int n2, int n3) {
        int n4 = MFImageWrapper.findStartOfImage(n, this.storedInputValue);
        int n5 = n2 * n3 + 3;
        int n6 = this.storedInputValue[n4] * this.storedInputValue[n4 + 1] + 3;
        int[] nArray = new int[this.storedInputValue.length - n6 + n5];
        System.arraycopy(this.storedInputValue, 0, nArray, 0, n4);
        System.arraycopy(this.storedInputValue, n4 + n6, nArray, n4 + n5, this.storedInputValue.length - n4 - n6);
        this.storedInputValue = nArray;
    }
}

