/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.scripting.external.sai;

import org.web3d.util.ArrayUtils;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.scripting.external.buffer.ExternalEvent;
import org.web3d.vrml.scripting.external.buffer.ExternalEventQueue;
import org.web3d.vrml.scripting.external.buffer.ExternalOutputBuffer;
import org.web3d.vrml.scripting.external.sai.BaseFieldWrapper;
import org.web3d.vrml.scripting.external.sai.SAIEventAdapterFactory;
import org.web3d.x3d.sai.MFVec2d;

class MFVec2dWrapper
extends BaseFieldWrapper
implements MFVec2d,
ExternalEvent,
ExternalOutputBuffer {
    boolean isSetOneValue;
    int storedInputLength;
    double[] storedInputValue;
    double[] storedOutputValue;

    MFVec2dWrapper(VRMLNodeType vRMLNodeType, int n, ExternalEventQueue externalEventQueue, SAIEventAdapterFactory sAIEventAdapterFactory) {
        super(vRMLNodeType, n, externalEventQueue, sAIEventAdapterFactory);
    }

    MFVec2dWrapper(VRMLNodeType vRMLNodeType, int n, ExternalEventQueue externalEventQueue, SAIEventAdapterFactory sAIEventAdapterFactory, boolean bl) {
        this(vRMLNodeType, n, externalEventQueue, sAIEventAdapterFactory);
        if (bl) {
            this.loadInputValue();
        } else {
            this.loadOutputValue();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void append(double[] dArray) {
        this.checkReadAccess();
        this.checkWriteAccess();
        Object object = this.theEventQueue.eventLock;
        synchronized (object) {
            MFVec2dWrapper mFVec2dWrapper = (MFVec2dWrapper)this.theEventQueue.getLast(this);
            boolean bl = false;
            if (mFVec2dWrapper == null || !mFVec2dWrapper.isSetOneValue) {
                if (!this.storedInput && !this.storedOutput) {
                    mFVec2dWrapper = this;
                    this.loadInputValue();
                    this.isSetOneValue = true;
                } else {
                    mFVec2dWrapper = new MFVec2dWrapper(this.theNode, this.fieldIndex, this.theEventQueue, this.theEventAdapterFactory, true);
                    mFVec2dWrapper.isSetOneValue = true;
                }
                bl = true;
            }
            mFVec2dWrapper.ensureArraySize(mFVec2dWrapper.storedInputLength + 2);
            mFVec2dWrapper.storedInputValue[mFVec2dWrapper.storedInputLength++] = dArray[0];
            mFVec2dWrapper.storedInputValue[mFVec2dWrapper.storedInputLength++] = dArray[1];
            if (bl) {
                this.theEventQueue.processEvent(mFVec2dWrapper);
            }
        }
    }

    public void clear() {
        this.setValue(0, new double[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doEvent() {
        try {
            this.theNode.setValue(this.fieldIndex, this.storedInputValue, this.storedInputLength);
        }
        finally {
            this.isSetOneValue = false;
            this.storedInput = false;
        }
    }

    protected void ensureArraySize(int n) {
        if (this.storedInputValue != null && n < this.storedInputValue.length) {
            return;
        }
        double[] dArray = new double[n];
        if (this.storedInputValue != null) {
            System.arraycopy(this.storedInputValue, 0, dArray, 0, this.storedInputLength);
        }
        this.storedInputValue = dArray;
    }

    public void get1Value(int n, double[] dArray) {
        if (this.storedOutput) {
            dArray[0] = this.storedOutputValue[n];
            dArray[1] = this.storedOutputValue[n + 1];
        } else {
            this.checkReadAccess();
            VRMLFieldData vRMLFieldData = this.theNode.getFieldValue(this.fieldIndex);
            if (n < 0 || n >= vRMLFieldData.numElements) {
                throw new ArrayIndexOutOfBoundsException();
            }
            dArray[0] = vRMLFieldData.doubleArrayValue[n];
            dArray[1] = vRMLFieldData.doubleArrayValue[n + 1];
        }
    }

    public void getValue(double[] dArray) {
        if (this.storedOutput) {
            System.arraycopy(this.storedOutputValue, 0, dArray, 0, this.storedOutputValue.length);
        } else {
            this.checkReadAccess();
            VRMLFieldData vRMLFieldData = this.theNode.getFieldValue(this.fieldIndex);
            if (vRMLFieldData.numElements != 0) {
                System.arraycopy(vRMLFieldData.doubleArrayValue, 0, dArray, 0, vRMLFieldData.numElements * 2);
            }
        }
    }

    public void getValue(double[][] dArray) {
        if (this.storedOutput) {
            ArrayUtils.raise2(this.storedOutputValue, this.storedOutputValue.length / 2, dArray);
        } else {
            VRMLFieldData vRMLFieldData = this.theNode.getFieldValue(this.fieldIndex);
            ArrayUtils.raise2(vRMLFieldData.doubleArrayValue, vRMLFieldData.numElements, dArray);
        }
    }

    public void initialize(VRMLNodeType vRMLNodeType, int n) {
        this.theNode = vRMLNodeType;
        this.fieldIndex = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertValue(int n, double[] dArray) throws ArrayIndexOutOfBoundsException {
        this.checkReadAccess();
        this.checkWriteAccess();
        Object object = this.theEventQueue.eventLock;
        synchronized (object) {
            MFVec2dWrapper mFVec2dWrapper = (MFVec2dWrapper)this.theEventQueue.getLast(this);
            boolean bl = false;
            if (mFVec2dWrapper == null || !mFVec2dWrapper.isSetOneValue) {
                if (!this.storedInput && !this.storedOutput) {
                    mFVec2dWrapper = this;
                    this.loadInputValue();
                    this.isSetOneValue = true;
                } else {
                    mFVec2dWrapper = new MFVec2dWrapper(this.theNode, this.fieldIndex, this.theEventQueue, this.theEventAdapterFactory, true);
                    mFVec2dWrapper.isSetOneValue = true;
                }
                bl = true;
            }
            mFVec2dWrapper.ensureArraySize(mFVec2dWrapper.storedInputLength + 2);
            System.arraycopy(mFVec2dWrapper.storedInputValue, n * 2, mFVec2dWrapper.storedInputValue, n * 2 + 2, mFVec2dWrapper.storedInputLength - n * 2);
            mFVec2dWrapper.storedInputValue[n * 2] = dArray[0];
            mFVec2dWrapper.storedInputValue[n * 2 + 1] = dArray[1];
            mFVec2dWrapper.storedInputLength += 2;
            if (bl) {
                this.theEventQueue.processEvent(mFVec2dWrapper);
            }
        }
    }

    public boolean isConglomerating() {
        return this.isSetOneValue;
    }

    private void loadInputValue() {
        VRMLFieldData vRMLFieldData = this.theNode.getFieldValue(this.fieldIndex);
        if (this.storedInputValue == null || this.storedInputValue.length != vRMLFieldData.numElements) {
            this.storedInputValue = new double[vRMLFieldData.numElements];
        }
        if (vRMLFieldData.numElements != 0) {
            System.arraycopy(vRMLFieldData.doubleArrayValue, 0, this.storedInputValue, 0, vRMLFieldData.numElements * 2);
        }
        this.storedInput = true;
        this.storedInputLength = this.storedInputValue.length;
    }

    public void loadOutputValue() {
        VRMLFieldData vRMLFieldData = this.theNode.getFieldValue(this.fieldIndex);
        if (this.storedOutputValue == null || this.storedOutputValue.length != vRMLFieldData.numElements) {
            this.storedOutputValue = new double[vRMLFieldData.numElements];
        }
        if (vRMLFieldData.numElements != 0) {
            System.arraycopy(vRMLFieldData.doubleArrayValue, 0, this.storedOutputValue, 0, vRMLFieldData.numElements * 2);
        }
        this.storedOutput = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeValue(int n) throws ArrayIndexOutOfBoundsException {
        this.checkReadAccess();
        this.checkWriteAccess();
        Object object = this.theEventQueue.eventLock;
        synchronized (object) {
            MFVec2dWrapper mFVec2dWrapper = (MFVec2dWrapper)this.theEventQueue.getLast(this);
            boolean bl = false;
            if (mFVec2dWrapper == null || !mFVec2dWrapper.isSetOneValue) {
                if (!this.storedInput && !this.storedOutput) {
                    mFVec2dWrapper = this;
                    this.loadInputValue();
                    this.isSetOneValue = true;
                } else {
                    mFVec2dWrapper = new MFVec2dWrapper(this.theNode, this.fieldIndex, this.theEventQueue, this.theEventAdapterFactory, true);
                    mFVec2dWrapper.isSetOneValue = true;
                }
                bl = true;
            }
            if (mFVec2dWrapper.storedInputLength > 0) {
                if (n * 2 + 2 < mFVec2dWrapper.storedInputLength) {
                    System.arraycopy(mFVec2dWrapper.storedInputValue, n * 2 + 2, mFVec2dWrapper.storedInputValue, n * 2, mFVec2dWrapper.storedInputLength - n * 2);
                }
                mFVec2dWrapper.storedInputLength -= 2;
                if (bl) {
                    this.theEventQueue.processEvent(mFVec2dWrapper);
                }
            } else {
                if (bl) {
                    mFVec2dWrapper.isSetOneValue = false;
                }
                throw new ArrayIndexOutOfBoundsException();
            }
        }
    }

    public void reset() {
        this.theNode = null;
        this.fieldIndex = -1;
        this.storedOutput = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set1Value(int n, double[] dArray) throws ArrayIndexOutOfBoundsException {
        this.checkReadAccess();
        this.checkWriteAccess();
        Object object = this.theEventQueue.eventLock;
        synchronized (object) {
            MFVec2dWrapper mFVec2dWrapper = (MFVec2dWrapper)this.theEventQueue.getLast(this);
            boolean bl = false;
            if (mFVec2dWrapper == null || !mFVec2dWrapper.isSetOneValue) {
                if (!this.storedInput && !this.storedOutput) {
                    mFVec2dWrapper = this;
                    this.loadInputValue();
                    this.isSetOneValue = true;
                } else {
                    mFVec2dWrapper = new MFVec2dWrapper(this.theNode, this.fieldIndex, this.theEventQueue, this.theEventAdapterFactory, true);
                    mFVec2dWrapper.isSetOneValue = true;
                }
                bl = true;
                this.theEventQueue.processEvent(mFVec2dWrapper);
            }
            mFVec2dWrapper.storedInputValue[n * 2] = dArray[0];
            mFVec2dWrapper.storedInputValue[n * 2 + 1] = dArray[1];
            if (bl) {
                this.theEventQueue.processEvent(mFVec2dWrapper);
            }
        }
    }

    public void setValue(int n, double[] dArray) {
        this.checkWriteAccess();
        MFVec2dWrapper mFVec2dWrapper = this;
        if (this.isSetOneValue || this.storedInput || this.storedOutput) {
            mFVec2dWrapper = new MFVec2dWrapper(this.theNode, this.fieldIndex, this.theEventQueue, this.theEventAdapterFactory);
        }
        mFVec2dWrapper.storedInput = true;
        if (mFVec2dWrapper.storedInputValue == null || mFVec2dWrapper.storedInputValue.length != n * 2) {
            mFVec2dWrapper.storedInputValue = new double[n * 2];
        }
        System.arraycopy(dArray, 0, mFVec2dWrapper.storedInputValue, 0, n * 2);
        mFVec2dWrapper.storedInputLength = n * 2;
        this.theEventQueue.processEvent(mFVec2dWrapper);
    }

    public void setValue(int n, double[][] dArray) {
        this.checkWriteAccess();
        MFVec2dWrapper mFVec2dWrapper = this;
        if (this.isSetOneValue || this.storedInput || this.storedOutput) {
            mFVec2dWrapper = new MFVec2dWrapper(this.theNode, this.fieldIndex, this.theEventQueue, this.theEventAdapterFactory);
        }
        mFVec2dWrapper.storedInput = true;
        if (mFVec2dWrapper.storedInputValue == null || mFVec2dWrapper.storedInputValue.length != n * 2) {
            mFVec2dWrapper.storedInputValue = new double[n * 2];
        }
        ArrayUtils.flatten2(dArray, n, mFVec2dWrapper.storedInputValue);
        mFVec2dWrapper.storedInputLength = n * 2;
        this.theEventQueue.processEvent(mFVec2dWrapper);
    }

    public int size() {
        if (this.storedOutput) {
            return this.storedOutputValue.length / 2;
        }
        return this.theNode.getFieldValue((int)this.fieldIndex).numElements;
    }
}

