/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.scripting.external.sai;

import org.web3d.util.ArrayUtils;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.scripting.external.buffer.ExternalEvent;
import org.web3d.vrml.scripting.external.buffer.ExternalEventQueue;
import org.web3d.vrml.scripting.external.buffer.ExternalOutputBuffer;
import org.web3d.vrml.scripting.external.sai.BaseFieldWrapper;
import org.web3d.vrml.scripting.external.sai.SAIEventAdapterFactory;
import org.web3d.x3d.sai.MFVec3d;

class MFVec3dWrapper
extends BaseFieldWrapper
implements MFVec3d,
ExternalEvent,
ExternalOutputBuffer {
    boolean isSetOneValue;
    int storedInputLength;
    double[] storedInputValue;
    double[] storedOutputValue;

    MFVec3dWrapper(VRMLNodeType vRMLNodeType, int n, ExternalEventQueue externalEventQueue, SAIEventAdapterFactory sAIEventAdapterFactory) {
        super(vRMLNodeType, n, externalEventQueue, sAIEventAdapterFactory);
    }

    MFVec3dWrapper(VRMLNodeType vRMLNodeType, int n, ExternalEventQueue externalEventQueue, SAIEventAdapterFactory sAIEventAdapterFactory, boolean bl) {
        this(vRMLNodeType, n, externalEventQueue, sAIEventAdapterFactory);
        if (bl) {
            this.loadInputValue();
        } else {
            this.loadOutputValue();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void append(double[] dArray) {
        this.checkReadAccess();
        this.checkWriteAccess();
        Object object = this.theEventQueue.eventLock;
        synchronized (object) {
            MFVec3dWrapper mFVec3dWrapper = (MFVec3dWrapper)this.theEventQueue.getLast(this);
            boolean bl = false;
            if (mFVec3dWrapper == null || !mFVec3dWrapper.isSetOneValue) {
                if (!this.storedInput && !this.storedOutput) {
                    mFVec3dWrapper = this;
                    this.loadInputValue();
                    this.isSetOneValue = true;
                } else {
                    mFVec3dWrapper = new MFVec3dWrapper(this.theNode, this.fieldIndex, this.theEventQueue, this.theEventAdapterFactory, true);
                    mFVec3dWrapper.isSetOneValue = true;
                }
                bl = true;
            }
            mFVec3dWrapper.ensureArraySize(mFVec3dWrapper.storedInputLength + 3);
            mFVec3dWrapper.storedInputValue[mFVec3dWrapper.storedInputLength++] = dArray[0];
            mFVec3dWrapper.storedInputValue[mFVec3dWrapper.storedInputLength++] = dArray[1];
            mFVec3dWrapper.storedInputValue[mFVec3dWrapper.storedInputLength++] = dArray[2];
            if (bl) {
                this.theEventQueue.processEvent(mFVec3dWrapper);
            }
        }
    }

    public void clear() {
        this.setValue(0, new double[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doEvent() {
        try {
            this.theNode.setValue(this.fieldIndex, this.storedInputValue, this.storedInputLength);
        }
        finally {
            this.isSetOneValue = false;
            this.storedInput = false;
        }
    }

    protected void ensureArraySize(int n) {
        if (this.storedInputValue != null && n < this.storedInputValue.length) {
            return;
        }
        double[] dArray = new double[n];
        if (this.storedInputValue != null) {
            System.arraycopy(this.storedInputValue, 0, dArray, 0, this.storedInputLength);
        }
        this.storedInputValue = dArray;
    }

    public void get1Value(int n, double[] dArray) {
        if (this.storedOutput) {
            System.arraycopy(this.storedOutputValue, n * 3, dArray, 0, 3);
        } else {
            this.checkReadAccess();
            VRMLFieldData vRMLFieldData = this.theNode.getFieldValue(this.fieldIndex);
            if (n < 0 || n >= vRMLFieldData.numElements) {
                throw new ArrayIndexOutOfBoundsException();
            }
            System.arraycopy(vRMLFieldData.doubleArrayValue, n * 3, dArray, 0, 3);
        }
    }

    public void getValue(double[] dArray) {
        if (this.storedOutput) {
            System.arraycopy(this.storedOutputValue, 0, dArray, 0, this.storedOutputValue.length);
        } else {
            this.checkReadAccess();
            VRMLFieldData vRMLFieldData = this.theNode.getFieldValue(this.fieldIndex);
            if (vRMLFieldData.numElements != 0) {
                System.arraycopy(vRMLFieldData.doubleArrayValue, 0, dArray, 0, vRMLFieldData.numElements * 3);
            }
        }
    }

    public void getValue(double[][] dArray) {
        if (this.storedOutput) {
            ArrayUtils.raise3(this.storedOutputValue, this.storedOutputValue.length / 3, dArray);
        } else {
            this.checkReadAccess();
            VRMLFieldData vRMLFieldData = this.theNode.getFieldValue(this.fieldIndex);
            ArrayUtils.raise3(vRMLFieldData.doubleArrayValue, vRMLFieldData.numElements, dArray);
        }
    }

    public void initialize(VRMLNodeType vRMLNodeType, int n) {
        this.theNode = vRMLNodeType;
        this.fieldIndex = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertValue(int n, double[] dArray) throws ArrayIndexOutOfBoundsException {
        this.checkReadAccess();
        this.checkWriteAccess();
        Object object = this.theEventQueue.eventLock;
        synchronized (object) {
            MFVec3dWrapper mFVec3dWrapper = (MFVec3dWrapper)this.theEventQueue.getLast(this);
            boolean bl = false;
            if (mFVec3dWrapper == null || !mFVec3dWrapper.isSetOneValue) {
                if (!this.storedInput && !this.storedOutput) {
                    mFVec3dWrapper = this;
                    this.loadInputValue();
                    this.isSetOneValue = true;
                } else {
                    mFVec3dWrapper = new MFVec3dWrapper(this.theNode, this.fieldIndex, this.theEventQueue, this.theEventAdapterFactory, true);
                    mFVec3dWrapper.isSetOneValue = true;
                }
                bl = true;
            }
            mFVec3dWrapper.ensureArraySize(mFVec3dWrapper.storedInputLength + 3);
            System.arraycopy(mFVec3dWrapper.storedInputValue, n * 3, mFVec3dWrapper.storedInputValue, n * 3 + 3, mFVec3dWrapper.storedInputLength - n * 3);
            mFVec3dWrapper.storedInputValue[n * 3] = dArray[0];
            mFVec3dWrapper.storedInputValue[n * 3 + 1] = dArray[1];
            mFVec3dWrapper.storedInputValue[n * 3 + 2] = dArray[2];
            mFVec3dWrapper.storedInputLength += 3;
            if (bl) {
                this.theEventQueue.processEvent(mFVec3dWrapper);
            }
        }
    }

    public boolean isConglomerating() {
        return this.isSetOneValue;
    }

    private void loadInputValue() {
        VRMLFieldData vRMLFieldData = this.theNode.getFieldValue(this.fieldIndex);
        if (this.storedInputValue == null || this.storedInputValue.length != vRMLFieldData.numElements * 3) {
            this.storedInputValue = new double[vRMLFieldData.numElements * 3];
        }
        if (vRMLFieldData.numElements != 0) {
            System.arraycopy(vRMLFieldData.doubleArrayValue, 0, this.storedInputValue, 0, vRMLFieldData.numElements * 3);
        }
        this.storedInput = true;
        this.storedInputLength = this.storedInputValue.length;
    }

    public void loadOutputValue() {
        VRMLFieldData vRMLFieldData = this.theNode.getFieldValue(this.fieldIndex);
        if (this.storedOutputValue == null || this.storedOutputValue.length != vRMLFieldData.numElements) {
            this.storedOutputValue = new double[vRMLFieldData.numElements * 3];
        }
        if (vRMLFieldData.numElements != 0) {
            System.arraycopy(vRMLFieldData.doubleArrayValue, 0, this.storedOutputValue, 0, vRMLFieldData.numElements * 3);
        }
        this.storedOutput = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeValue(int n) throws ArrayIndexOutOfBoundsException {
        this.checkReadAccess();
        this.checkWriteAccess();
        Object object = this.theEventQueue.eventLock;
        synchronized (object) {
            MFVec3dWrapper mFVec3dWrapper = (MFVec3dWrapper)this.theEventQueue.getLast(this);
            boolean bl = false;
            if (mFVec3dWrapper == null || !mFVec3dWrapper.isSetOneValue) {
                if (!this.storedInput && !this.storedOutput) {
                    mFVec3dWrapper = this;
                    this.loadInputValue();
                    this.isSetOneValue = true;
                } else {
                    mFVec3dWrapper = new MFVec3dWrapper(this.theNode, this.fieldIndex, this.theEventQueue, this.theEventAdapterFactory, true);
                    mFVec3dWrapper.isSetOneValue = true;
                }
                bl = true;
            }
            if (mFVec3dWrapper.storedInputLength > 0) {
                if (n * 3 + 3 < mFVec3dWrapper.storedInputLength) {
                    System.arraycopy(mFVec3dWrapper.storedInputValue, n * 3 + 3, mFVec3dWrapper.storedInputValue, n * 3, mFVec3dWrapper.storedInputLength - n * 3);
                }
                mFVec3dWrapper.storedInputLength -= 3;
                if (bl) {
                    this.theEventQueue.processEvent(mFVec3dWrapper);
                }
            } else {
                if (bl) {
                    mFVec3dWrapper.isSetOneValue = false;
                }
                throw new ArrayIndexOutOfBoundsException();
            }
        }
    }

    public void reset() {
        this.theNode = null;
        this.fieldIndex = -1;
        this.storedOutput = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set1Value(int n, double[] dArray) {
        this.checkReadAccess();
        this.checkWriteAccess();
        Object object = this.theEventQueue.eventLock;
        synchronized (object) {
            MFVec3dWrapper mFVec3dWrapper = (MFVec3dWrapper)this.theEventQueue.getLast(this);
            boolean bl = false;
            if (mFVec3dWrapper == null || !mFVec3dWrapper.isSetOneValue) {
                if (!this.storedInput && !this.storedOutput) {
                    mFVec3dWrapper = this;
                    this.loadInputValue();
                    this.isSetOneValue = true;
                } else {
                    mFVec3dWrapper = new MFVec3dWrapper(this.theNode, this.fieldIndex, this.theEventQueue, this.theEventAdapterFactory, true);
                    mFVec3dWrapper.isSetOneValue = true;
                }
                bl = true;
            }
            System.arraycopy(dArray, 0, mFVec3dWrapper.storedInputValue, n * 3, 3);
            if (bl) {
                this.theEventQueue.processEvent(mFVec3dWrapper);
            }
        }
    }

    public void setValue(int n, double[] dArray) {
        this.checkWriteAccess();
        MFVec3dWrapper mFVec3dWrapper = this;
        if (this.isSetOneValue || this.storedInput || this.storedOutput) {
            mFVec3dWrapper = new MFVec3dWrapper(this.theNode, this.fieldIndex, this.theEventQueue, this.theEventAdapterFactory);
        }
        mFVec3dWrapper.storedInput = true;
        if (mFVec3dWrapper.storedInputValue == null || mFVec3dWrapper.storedInputValue.length != n * 3) {
            mFVec3dWrapper.storedInputValue = new double[n * 3];
        }
        System.arraycopy(dArray, 0, mFVec3dWrapper.storedInputValue, 0, n * 3);
        mFVec3dWrapper.storedInputLength = n * 3;
        this.theEventQueue.processEvent(mFVec3dWrapper);
    }

    public void setValue(int n, double[][] dArray) {
        this.checkWriteAccess();
        MFVec3dWrapper mFVec3dWrapper = this;
        if (this.isSetOneValue || this.storedInput || this.storedOutput) {
            mFVec3dWrapper = new MFVec3dWrapper(this.theNode, this.fieldIndex, this.theEventQueue, this.theEventAdapterFactory);
        }
        mFVec3dWrapper.storedInput = true;
        if (mFVec3dWrapper.storedInputValue == null || mFVec3dWrapper.storedInputValue.length != n * 3) {
            mFVec3dWrapper.storedInputValue = new double[n * 3];
        }
        ArrayUtils.flatten3(dArray, n, mFVec3dWrapper.storedInputValue);
        mFVec3dWrapper.storedInputLength = n * 3;
        this.theEventQueue.processEvent(mFVec3dWrapper);
    }

    public int size() {
        if (this.storedOutput) {
            return this.storedOutputValue.length / 3;
        }
        return this.theNode.getFieldValue((int)this.fieldIndex).numElements;
    }
}

