/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.scripting.external.sai;

import org.web3d.util.ArrayUtils;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.scripting.external.buffer.ExternalEvent;
import org.web3d.vrml.scripting.external.buffer.ExternalEventQueue;
import org.web3d.vrml.scripting.external.buffer.ExternalOutputBuffer;
import org.web3d.vrml.scripting.external.sai.BaseFieldWrapper;
import org.web3d.vrml.scripting.external.sai.SAIEventAdapterFactory;
import org.web3d.x3d.sai.MFVec3f;

class MFVec3fWrapper
extends BaseFieldWrapper
implements MFVec3f,
ExternalEvent,
ExternalOutputBuffer {
    boolean isSetOneValue;
    int storedInputLength;
    float[] storedInputValue;
    float[] storedOutputValue;

    MFVec3fWrapper(VRMLNodeType vRMLNodeType, int n, ExternalEventQueue externalEventQueue, SAIEventAdapterFactory sAIEventAdapterFactory) {
        super(vRMLNodeType, n, externalEventQueue, sAIEventAdapterFactory);
    }

    MFVec3fWrapper(VRMLNodeType vRMLNodeType, int n, ExternalEventQueue externalEventQueue, SAIEventAdapterFactory sAIEventAdapterFactory, boolean bl) {
        this(vRMLNodeType, n, externalEventQueue, sAIEventAdapterFactory);
        if (bl) {
            this.loadInputValue();
        } else {
            this.loadOutputValue();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void append(float[] fArray) {
        this.checkReadAccess();
        this.checkWriteAccess();
        Object object = this.theEventQueue.eventLock;
        synchronized (object) {
            MFVec3fWrapper mFVec3fWrapper = (MFVec3fWrapper)this.theEventQueue.getLast(this);
            boolean bl = false;
            if (mFVec3fWrapper == null || !mFVec3fWrapper.isSetOneValue) {
                if (!this.storedInput && !this.storedOutput) {
                    mFVec3fWrapper = this;
                    this.loadInputValue();
                    this.isSetOneValue = true;
                } else {
                    mFVec3fWrapper = new MFVec3fWrapper(this.theNode, this.fieldIndex, this.theEventQueue, this.theEventAdapterFactory, true);
                    mFVec3fWrapper.isSetOneValue = true;
                }
                bl = true;
            }
            mFVec3fWrapper.ensureArraySize(mFVec3fWrapper.storedInputLength + 3);
            mFVec3fWrapper.storedInputValue[mFVec3fWrapper.storedInputLength++] = fArray[0];
            mFVec3fWrapper.storedInputValue[mFVec3fWrapper.storedInputLength++] = fArray[1];
            mFVec3fWrapper.storedInputValue[mFVec3fWrapper.storedInputLength++] = fArray[2];
            if (bl) {
                this.theEventQueue.processEvent(mFVec3fWrapper);
            }
        }
    }

    public void clear() {
        this.setValue(0, new float[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doEvent() {
        try {
            this.theNode.setValue(this.fieldIndex, this.storedInputValue, this.storedInputLength);
        }
        finally {
            this.isSetOneValue = false;
            this.storedInput = false;
        }
    }

    protected void ensureArraySize(int n) {
        if (this.storedInputValue != null && n < this.storedInputValue.length) {
            return;
        }
        float[] fArray = new float[n];
        if (this.storedInputValue != null) {
            System.arraycopy(this.storedInputValue, 0, fArray, 0, this.storedInputLength);
        }
        this.storedInputValue = fArray;
    }

    public void get1Value(int n, float[] fArray) {
        if (this.storedOutput) {
            System.arraycopy(this.storedOutputValue, n * 3, fArray, 0, 3);
        } else {
            this.checkReadAccess();
            VRMLFieldData vRMLFieldData = this.theNode.getFieldValue(this.fieldIndex);
            if (n < 0 || n >= vRMLFieldData.numElements) {
                throw new ArrayIndexOutOfBoundsException();
            }
            System.arraycopy(vRMLFieldData.floatArrayValue, n * 3, fArray, 0, 3);
        }
    }

    public void getValue(float[] fArray) {
        if (this.storedOutput) {
            System.arraycopy(this.storedOutputValue, 0, fArray, 0, this.storedOutputValue.length);
        } else {
            this.checkReadAccess();
            VRMLFieldData vRMLFieldData = this.theNode.getFieldValue(this.fieldIndex);
            if (vRMLFieldData.numElements != 0) {
                System.arraycopy(vRMLFieldData.floatArrayValue, 0, fArray, 0, vRMLFieldData.numElements * 3);
            }
        }
    }

    public void getValue(float[][] fArray) {
        if (this.storedOutput) {
            ArrayUtils.raise3(this.storedOutputValue, this.storedOutputValue.length / 3, fArray);
        } else {
            this.checkReadAccess();
            VRMLFieldData vRMLFieldData = this.theNode.getFieldValue(this.fieldIndex);
            if (vRMLFieldData.numElements != 0) {
                ArrayUtils.raise3(vRMLFieldData.floatArrayValue, vRMLFieldData.numElements, fArray);
            }
        }
    }

    public void initialize(VRMLNodeType vRMLNodeType, int n) {
        this.theNode = vRMLNodeType;
        this.fieldIndex = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertValue(int n, float[] fArray) throws ArrayIndexOutOfBoundsException {
        this.checkReadAccess();
        this.checkWriteAccess();
        Object object = this.theEventQueue.eventLock;
        synchronized (object) {
            MFVec3fWrapper mFVec3fWrapper = (MFVec3fWrapper)this.theEventQueue.getLast(this);
            boolean bl = false;
            if (mFVec3fWrapper == null || !mFVec3fWrapper.isSetOneValue) {
                if (!this.storedInput && !this.storedOutput) {
                    mFVec3fWrapper = this;
                    this.loadInputValue();
                    this.isSetOneValue = true;
                } else {
                    mFVec3fWrapper = new MFVec3fWrapper(this.theNode, this.fieldIndex, this.theEventQueue, this.theEventAdapterFactory, true);
                    mFVec3fWrapper.isSetOneValue = true;
                }
                bl = true;
            }
            mFVec3fWrapper.ensureArraySize(mFVec3fWrapper.storedInputLength + 3);
            System.arraycopy(mFVec3fWrapper.storedInputValue, n * 3, mFVec3fWrapper.storedInputValue, n * 3 + 3, mFVec3fWrapper.storedInputLength - n * 3);
            mFVec3fWrapper.storedInputValue[n * 3] = fArray[0];
            mFVec3fWrapper.storedInputValue[n * 3 + 1] = fArray[1];
            mFVec3fWrapper.storedInputValue[n * 3 + 2] = fArray[2];
            mFVec3fWrapper.storedInputLength += 3;
            if (bl) {
                this.theEventQueue.processEvent(mFVec3fWrapper);
            }
        }
    }

    public boolean isConglomerating() {
        return this.isSetOneValue;
    }

    private void loadInputValue() {
        VRMLFieldData vRMLFieldData = this.theNode.getFieldValue(this.fieldIndex);
        if (this.storedInputValue == null || this.storedInputValue.length != vRMLFieldData.numElements * 3) {
            this.storedInputValue = new float[vRMLFieldData.numElements * 3];
        }
        if (vRMLFieldData.numElements != 0) {
            System.arraycopy(vRMLFieldData.floatArrayValue, 0, this.storedInputValue, 0, vRMLFieldData.numElements * 3);
        }
        this.storedInput = true;
        this.storedInputLength = this.storedInputValue.length;
    }

    public void loadOutputValue() {
        VRMLFieldData vRMLFieldData = this.theNode.getFieldValue(this.fieldIndex);
        if (this.storedOutputValue == null || this.storedOutputValue.length != vRMLFieldData.numElements) {
            this.storedOutputValue = new float[vRMLFieldData.numElements * 3];
        }
        if (vRMLFieldData.numElements != 0) {
            System.arraycopy(vRMLFieldData.floatArrayValue, 0, this.storedOutputValue, 0, vRMLFieldData.numElements * 3);
        }
        this.storedOutput = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeValue(int n) throws ArrayIndexOutOfBoundsException {
        this.checkReadAccess();
        this.checkWriteAccess();
        Object object = this.theEventQueue.eventLock;
        synchronized (object) {
            MFVec3fWrapper mFVec3fWrapper = (MFVec3fWrapper)this.theEventQueue.getLast(this);
            boolean bl = false;
            if (mFVec3fWrapper == null || !mFVec3fWrapper.isSetOneValue) {
                if (!this.storedInput && !this.storedOutput) {
                    mFVec3fWrapper = this;
                    this.loadInputValue();
                    this.isSetOneValue = true;
                } else {
                    mFVec3fWrapper = new MFVec3fWrapper(this.theNode, this.fieldIndex, this.theEventQueue, this.theEventAdapterFactory, true);
                    mFVec3fWrapper.isSetOneValue = true;
                }
                bl = true;
            }
            if (mFVec3fWrapper.storedInputLength > 0) {
                if (n * 3 + 3 < mFVec3fWrapper.storedInputLength) {
                    System.arraycopy(mFVec3fWrapper.storedInputValue, n * 3 + 3, mFVec3fWrapper.storedInputValue, n * 3, mFVec3fWrapper.storedInputLength - n * 3);
                }
                mFVec3fWrapper.storedInputLength -= 3;
                if (bl) {
                    this.theEventQueue.processEvent(mFVec3fWrapper);
                }
            } else {
                if (bl) {
                    mFVec3fWrapper.isSetOneValue = false;
                }
                throw new ArrayIndexOutOfBoundsException();
            }
        }
    }

    public void reset() {
        this.theNode = null;
        this.fieldIndex = -1;
        this.storedOutput = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set1Value(int n, float[] fArray) throws ArrayIndexOutOfBoundsException {
        this.checkReadAccess();
        this.checkWriteAccess();
        Object object = this.theEventQueue.eventLock;
        synchronized (object) {
            MFVec3fWrapper mFVec3fWrapper = (MFVec3fWrapper)this.theEventQueue.getLast(this);
            boolean bl = false;
            if (mFVec3fWrapper == null || !mFVec3fWrapper.isSetOneValue) {
                if (!this.storedInput && !this.storedOutput) {
                    mFVec3fWrapper = this;
                    this.loadInputValue();
                    this.isSetOneValue = true;
                } else {
                    mFVec3fWrapper = new MFVec3fWrapper(this.theNode, this.fieldIndex, this.theEventQueue, this.theEventAdapterFactory, true);
                    mFVec3fWrapper.isSetOneValue = true;
                }
                bl = true;
            }
            System.arraycopy(fArray, 0, mFVec3fWrapper.storedInputValue, n * 3, 3);
            if (bl) {
                this.theEventQueue.processEvent(mFVec3fWrapper);
            }
        }
    }

    public void setValue(int n, float[] fArray) {
        this.checkWriteAccess();
        MFVec3fWrapper mFVec3fWrapper = this;
        if (this.isSetOneValue || this.storedInput || this.storedOutput) {
            mFVec3fWrapper = new MFVec3fWrapper(this.theNode, this.fieldIndex, this.theEventQueue, this.theEventAdapterFactory);
        }
        mFVec3fWrapper.storedInput = true;
        if (mFVec3fWrapper.storedInputValue == null || mFVec3fWrapper.storedInputValue.length != n * 3) {
            mFVec3fWrapper.storedInputValue = new float[n * 3];
        }
        System.arraycopy(fArray, 0, mFVec3fWrapper.storedInputValue, 0, n * 3);
        mFVec3fWrapper.storedInputLength = n * 3;
        this.theEventQueue.processEvent(mFVec3fWrapper);
    }

    public void setValue(int n, float[][] fArray) {
        this.checkWriteAccess();
        MFVec3fWrapper mFVec3fWrapper = this;
        if (this.isSetOneValue || this.storedInput || this.storedOutput) {
            mFVec3fWrapper = new MFVec3fWrapper(this.theNode, this.fieldIndex, this.theEventQueue, this.theEventAdapterFactory);
        }
        mFVec3fWrapper.storedInput = true;
        if (mFVec3fWrapper.storedInputValue == null || mFVec3fWrapper.storedInputValue.length != n * 3) {
            mFVec3fWrapper.storedInputValue = new float[n * 3];
        }
        ArrayUtils.flatten3(fArray, n, mFVec3fWrapper.storedInputValue);
        mFVec3fWrapper.storedInputLength = n * 3;
        this.theEventQueue.processEvent(mFVec3fWrapper);
    }

    public int size() {
        if (this.storedOutput) {
            return this.storedOutputValue.length / 3;
        }
        return this.theNode.getFieldValue((int)this.fieldIndex).numElements;
    }
}

