/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.scripting.external.sai;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import org.w3c.dom.Node;
import org.web3d.browser.BrowserCore;
import org.web3d.browser.BrowserCoreListener;
import org.web3d.util.DefaultErrorReporter;
import org.web3d.util.ErrorReporter;
import org.web3d.vrml.lang.BasicScene;
import org.web3d.vrml.lang.InvalidNodeTypeException;
import org.web3d.vrml.lang.ProfileInfo;
import org.web3d.vrml.lang.SceneMetaData;
import org.web3d.vrml.lang.VRMLExecutionSpace;
import org.web3d.vrml.lang.VRMLNode;
import org.web3d.vrml.lang.VRMLNodeFactory;
import org.web3d.vrml.lang.WriteableSceneMetaData;
import org.web3d.vrml.nodes.FrameStateManager;
import org.web3d.vrml.nodes.VRMLScene;
import org.web3d.vrml.nodes.VRMLWorldRootNodeType;
import org.web3d.vrml.nodes.runtime.RouteManager;
import org.web3d.vrml.scripting.browser.X3DCommonBrowser;
import org.web3d.vrml.scripting.external.buffer.ExternalEventQueue;
import org.web3d.vrml.scripting.external.sai.BufferedMappingSAIEventAdapterFactory;
import org.web3d.vrml.scripting.external.sai.NonMappingSAINodeFactory;
import org.web3d.vrml.scripting.external.sai.SAIComponentInfo;
import org.web3d.vrml.scripting.external.sai.SAINodeFactory;
import org.web3d.vrml.scripting.external.sai.SAIProfileInfo;
import org.web3d.vrml.scripting.external.sai.SAIScene;
import org.web3d.vrml.scripting.external.sai.SimpleSAIFieldFactory;
import org.web3d.vrml.scripting.sai.SAIVRMLScene;
import org.web3d.x3d.sai.BrowserEvent;
import org.web3d.x3d.sai.BrowserListener;
import org.web3d.x3d.sai.ComponentInfo;
import org.web3d.x3d.sai.ExternalBrowser;
import org.web3d.x3d.sai.InvalidDocumentException;
import org.web3d.x3d.sai.InvalidOperationTimingException;
import org.web3d.x3d.sai.InvalidURLException;
import org.web3d.x3d.sai.InvalidX3DException;
import org.web3d.x3d.sai.NotSupportedException;
import org.web3d.x3d.sai.X3DExecutionContext;
import org.web3d.x3d.sai.X3DScene;
import vrml.eai.InvalidBrowserException;

public class SAIBrowser
implements ExternalBrowser,
BrowserCoreListener {
    private static final String INVALID_BROWSER_MSG = "Cannot access the Browser object. It has been disposed of";
    private static final String NULL_CREATE_SCENE_ARGS_MSG = "Both arguments are null. 19775-2, 6.3.11 requires that one or other argument is to be non-null.";
    private static final String DEFAULT_PROFILE = "Core";
    private static final String MINIMAL_X3D_SCENE = "#X3D V3.0 utf8\nPROFILE Core\n";
    private static final String browserVersion = "1_0";
    private static final String browserName = "Xj3D SAI External Browser";
    private Vector browserListeners;
    private BrowserCore theBrowserCore;
    private X3DCommonBrowser theBrowserImpl;
    private ErrorReporter errorReporter;
    private ExternalEventQueue theEventQueue;
    private SAINodeFactory theNodeFactory;
    private VRMLNodeFactory vrmlNodeFactory;
    private RouteManager routeManager;
    private FrameStateManager stateManager;
    private VRMLExecutionSpace currentSpace;
    private X3DExecutionContext currentContext;
    private Map renderingProperties;
    private Map browserProperties;

    public SAIBrowser(BrowserCore browserCore, X3DCommonBrowser x3DCommonBrowser, RouteManager routeManager, FrameStateManager frameStateManager, ExternalEventQueue externalEventQueue, ErrorReporter errorReporter) {
        if (browserCore == null) {
            throw new IllegalArgumentException("Null BrowserCore");
        }
        if (x3DCommonBrowser == null) {
            throw new IllegalArgumentException("Null CommonBrowser");
        }
        this.errorReporter = errorReporter != null ? errorReporter : DefaultErrorReporter.getDefaultReporter();
        this.theBrowserCore = browserCore;
        this.theBrowserImpl = x3DCommonBrowser;
        this.routeManager = routeManager;
        this.stateManager = frameStateManager;
        this.theEventQueue = externalEventQueue;
        this.browserListeners = new Vector();
        browserCore.addCoreListener(this);
        HashMap hashMap = new HashMap();
        this.browserProperties = Collections.unmodifiableMap(hashMap);
        HashMap hashMap2 = new HashMap();
        this.renderingProperties = Collections.unmodifiableMap(hashMap2);
        SimpleSAIFieldFactory simpleSAIFieldFactory = new SimpleSAIFieldFactory(this.theEventQueue);
        BufferedMappingSAIEventAdapterFactory bufferedMappingSAIEventAdapterFactory = new BufferedMappingSAIEventAdapterFactory(2, browserCore.getVRMLClock());
        this.theNodeFactory = new NonMappingSAINodeFactory(simpleSAIFieldFactory, this.theEventQueue);
        bufferedMappingSAIEventAdapterFactory.setFieldFactory(simpleSAIFieldFactory);
        simpleSAIFieldFactory.setNodeFactory(this.theNodeFactory);
        simpleSAIFieldFactory.setSAIEventAdapterFactory(bufferedMappingSAIEventAdapterFactory);
    }

    public X3DScene createScene(org.web3d.x3d.sai.ProfileInfo profileInfo, ComponentInfo[] componentInfoArray) throws org.web3d.x3d.sai.InvalidBrowserException {
        VRMLNodeFactory vRMLNodeFactory;
        if (this.theBrowserImpl == null) {
            throw new org.web3d.x3d.sai.InvalidBrowserException(INVALID_BROWSER_MSG);
        }
        if (profileInfo == null && (componentInfoArray == null || componentInfoArray.length == 0)) {
            throw new IllegalArgumentException(NULL_CREATE_SCENE_ARGS_MSG);
        }
        try {
            vRMLNodeFactory = (VRMLNodeFactory)this.vrmlNodeFactory.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new org.web3d.x3d.sai.InvalidBrowserException("Error cloning node factory");
        }
        String string = profileInfo == null ? DEFAULT_PROFILE : profileInfo.getName();
        vRMLNodeFactory.setProfile(string);
        int n = componentInfoArray == null ? 0 : componentInfoArray.length;
        for (int i = 0; i < n; ++i) {
            vRMLNodeFactory.addComponent(componentInfoArray[i].getName(), componentInfoArray[i].getLevel());
        }
        VRMLWorldRootNodeType vRMLWorldRootNodeType = (VRMLWorldRootNodeType)vRMLNodeFactory.createVRMLNode("WorldRoot", false);
        vRMLWorldRootNodeType.setFrameStateManager(this.stateManager);
        vRMLWorldRootNodeType.setErrorReporter(this.errorReporter);
        vRMLWorldRootNodeType.setupFinished();
        WriteableSceneMetaData writeableSceneMetaData = new WriteableSceneMetaData("3.0", false, 0);
        SAIVRMLScene sAIVRMLScene = new SAIVRMLScene((SceneMetaData)writeableSceneMetaData);
        sAIVRMLScene.setNodeFactory(vRMLNodeFactory);
        sAIVRMLScene.setWorldRootURL(this.theBrowserImpl.getWorldURL());
        sAIVRMLScene.setRootNode((VRMLNode)vRMLWorldRootNodeType);
        vRMLWorldRootNodeType.setContainedScene((BasicScene)sAIVRMLScene);
        SAIScene sAIScene = new SAIScene((VRMLScene)sAIVRMLScene, this.routeManager, this.stateManager, this.theNodeFactory, this.theEventQueue, vRMLWorldRootNodeType, this.errorReporter);
        this.theBrowserImpl.replaceWorld((VRMLScene)sAIVRMLScene);
        return sAIScene;
    }

    public X3DScene createX3DFromString(String string) throws org.web3d.x3d.sai.InvalidBrowserException, InvalidX3DException {
        VRMLScene vRMLScene;
        if (this.theBrowserImpl == null) {
            throw new org.web3d.x3d.sai.InvalidBrowserException(INVALID_BROWSER_MSG);
        }
        try {
            vRMLScene = this.theBrowserImpl.createX3DFromString(string);
        }
        catch (IOException iOException) {
            throw new InvalidX3DException(iOException.getMessage());
        }
        catch (InvalidNodeTypeException invalidNodeTypeException) {
            throw new InvalidX3DException(invalidNodeTypeException.getMessage());
        }
        VRMLExecutionSpace vRMLExecutionSpace = (VRMLExecutionSpace)((Object)vRMLScene.getRootNode());
        return new SAIScene(vRMLScene, this.routeManager, this.stateManager, this.theNodeFactory, this.theEventQueue, vRMLExecutionSpace, this.errorReporter);
    }

    public X3DScene createX3DFromStream(InputStream inputStream) throws org.web3d.x3d.sai.InvalidBrowserException, InvalidX3DException, IOException {
        if (this.theBrowserImpl == null) {
            throw new org.web3d.x3d.sai.InvalidBrowserException(INVALID_BROWSER_MSG);
        }
        VRMLScene vRMLScene = this.theBrowserImpl.createX3DFromStream(inputStream);
        VRMLExecutionSpace vRMLExecutionSpace = (VRMLExecutionSpace)((Object)vRMLScene.getRootNode());
        SAIScene sAIScene = new SAIScene(vRMLScene, this.routeManager, this.stateManager, this.theNodeFactory, this.theEventQueue, vRMLExecutionSpace, this.errorReporter);
        return sAIScene;
    }

    public X3DScene createX3DFromURL(String[] stringArray) throws org.web3d.x3d.sai.InvalidBrowserException, InvalidURLException, InvalidX3DException {
        if (this.theBrowserImpl == null) {
            throw new org.web3d.x3d.sai.InvalidBrowserException(INVALID_BROWSER_MSG);
        }
        VRMLScene vRMLScene = this.theBrowserImpl.createX3DFromURL(stringArray);
        VRMLExecutionSpace vRMLExecutionSpace = (VRMLExecutionSpace)((Object)vRMLScene.getRootNode());
        SAIScene sAIScene = new SAIScene(vRMLScene, this.routeManager, this.stateManager, this.theNodeFactory, this.theEventQueue, vRMLExecutionSpace, this.errorReporter);
        return sAIScene;
    }

    public ComponentInfo getComponent(String string, int n) throws org.web3d.x3d.sai.InvalidBrowserException, NotSupportedException {
        if (this.theBrowserImpl == null) {
            throw new org.web3d.x3d.sai.InvalidBrowserException(INVALID_BROWSER_MSG);
        }
        ComponentInfo[] componentInfoArray = this.getSupportedComponents();
        for (int i = 0; i < componentInfoArray.length; ++i) {
            if (!componentInfoArray[i].getName().equals(string)) continue;
            if (componentInfoArray[i].getLevel() >= n) {
                return new SAIComponentInfo(componentInfoArray[i].getName(), componentInfoArray[i].getLevel(), componentInfoArray[i].getTitle(), componentInfoArray[i].getProviderURL());
            }
            throw new NotSupportedException();
        }
        throw new NotSupportedException();
    }

    public float getCurrentSpeed() throws org.web3d.x3d.sai.InvalidBrowserException {
        if (this.theBrowserImpl == null) {
            throw new org.web3d.x3d.sai.InvalidBrowserException(INVALID_BROWSER_MSG);
        }
        return this.theBrowserImpl.getCurrentSpeed();
    }

    public float getCurrentFrameRate() throws org.web3d.x3d.sai.InvalidBrowserException {
        if (this.theBrowserImpl == null) {
            throw new org.web3d.x3d.sai.InvalidBrowserException(INVALID_BROWSER_MSG);
        }
        return this.theBrowserImpl.getCurrentFrameRate();
    }

    public X3DExecutionContext getExecutionContext() throws org.web3d.x3d.sai.InvalidBrowserException {
        if (this.theBrowserImpl == null) {
            throw new org.web3d.x3d.sai.InvalidBrowserException(INVALID_BROWSER_MSG);
        }
        VRMLExecutionSpace vRMLExecutionSpace = this.theBrowserCore.getWorldExecutionSpace();
        if (vRMLExecutionSpace != this.currentSpace) {
            SAIScene sAIScene = new SAIScene((VRMLScene)vRMLExecutionSpace.getContainedScene(), this.routeManager, this.stateManager, this.theNodeFactory, this.theEventQueue, this.theBrowserCore.getWorldExecutionSpace(), this.errorReporter);
            this.currentContext = sAIScene;
        }
        return this.currentContext;
    }

    public String getName() throws org.web3d.x3d.sai.InvalidBrowserException {
        if (this.theBrowserImpl == null) {
            throw new org.web3d.x3d.sai.InvalidBrowserException(INVALID_BROWSER_MSG);
        }
        return browserName;
    }

    public org.web3d.x3d.sai.ProfileInfo getProfile(String string) {
        if (this.theBrowserImpl == null) {
            throw new org.web3d.x3d.sai.InvalidBrowserException(INVALID_BROWSER_MSG);
        }
        org.web3d.x3d.sai.ProfileInfo[] profileInfoArray = this.getSupportedProfiles();
        for (int i = 0; i < profileInfoArray.length; ++i) {
            if (!profileInfoArray[i].getName().equals(string)) continue;
            return profileInfoArray[i];
        }
        throw new NotSupportedException();
    }

    public ComponentInfo[] getSupportedComponents() {
        if (this.theBrowserImpl == null) {
            throw new org.web3d.x3d.sai.InvalidBrowserException(INVALID_BROWSER_MSG);
        }
        org.web3d.vrml.lang.ComponentInfo[] componentInfoArray = this.getVRMLNodeFactory().getAvailableComponents();
        ComponentInfo[] componentInfoArray2 = new ComponentInfo[componentInfoArray.length];
        if (componentInfoArray2 == null) {
            return new ComponentInfo[0];
        }
        for (int i = 0; i < componentInfoArray2.length; ++i) {
            componentInfoArray2[i] = new SAIComponentInfo(componentInfoArray[i]);
        }
        return componentInfoArray2;
    }

    public org.web3d.x3d.sai.ProfileInfo[] getSupportedProfiles() {
        if (this.theBrowserImpl == null) {
            throw new org.web3d.x3d.sai.InvalidBrowserException(INVALID_BROWSER_MSG);
        }
        ProfileInfo[] profileInfoArray = this.getVRMLNodeFactory().getAvailableProfiles();
        if (profileInfoArray == null) {
            throw new RuntimeException("Null array from getAvailableProfiles");
        }
        org.web3d.x3d.sai.ProfileInfo[] profileInfoArray2 = new org.web3d.x3d.sai.ProfileInfo[profileInfoArray.length];
        for (int i = 0; i < profileInfoArray.length; ++i) {
            profileInfoArray2[i] = new SAIProfileInfo(profileInfoArray[i]);
        }
        return profileInfoArray2;
    }

    public String getVersion() throws org.web3d.x3d.sai.InvalidBrowserException {
        if (this.theBrowserImpl == null) {
            throw new org.web3d.x3d.sai.InvalidBrowserException(INVALID_BROWSER_MSG);
        }
        return browserVersion;
    }

    public X3DScene importDocument(Node node) {
        if (this.theBrowserImpl == null) {
            throw new org.web3d.x3d.sai.InvalidBrowserException(INVALID_BROWSER_MSG);
        }
        try {
            VRMLScene vRMLScene = this.theBrowserImpl.importDocument(node);
            VRMLExecutionSpace vRMLExecutionSpace = (VRMLExecutionSpace)((Object)vRMLScene.getRootNode());
            return new SAIScene(vRMLScene, this.routeManager, this.stateManager, this.theNodeFactory, this.theEventQueue, vRMLExecutionSpace, this.errorReporter);
        }
        catch (Exception exception) {
            throw new InvalidDocumentException("Unable to process document.  Reason:  " + exception.getMessage());
        }
    }

    public void loadURL(String[] stringArray, Map map) throws org.web3d.x3d.sai.InvalidBrowserException, InvalidURLException {
        if (this.theBrowserImpl == null) {
            throw new org.web3d.x3d.sai.InvalidBrowserException(INVALID_BROWSER_MSG);
        }
        this.theBrowserImpl.loadURL(stringArray, map);
    }

    public void replaceWorld(X3DScene x3DScene) throws IllegalArgumentException, org.web3d.x3d.sai.InvalidBrowserException {
        if (this.theBrowserImpl == null) {
            throw new org.web3d.x3d.sai.InvalidBrowserException(INVALID_BROWSER_MSG);
        }
        if (!(x3DScene instanceof SAIScene)) {
            throw new IllegalArgumentException("Incorrect scene type.");
        }
        this.theBrowserImpl.replaceWorld(((SAIScene)x3DScene).getRealScene());
    }

    public String getDescription() throws org.web3d.x3d.sai.InvalidBrowserException {
        if (this.theBrowserImpl == null) {
            throw new org.web3d.x3d.sai.InvalidBrowserException(INVALID_BROWSER_MSG);
        }
        return this.theBrowserImpl.getDescription();
    }

    public void setDescription(String string) throws org.web3d.x3d.sai.InvalidBrowserException {
        if (this.theBrowserImpl == null) {
            throw new org.web3d.x3d.sai.InvalidBrowserException(INVALID_BROWSER_MSG);
        }
        this.theBrowserImpl.setDescription(string);
    }

    public Map getRenderingProperties() throws org.web3d.x3d.sai.InvalidBrowserException, InvalidOperationTimingException {
        if (this.theBrowserImpl == null) {
            throw new org.web3d.x3d.sai.InvalidBrowserException(INVALID_BROWSER_MSG);
        }
        return this.renderingProperties;
    }

    public Map getBrowserProperties() throws org.web3d.x3d.sai.InvalidBrowserException, InvalidOperationTimingException {
        if (this.theBrowserImpl == null) {
            throw new org.web3d.x3d.sai.InvalidBrowserException(INVALID_BROWSER_MSG);
        }
        return this.browserProperties;
    }

    public void nextViewpoint() throws org.web3d.x3d.sai.InvalidBrowserException {
        if (this.theBrowserImpl == null) {
            throw new org.web3d.x3d.sai.InvalidBrowserException(INVALID_BROWSER_MSG);
        }
        this.theBrowserImpl.nextViewpoint();
    }

    public void previousViewpoint() throws org.web3d.x3d.sai.InvalidBrowserException {
        if (this.theBrowserImpl == null) {
            throw new org.web3d.x3d.sai.InvalidBrowserException(INVALID_BROWSER_MSG);
        }
        this.theBrowserImpl.previousViewpoint();
    }

    public void firstViewpoint() throws org.web3d.x3d.sai.InvalidBrowserException {
        if (this.theBrowserImpl == null) {
            throw new org.web3d.x3d.sai.InvalidBrowserException(INVALID_BROWSER_MSG);
        }
        this.theBrowserImpl.firstViewpoint();
    }

    public void lastViewpoint() throws org.web3d.x3d.sai.InvalidBrowserException {
        if (this.theBrowserImpl == null) {
            throw new org.web3d.x3d.sai.InvalidBrowserException(INVALID_BROWSER_MSG);
        }
        this.theBrowserImpl.lastViewpoint();
    }

    public void addBrowserListener(BrowserListener browserListener) throws org.web3d.x3d.sai.InvalidBrowserException {
        if (this.theBrowserImpl == null) {
            throw new org.web3d.x3d.sai.InvalidBrowserException(INVALID_BROWSER_MSG);
        }
        if (browserListener != null && !this.browserListeners.contains(browserListener)) {
            this.browserListeners.addElement(browserListener);
        }
    }

    public void beginUpdate() throws InvalidBrowserException {
        if (this.theBrowserImpl == null) {
            throw new org.web3d.x3d.sai.InvalidBrowserException(INVALID_BROWSER_MSG);
        }
        this.theEventQueue.beginUpdate();
    }

    public void endUpdate() throws InvalidBrowserException {
        if (this.theBrowserImpl == null) {
            throw new org.web3d.x3d.sai.InvalidBrowserException(INVALID_BROWSER_MSG);
        }
        this.theEventQueue.endUpdate();
    }

    public void pauseRender() {
        if (this.theBrowserImpl == null) {
            throw new org.web3d.x3d.sai.InvalidBrowserException(INVALID_BROWSER_MSG);
        }
        throw new RuntimeException("Not yet implemented");
    }

    public void removeBrowserListener(BrowserListener browserListener) throws org.web3d.x3d.sai.InvalidBrowserException {
        if (this.theBrowserImpl == null) {
            throw new org.web3d.x3d.sai.InvalidBrowserException(INVALID_BROWSER_MSG);
        }
        this.browserListeners.removeElement(browserListener);
    }

    public void startRender() {
        if (this.theBrowserImpl == null) {
            throw new org.web3d.x3d.sai.InvalidBrowserException(INVALID_BROWSER_MSG);
        }
        throw new RuntimeException("Not yet implemented");
    }

    public void stopRender() {
        if (this.theBrowserImpl == null) {
            throw new org.web3d.x3d.sai.InvalidBrowserException(INVALID_BROWSER_MSG);
        }
        throw new RuntimeException("Not yet implemented");
    }

    public void print(Object object) throws org.web3d.x3d.sai.InvalidBrowserException {
        if (this.theBrowserImpl == null) {
            throw new org.web3d.x3d.sai.InvalidBrowserException(INVALID_BROWSER_MSG);
        }
        if (object != null) {
            this.errorReporter.partialReport(object.toString());
        }
    }

    public void println(Object object) throws org.web3d.x3d.sai.InvalidBrowserException {
        if (this.theBrowserImpl == null) {
            throw new org.web3d.x3d.sai.InvalidBrowserException(INVALID_BROWSER_MSG);
        }
        if (object != null) {
            this.errorReporter.messageReport(object.toString());
        }
    }

    public void browserInitialized(VRMLScene vRMLScene) {
        this.broadcastEvent(new BrowserEvent((Object)this, 0));
    }

    public void urlLoadFailed(String string) {
        this.broadcastEvent(new BrowserEvent((Object)this, 2));
    }

    public void browserShutdown() {
        this.broadcastEvent(new BrowserEvent((Object)this, 1));
    }

    public void browserDisposed() {
    }

    public void initializeWorld() {
    }

    void broadcastEvent(BrowserEvent browserEvent) {
        Enumeration enumeration = this.browserListeners.elements();
        while (enumeration.hasMoreElements()) {
            BrowserListener browserListener = (BrowserListener)enumeration.nextElement();
            new Thread(new EventNotifier(browserListener, browserEvent)).start();
        }
    }

    public void dispose() {
        if (this.theBrowserImpl == null) {
            throw new org.web3d.x3d.sai.InvalidBrowserException(INVALID_BROWSER_MSG);
        }
        this.endUpdate();
        this.theBrowserImpl = null;
        this.do_shutdown();
        this.theBrowserCore.dispose();
        this.theBrowserCore = null;
    }

    void do_shutdown() {
        this.broadcastEvent(new BrowserEvent((Object)this, 1));
    }

    VRMLNodeFactory getVRMLNodeFactory() {
        if (this.vrmlNodeFactory == null) {
            X3DExecutionContext x3DExecutionContext = this.getExecutionContext();
            if (x3DExecutionContext == null) {
                SAIScene sAIScene = (SAIScene)this.createX3DFromString(MINIMAL_X3D_SCENE);
                this.vrmlNodeFactory = sAIScene.getVRMLNodeFactory();
            } else {
                this.vrmlNodeFactory = ((SAIScene)x3DExecutionContext).getVRMLNodeFactory();
            }
        }
        return this.vrmlNodeFactory;
    }

    private class EventNotifier
    implements Runnable {
        private BrowserListener theListener;
        private BrowserEvent theEvent;

        EventNotifier(BrowserListener browserListener, BrowserEvent browserEvent) {
            this.theListener = browserListener;
            this.theEvent = browserEvent;
        }

        public void run() {
            this.theListener.browserChanged(this.theEvent);
        }
    }
}

