/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.scripting.external.sai;

import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import org.web3d.util.ErrorReporter;
import org.web3d.vrml.lang.ROUTE;
import org.web3d.vrml.lang.VRMLExecutionSpace;
import org.web3d.vrml.lang.VRMLNodeFactory;
import org.web3d.vrml.nodes.FrameStateManager;
import org.web3d.vrml.nodes.VRMLExternalNodeType;
import org.web3d.vrml.nodes.VRMLInlineNodeType;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.nodes.VRMLProtoDeclare;
import org.web3d.vrml.nodes.VRMLProtoInstance;
import org.web3d.vrml.nodes.VRMLScene;
import org.web3d.vrml.nodes.VRMLWorldRootNodeType;
import org.web3d.vrml.nodes.runtime.RouteManager;
import org.web3d.vrml.scripting.external.buffer.ExternalEventQueue;
import org.web3d.vrml.scripting.external.sai.AddRootNodeEvent;
import org.web3d.vrml.scripting.external.sai.AddRouteEvent;
import org.web3d.vrml.scripting.external.sai.RemoveRootNodeEvent;
import org.web3d.vrml.scripting.external.sai.RemoveRouteEvent;
import org.web3d.vrml.scripting.external.sai.SAIComponentInfo;
import org.web3d.vrml.scripting.external.sai.SAINode;
import org.web3d.vrml.scripting.external.sai.SAINodeFactory;
import org.web3d.vrml.scripting.external.sai.SAIProfileInfo;
import org.web3d.vrml.scripting.external.sai.SAIProtoDeclaration;
import org.web3d.vrml.scripting.external.sai.SAIRoute;
import org.web3d.x3d.sai.ComponentInfo;
import org.web3d.x3d.sai.InvalidBrowserException;
import org.web3d.x3d.sai.InvalidNodeException;
import org.web3d.x3d.sai.InvalidReadableFieldException;
import org.web3d.x3d.sai.InvalidWritableFieldException;
import org.web3d.x3d.sai.ProfileInfo;
import org.web3d.x3d.sai.X3DExternProtoDeclaration;
import org.web3d.x3d.sai.X3DNode;
import org.web3d.x3d.sai.X3DProtoDeclaration;
import org.web3d.x3d.sai.X3DProtoInstance;
import org.web3d.x3d.sai.X3DRoute;
import org.web3d.x3d.sai.X3DScene;

class SAIScene
implements X3DScene {
    static final String[] EMPTY_STRING_ARRAY = new String[0];
    protected ExternalEventQueue eventQueue;
    protected VRMLExecutionSpace executionSpace;
    protected VRMLScene theScene;
    protected SAINodeFactory nodeFactory;
    private ErrorReporter errorReporter;
    protected RouteManager routeManager;
    protected FrameStateManager stateManager;

    SAIScene(VRMLScene vRMLScene, RouteManager routeManager, FrameStateManager frameStateManager, SAINodeFactory sAINodeFactory, ExternalEventQueue externalEventQueue, VRMLExecutionSpace vRMLExecutionSpace, ErrorReporter errorReporter) {
        if (vRMLExecutionSpace == null) {
            throw new IllegalArgumentException("Execution space must be valid.");
        }
        this.routeManager = routeManager;
        this.stateManager = frameStateManager;
        this.theScene = vRMLScene;
        this.nodeFactory = sAINodeFactory;
        this.eventQueue = externalEventQueue;
        this.executionSpace = vRMLExecutionSpace;
        this.errorReporter = errorReporter;
    }

    VRMLScene getRealScene() {
        return this.theScene;
    }

    public void addMetaData(String string, String string2) {
        this.getMetaData().put(string, string2);
    }

    public Map getMetaData() {
        return this.theScene.getMetaData().getMetaData();
    }

    public void removeMetaData(String string) {
        this.getMetaData().remove(string);
    }

    public X3DNode getExportedNode(String string) {
        VRMLNodeType vRMLNodeType = (VRMLNodeType)this.theScene.getExports().get(string);
        if (vRMLNodeType == null) {
            throw new InvalidNodeException(string);
        }
        return this.nodeFactory.getSAINode(vRMLNodeType);
    }

    public String[] getExportedNodes() {
        return this.theScene.getExports().keySet().toArray(EMPTY_STRING_ARRAY);
    }

    public void updateExportedNode(String string, String string2) {
        throw new RuntimeException("Not yet implemented");
    }

    public void removeExportedNode(String string) {
        this.theScene.getExports().remove(string);
    }

    public void addRootNode(X3DNode x3DNode) {
        if (!(x3DNode instanceof SAINode)) {
            throw new IllegalArgumentException("Expected external SAI wrapper node");
        }
        SAINode sAINode = (SAINode)x3DNode;
        VRMLWorldRootNodeType vRMLWorldRootNodeType = (VRMLWorldRootNodeType)this.theScene.getRootNode();
        VRMLNodeType vRMLNodeType = this.nodeFactory.getVRMLNode(sAINode);
        if (vRMLNodeType != null) {
            this.eventQueue.postRealizeNode(vRMLNodeType);
        }
        this.eventQueue.processEvent(new AddRootNodeEvent(vRMLWorldRootNodeType, vRMLNodeType));
    }

    public void removeRootNode(X3DNode x3DNode) {
        if (!(x3DNode instanceof SAINode)) {
            throw new IllegalArgumentException("Expected external SAI wrapper node");
        }
        SAINode sAINode = (SAINode)x3DNode;
        VRMLWorldRootNodeType vRMLWorldRootNodeType = (VRMLWorldRootNodeType)this.theScene.getRootNode();
        this.eventQueue.processEvent(new RemoveRootNodeEvent(vRMLWorldRootNodeType, this.nodeFactory.getVRMLNode(sAINode)));
    }

    public String getSpecificationVersion() {
        return this.theScene.getMetaData().getVersion();
    }

    public int getEncoding() {
        return this.theScene.getMetaData().getEncoding();
    }

    public ProfileInfo getProfile() {
        String string = this.theScene.getMetaData().getProfileName();
        org.web3d.vrml.lang.ProfileInfo[] profileInfoArray = this.theScene.getNodeFactory().getAvailableProfiles();
        for (int i = 0; i < profileInfoArray.length; ++i) {
            if (!profileInfoArray[i].getName().equals(string)) continue;
            return new SAIProfileInfo(profileInfoArray[i]);
        }
        throw new RuntimeException("Current profile is " + string + " but not found in existing profiles");
    }

    public ComponentInfo[] getComponents() {
        org.web3d.vrml.lang.ComponentInfo[] componentInfoArray = this.theScene.getMetaData().getComponents();
        ComponentInfo[] componentInfoArray2 = new ComponentInfo[componentInfoArray.length];
        for (int i = 0; i < componentInfoArray2.length; ++i) {
            componentInfoArray2[i] = new SAIComponentInfo(componentInfoArray[i]);
        }
        return componentInfoArray2;
    }

    public X3DNode getImportedNode(String string) {
        VRMLNodeType vRMLNodeType = (VRMLNodeType)this.theScene.getImports().get(string);
        if (vRMLNodeType == null) {
            throw new InvalidNodeException(string);
        }
        return this.nodeFactory.getSAINode(vRMLNodeType);
    }

    public void removeImportedNode(String string) {
        this.theScene.getImports().remove(string);
    }

    public void updateImportedNode(String string, String string2, X3DNode x3DNode) {
        VRMLNodeType vRMLNodeType;
        VRMLNodeType vRMLNodeType2 = this.nodeFactory.getVRMLNode(x3DNode);
        while (vRMLNodeType2 instanceof VRMLProtoInstance) {
            vRMLNodeType2 = ((VRMLProtoInstance)vRMLNodeType2).getImplementationNode();
        }
        if (vRMLNodeType2 instanceof VRMLInlineNodeType) {
            VRMLInlineNodeType vRMLInlineNodeType = (VRMLInlineNodeType)vRMLNodeType2;
            VRMLScene vRMLScene = (VRMLScene)vRMLInlineNodeType.getContainedScene();
            vRMLNodeType = (VRMLNodeType)((Object)vRMLScene.getExports());
            if (vRMLNodeType == null) {
                throw new InvalidNodeException(string + " not found in target scene.");
            }
        } else {
            throw new IllegalArgumentException("Designated node is not an Inline node");
        }
        this.theScene.getImports().put(string2, vRMLNodeType);
    }

    public String getWorldURL() throws InvalidBrowserException {
        return this.theScene.getWorldRootURL();
    }

    public X3DRoute[] getRoutes() {
        ArrayList arrayList = this.theScene.getRoutes();
        X3DRoute[] x3DRouteArray = new X3DRoute[arrayList.size()];
        for (int i = 0; i < x3DRouteArray.length; ++i) {
            System.out.println(arrayList.get(i).getClass().getName());
            ROUTE rOUTE = (ROUTE)arrayList.get(i);
            x3DRouteArray[i] = new SAIRoute(this.nodeFactory.getSAINode((VRMLNodeType)rOUTE.getSourceNode()), rOUTE.getSourceNode().getFieldDeclaration(rOUTE.getSourceIndex()).getName(), this.nodeFactory.getSAINode((VRMLNodeType)rOUTE.getDestinationNode()), rOUTE.getDestinationNode().getFieldDeclaration(rOUTE.getDestinationIndex()).getName());
        }
        return x3DRouteArray;
    }

    public X3DRoute addRoute(X3DNode x3DNode, String string, X3DNode x3DNode2, String string2) throws InvalidBrowserException, InvalidReadableFieldException, InvalidWritableFieldException, InvalidNodeException {
        VRMLNodeType vRMLNodeType = this.nodeFactory.getVRMLNode(x3DNode);
        VRMLNodeType vRMLNodeType2 = this.nodeFactory.getVRMLNode(x3DNode2);
        int n = vRMLNodeType.getFieldIndex(string);
        int n2 = vRMLNodeType2.getFieldIndex(string2);
        this.eventQueue.processEvent(new AddRouteEvent(this.routeManager, this.executionSpace, vRMLNodeType, n, vRMLNodeType2, n2));
        SAIRoute sAIRoute = new SAIRoute(x3DNode, string, x3DNode2, string2);
        return sAIRoute;
    }

    public void removeRoute(X3DRoute x3DRoute) throws InvalidBrowserException {
        VRMLNodeType vRMLNodeType = this.nodeFactory.getVRMLNode(x3DRoute.getSourceNode());
        VRMLNodeType vRMLNodeType2 = this.nodeFactory.getVRMLNode(x3DRoute.getDestinationNode());
        int n = vRMLNodeType.getFieldIndex(x3DRoute.getSourceField());
        int n2 = vRMLNodeType2.getFieldIndex(x3DRoute.getDestinationField());
        this.eventQueue.processEvent(new RemoveRouteEvent(this.routeManager, this.executionSpace, vRMLNodeType, n, vRMLNodeType2, n2));
    }

    public String[] getProtosNames() {
        return this.theScene.getProtos().keySet().toArray(EMPTY_STRING_ARRAY);
    }

    public X3DProtoDeclaration getProtoDeclaration(String string) {
        Map map = this.theScene.getProtos();
        VRMLProtoDeclare vRMLProtoDeclare = (VRMLProtoDeclare)map.get(string);
        if (vRMLProtoDeclare == null) {
            return null;
        }
        return new SAIProtoDeclaration(this.nodeFactory, vRMLProtoDeclare, this.theScene);
    }

    public void updateProtoDeclaration(String string, X3DProtoDeclaration x3DProtoDeclaration) {
        if (!(x3DProtoDeclaration instanceof SAIProtoDeclaration)) {
            throw new RuntimeException("PROTO declaration not compatible");
        }
        SAIProtoDeclaration sAIProtoDeclaration = (SAIProtoDeclaration)x3DProtoDeclaration;
        this.theScene.getProtos().put(string, sAIProtoDeclaration.getRealProtoDeclaration());
    }

    public void removeProtoDeclaration(String string) {
        this.theScene.getProtos().remove(string);
    }

    public String[] getExternProtoNames() {
        return this.theScene.getExternProtos().keySet().toArray(EMPTY_STRING_ARRAY);
    }

    public X3DExternProtoDeclaration getExternProtoDeclaration(String string) {
        Object v = this.theScene.getExternProtos().get(string);
        throw new RuntimeException("Not yet implemented");
    }

    public void updateExternProtoDeclaration(String string, X3DExternProtoDeclaration x3DExternProtoDeclaration) {
        throw new RuntimeException("Not yet implemented");
    }

    public void removeExternProtoDeclaration(String string) {
        this.theScene.getExternProtos().remove(string);
    }

    public String[] getNamedNodes() {
        Set set = this.theScene.getDEFNodes().keySet();
        String[] stringArray = new String[set.size()];
        return set.toArray(stringArray);
    }

    public X3DNode getNamedNode(String string) {
        VRMLNodeType vRMLNodeType = (VRMLNodeType)this.theScene.getDEFNodes().get(string);
        if (vRMLNodeType == null) {
            throw new InvalidNodeException(string);
        }
        return this.nodeFactory.getSAINode(vRMLNodeType);
    }

    public void removeNamedNode(String string) {
        this.theScene.getDEFNodes().remove(string);
    }

    public void updateNamedNode(String string, X3DNode x3DNode) {
        VRMLNodeType vRMLNodeType = this.nodeFactory.getVRMLNode(x3DNode);
        this.theScene.getDEFNodes().put(string, vRMLNodeType);
    }

    public X3DNode[] getRootNodes() {
        VRMLWorldRootNodeType vRMLWorldRootNodeType = (VRMLWorldRootNodeType)this.theScene.getRootNode();
        VRMLNodeType[] vRMLNodeTypeArray = vRMLWorldRootNodeType.getChildren();
        X3DNode[] x3DNodeArray = new X3DNode[vRMLNodeTypeArray.length];
        for (int i = 0; i < x3DNodeArray.length; ++i) {
            x3DNodeArray[i] = this.nodeFactory.getSAINode(vRMLNodeTypeArray[i]);
        }
        return x3DNodeArray;
    }

    public X3DNode createNode(String string) {
        VRMLNodeType vRMLNodeType = (VRMLNodeType)this.theScene.getNodeFactory().createVRMLNode(string, false);
        vRMLNodeType.setErrorReporter(this.errorReporter);
        if (vRMLNodeType instanceof VRMLExternalNodeType) {
            ((VRMLExternalNodeType)((Object)vRMLNodeType)).setWorldUrl(this.theScene.getWorldRootURL());
        }
        vRMLNodeType.setFrameStateManager(this.stateManager);
        return this.nodeFactory.getSAINode(vRMLNodeType);
    }

    public X3DProtoInstance createProto(String string) {
        X3DProtoDeclaration x3DProtoDeclaration = this.getProtoDeclaration(string);
        if (x3DProtoDeclaration == null) {
            throw new InvalidNodeException("No proto with name " + string + " exists.");
        }
        return x3DProtoDeclaration.createInstance();
    }

    VRMLNodeFactory getVRMLNodeFactory() {
        return this.theScene.getNodeFactory();
    }
}

