/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.scripting.external.sai;

import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferInt;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.awt.image.WritableRenderedImage;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.scripting.external.buffer.ExternalEvent;
import org.web3d.vrml.scripting.external.buffer.ExternalEventQueue;
import org.web3d.vrml.scripting.external.buffer.ExternalOutputBuffer;
import org.web3d.vrml.scripting.external.sai.BaseFieldWrapper;
import org.web3d.vrml.scripting.external.sai.SAIEventAdapterFactory;
import org.web3d.x3d.sai.InvalidFieldException;
import org.web3d.x3d.sai.InvalidFieldValueException;
import org.web3d.x3d.sai.InvalidOperationTimingException;
import org.web3d.x3d.sai.InvalidWritableFieldException;
import org.web3d.x3d.sai.SFImage;

class SFImageWrapper
extends BaseFieldWrapper
implements SFImage,
ExternalEvent,
ExternalOutputBuffer {
    boolean isSetOneValue;
    int[] storedInputValue;
    int[] storedOutputValue;

    SFImageWrapper(VRMLNodeType vRMLNodeType, int n, ExternalEventQueue externalEventQueue, SAIEventAdapterFactory sAIEventAdapterFactory) {
        super(vRMLNodeType, n, externalEventQueue, sAIEventAdapterFactory);
    }

    SFImageWrapper(VRMLNodeType vRMLNodeType, int n, ExternalEventQueue externalEventQueue, SAIEventAdapterFactory sAIEventAdapterFactory, boolean bl) {
        this(vRMLNodeType, n, externalEventQueue, sAIEventAdapterFactory);
        if (bl) {
            this.loadInputValue();
        } else {
            this.loadOutputValue();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doEvent() {
        try {
            this.theNode.setValue(this.fieldIndex, this.storedInputValue, this.storedInputValue.length);
        }
        finally {
            this.storedInput = false;
            this.isSetOneValue = false;
        }
    }

    public int getComponents() {
        if (this.storedOutput) {
            return this.storedOutputValue[2];
        }
        this.checkReadAccess();
        VRMLFieldData vRMLFieldData = this.theNode.getFieldValue(this.fieldIndex);
        if (vRMLFieldData.intArrayValue != null) {
            return vRMLFieldData.intArrayValue[2];
        }
        return 0;
    }

    public int getHeight() {
        if (this.storedOutput) {
            return this.storedOutputValue[1];
        }
        this.checkReadAccess();
        VRMLFieldData vRMLFieldData = this.theNode.getFieldValue(this.fieldIndex);
        if (vRMLFieldData.intArrayValue != null) {
            return vRMLFieldData.intArrayValue[1];
        }
        return 0;
    }

    public WritableRenderedImage getImage() {
        int[] nArray;
        int n;
        this.checkReadAccess();
        int n2 = this.getWidth();
        int n3 = this.getHeight();
        int[] nArray2 = new int[n2 * n3];
        this.getPixels(nArray2);
        int n4 = this.getComponents();
        switch (n4) {
            case 1: {
                n = 10;
                nArray = new int[]{255};
                break;
            }
            case 2: {
                n = 10;
                nArray = new int[]{65280, 255};
                boolean bl = true;
                break;
            }
            case 3: {
                n = 1;
                nArray = new int[]{0xFF0000, 65280, 255};
                break;
            }
            case 4: {
                n = 2;
                nArray = new int[]{-16777216, 0xFF0000, 65280, 255};
                boolean bl = true;
                break;
            }
            default: {
                throw new RuntimeException("SFImage Unsupported #components: " + n4);
            }
        }
        DataBufferInt dataBufferInt = new DataBufferInt(nArray2, nArray2.length, 0);
        WritableRaster writableRaster = Raster.createPackedRaster(dataBufferInt, n2, n3, n2, nArray, null);
        BufferedImage bufferedImage = new BufferedImage(n2, n3, n);
        bufferedImage.setData(writableRaster);
        return bufferedImage;
    }

    public void getPixels(int[] nArray) {
        if (this.storedOutput) {
            int n = this.storedOutputValue[0] * this.storedOutputValue[1];
            if (n > 0) {
                System.arraycopy(this.storedOutputValue, 3, nArray, 0, n);
            }
        } else {
            int n;
            this.checkReadAccess();
            VRMLFieldData vRMLFieldData = this.theNode.getFieldValue(this.fieldIndex);
            if (vRMLFieldData.intArrayValue != null && (n = vRMLFieldData.intArrayValue[0] * vRMLFieldData.intArrayValue[1]) > 0) {
                System.arraycopy(vRMLFieldData.intArrayValue, 3, nArray, 0, n);
            }
        }
    }

    public int getWidth() {
        if (this.storedOutput) {
            return this.storedOutputValue[0];
        }
        this.checkReadAccess();
        VRMLFieldData vRMLFieldData = this.theNode.getFieldValue(this.fieldIndex);
        if (vRMLFieldData.intArrayValue != null) {
            return vRMLFieldData.intArrayValue[0];
        }
        return 0;
    }

    public void initialize(VRMLNodeType vRMLNodeType, int n) {
        this.theNode = vRMLNodeType;
        this.fieldIndex = n;
    }

    public boolean isConglomerating() {
        return false;
    }

    private void loadInputValue() {
        VRMLFieldData vRMLFieldData = this.theNode.getFieldValue(this.fieldIndex);
        if (this.storedInputValue == null || this.storedInputValue.length < vRMLFieldData.numElements) {
            this.storedInputValue = new int[vRMLFieldData.numElements];
        }
        System.arraycopy(vRMLFieldData.intArrayValue, 0, this.storedInputValue, 0, vRMLFieldData.numElements);
        this.storedInput = true;
    }

    public void loadOutputValue() {
        VRMLFieldData vRMLFieldData = this.theNode.getFieldValue(this.fieldIndex);
        int n = vRMLFieldData.intArrayValue[0];
        int n2 = vRMLFieldData.intArrayValue[1];
        if (this.storedOutputValue == null || this.storedOutputValue.length < vRMLFieldData.numElements) {
            this.storedOutputValue = new int[vRMLFieldData.numElements];
        }
        System.arraycopy(vRMLFieldData.intArrayValue, 0, this.storedOutputValue, 0, vRMLFieldData.numElements);
        this.storedOutput = true;
    }

    public void reset() {
        this.theNode = null;
        this.fieldIndex = -1;
        this.storedOutput = false;
    }

    public void setImage(RenderedImage renderedImage) throws InvalidOperationTimingException, InvalidFieldValueException, InvalidWritableFieldException, InvalidFieldException {
        this.checkWriteAccess();
        int n = renderedImage.getHeight() * renderedImage.getWidth() + 3;
        SFImageWrapper sFImageWrapper = this;
        if (sFImageWrapper.storedInput) {
            sFImageWrapper = new SFImageWrapper(this.theNode, this.fieldIndex, this.theEventQueue, this.theEventAdapterFactory);
        }
        if (sFImageWrapper.storedInputValue == null || sFImageWrapper.storedInputValue.length != n) {
            sFImageWrapper.storedInputValue = new int[n];
        }
        SFImageWrapper.convertRenderedImageToData(renderedImage, sFImageWrapper.storedInputValue, 0);
        sFImageWrapper.storedInput = true;
        this.theEventQueue.processEvent(sFImageWrapper);
        System.out.println("Done");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSubImage(RenderedImage renderedImage, int n, int n2, int n3, int n4, int n5, int n6) throws InvalidOperationTimingException, InvalidFieldValueException, InvalidWritableFieldException, InvalidFieldException {
        this.checkWriteAccess();
        Object object = this.theEventQueue.eventLock;
        synchronized (object) {
            SFImageWrapper sFImageWrapper = (SFImageWrapper)this.theEventQueue.getLast(this);
            if (sFImageWrapper == null || !sFImageWrapper.isSetOneValue) {
                if (!this.storedInput && !this.storedOutput) {
                    sFImageWrapper = this;
                    this.loadInputValue();
                    this.isSetOneValue = true;
                } else {
                    sFImageWrapper = new SFImageWrapper(this.theNode, this.fieldIndex, this.theEventQueue, this.theEventAdapterFactory);
                }
            }
            sFImageWrapper.loadInputValue();
            ColorModel colorModel = renderedImage.getColorModel();
            if (sFImageWrapper.getComponents() != colorModel.getNumComponents() || sFImageWrapper.getWidth() < n || sFImageWrapper.getHeight() < n2) {
                sFImageWrapper.storedInput = false;
                throw new IllegalArgumentException("Subimage either too large or differs in components");
            }
            SFImageWrapper.convertSubRenderedImageToData(renderedImage, sFImageWrapper.storedInputValue, 0, n, n2, n3, n4, n5, n6);
            this.theEventQueue.processEvent(sFImageWrapper);
        }
    }

    public void setValue(int n, int n2, int n3, int[] nArray) {
        if (n < 0) {
            throw new IllegalArgumentException("Invalid width");
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("Invalid height");
        }
        if (n3 < 0) {
            throw new IllegalArgumentException("Invalid components");
        }
        this.checkWriteAccess();
        SFImageWrapper sFImageWrapper = this;
        if (this.storedInput || this.storedOutput) {
            sFImageWrapper = new SFImageWrapper(this.theNode, this.fieldIndex, this.theEventQueue, this.theEventAdapterFactory);
        }
        sFImageWrapper.storedInput = true;
        if (sFImageWrapper.storedInputValue == null || sFImageWrapper.storedInputValue.length != n * n2 + 3) {
            sFImageWrapper.storedInputValue = new int[n * n2 + 3];
        }
        if (sFImageWrapper.storedInputValue.length > 3) {
            System.arraycopy(nArray, 0, sFImageWrapper.storedInputValue, 3, n * n2);
        }
        sFImageWrapper.storedInputValue[0] = n;
        sFImageWrapper.storedInputValue[1] = n2;
        sFImageWrapper.storedInputValue[2] = n3;
        this.theEventQueue.processEvent(sFImageWrapper);
    }

    static void convertRenderedImageToData(RenderedImage renderedImage, int[] nArray, int n) {
        int n2 = renderedImage.getHeight();
        int n3 = renderedImage.getWidth();
        int n4 = renderedImage.getColorModel().getNumComponents();
        DataBuffer dataBuffer = renderedImage.getData().getDataBuffer();
        System.out.println("imgData.size:" + dataBuffer.getSize());
        ColorModel colorModel = renderedImage.getColorModel();
        nArray[n] = n2;
        nArray[1 + n] = n3;
        nArray[2 + n] = n4;
        System.out.println("# components:" + n4);
        System.out.println("Color model:" + renderedImage.getColorModel());
        System.out.println("Is default color model:" + renderedImage.getColorModel().equals(ColorModel.getRGBdefault()));
        boolean bl = false;
        int n5 = bl ? n + 3 - 1 + n2 * n3 : n + 3;
        switch (n4) {
            case 1: {
                for (int i = 0; i < dataBuffer.getSize(); ++i) {
                    if (bl) {
                        nArray[n5--] = dataBuffer.getElem(i);
                        continue;
                    }
                    nArray[n5++] = dataBuffer.getElem(i);
                }
                break;
            }
            case 2: {
                for (int i = 0; i < dataBuffer.getSize(); ++i) {
                    if (bl) {
                        nArray[n5--] = colorModel.getAlpha(dataBuffer.getElem(i)) << 8 + colorModel.getRed(dataBuffer.getElem(i));
                        continue;
                    }
                    nArray[n5++] = colorModel.getAlpha(dataBuffer.getElem(i)) << 8 + colorModel.getRed(dataBuffer.getElem(i));
                }
                break;
            }
            case 3: {
                for (int i = 0; i < dataBuffer.getSize(); ++i) {
                    if (bl) {
                        nArray[n5--] = colorModel.getRGB(dataBuffer.getElem(i));
                        continue;
                    }
                    nArray[n5++] = colorModel.getRGB(dataBuffer.getElem(i));
                }
                break;
            }
            case 4: {
                for (int i = 0; i < dataBuffer.getSize(); ++i) {
                    if (bl) {
                        nArray[n5--] = colorModel.getAlpha(dataBuffer.getElem(i)) << 24 + colorModel.getRGB(dataBuffer.getElem(i));
                        continue;
                    }
                    nArray[n5++] = colorModel.getAlpha(dataBuffer.getElem(i)) << 24 + colorModel.getRGB(dataBuffer.getElem(i));
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("No idea how to deal with " + n4 + " components in an image.");
            }
        }
    }

    static void convertSubRenderedImageToData(RenderedImage renderedImage, int[] nArray, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        int n8 = nArray[n];
        int n9 = nArray[n + 1];
        int n10 = nArray[n + 2];
        ColorModel colorModel = renderedImage.getColorModel();
        if (n2 + n6 > n8 || n3 + n7 > n9) {
            throw new IllegalArgumentException("Exceeds bounds of destination");
        }
        if (n2 + n4 > renderedImage.getWidth() || n3 + n5 > renderedImage.getHeight()) {
            throw new IllegalArgumentException("Exceeds bounds of source");
        }
        int n11 = n8 * n7 + n6 + 3 + n;
        int n12 = renderedImage.getWidth() * n5 + n4;
        int[] nArray2 = new int[1];
        for (int i = 0; i < n3; ++i) {
            for (int j = 0; j < n2; ++j) {
                renderedImage.getData().getPixel(j + n4, i + n5, nArray2);
                int n13 = nArray2[0];
                switch (n10) {
                    case 1: {
                        n13 = colorModel.getAlpha(n13);
                        break;
                    }
                    case 2: {
                        n13 = colorModel.getAlpha(n13) << 8 + colorModel.getRed(n13);
                        break;
                    }
                    case 3: {
                        n13 = colorModel.getRGB(n13);
                        break;
                    }
                    case 4: {
                        n13 = colorModel.getAlpha(n13) << 24 + colorModel.getRGB(n13);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("No idea how to deal with " + n10 + " components in an image.");
                    }
                }
                nArray[3 + n11 + i] = n13;
            }
            n11 += n8;
        }
    }
}

