/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.scripting.external.sai;

import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.scripting.external.buffer.ExternalEvent;
import org.web3d.vrml.scripting.external.buffer.ExternalEventQueue;
import org.web3d.vrml.scripting.external.buffer.ExternalOutputBuffer;
import org.web3d.vrml.scripting.external.sai.BaseFieldWrapper;
import org.web3d.vrml.scripting.external.sai.SAIEventAdapterFactory;
import org.web3d.vrml.scripting.external.sai.SAINodeFactory;
import org.web3d.x3d.sai.InvalidNodeException;
import org.web3d.x3d.sai.SFNode;
import org.web3d.x3d.sai.X3DNode;

class SFNodeWrapper
extends BaseFieldWrapper
implements SFNode,
ExternalEvent,
ExternalOutputBuffer {
    SAINodeFactory nodeFactory;
    VRMLNodeType storedInputValue;
    X3DNode storedOutputValue;

    SFNodeWrapper(VRMLNodeType vRMLNodeType, int n, ExternalEventQueue externalEventQueue, SAINodeFactory sAINodeFactory, SAIEventAdapterFactory sAIEventAdapterFactory) {
        super(vRMLNodeType, n, externalEventQueue, sAIEventAdapterFactory);
        this.nodeFactory = sAINodeFactory;
    }

    SFNodeWrapper(VRMLNodeType vRMLNodeType, int n, ExternalEventQueue externalEventQueue, SAINodeFactory sAINodeFactory, SAIEventAdapterFactory sAIEventAdapterFactory, boolean bl) {
        this(vRMLNodeType, n, externalEventQueue, sAINodeFactory, sAIEventAdapterFactory);
        if (bl) {
            this.loadInputValue();
        } else {
            this.loadOutputValue();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doEvent() {
        try {
            this.theNode.setValue(this.fieldIndex, this.storedInputValue);
        }
        finally {
            this.storedInputValue = null;
            this.storedInput = false;
        }
    }

    public X3DNode getValue() {
        if (this.storedOutput) {
            return this.storedOutputValue;
        }
        this.checkReadAccess();
        VRMLFieldData vRMLFieldData = this.theNode.getFieldValue(this.fieldIndex);
        return this.nodeFactory.getSAINode((VRMLNodeType)vRMLFieldData.nodeValue);
    }

    public void initialize(VRMLNodeType vRMLNodeType, int n) {
        this.theNode = vRMLNodeType;
        this.fieldIndex = n;
    }

    public boolean isConglomerating() {
        return false;
    }

    private void loadInputValue() {
        VRMLFieldData vRMLFieldData = this.theNode.getFieldValue(this.fieldIndex);
        this.storedInputValue = (VRMLNodeType)vRMLFieldData.nodeValue;
        this.storedInput = true;
    }

    public void loadOutputValue() {
        VRMLFieldData vRMLFieldData = this.theNode.getFieldValue(this.fieldIndex);
        this.storedOutputValue = this.nodeFactory.getSAINode((VRMLNodeType)vRMLFieldData.nodeValue);
        this.storedOutput = true;
    }

    public void reset() {
        this.theNode = null;
        this.fieldIndex = -1;
        this.storedOutput = false;
        this.storedOutputValue = null;
    }

    public void setValue(X3DNode x3DNode) throws InvalidNodeException {
        this.checkWriteAccess();
        SFNodeWrapper sFNodeWrapper = this;
        VRMLNodeType vRMLNodeType = this.nodeFactory.getVRMLNode(x3DNode);
        if (vRMLNodeType != null) {
            this.theEventQueue.postRealizeNode(vRMLNodeType);
        }
        if (this.storedInput || this.storedOutput) {
            sFNodeWrapper = new SFNodeWrapper(this.theNode, this.fieldIndex, this.theEventQueue, this.nodeFactory, this.theEventAdapterFactory);
        }
        sFNodeWrapper.storedInput = true;
        sFNodeWrapper.storedInputValue = vRMLNodeType;
        this.theEventQueue.processEvent(sFNodeWrapper);
    }
}

