/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.x3d.jaxp;

import org.web3d.util.DefaultErrorReporter;
import org.web3d.util.ErrorReporter;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class X3DErrorHandler
implements ErrorHandler {
    private ErrorReporter errorReporter = DefaultErrorReporter.getDefaultReporter();

    public void warning(SAXParseException sAXParseException) throws SAXException {
        String string = this.getParseExceptionInfo(sAXParseException);
        this.errorReporter.warningReport(string, (Exception)sAXParseException);
    }

    public void error(SAXParseException sAXParseException) throws SAXException {
        String string = this.getParseExceptionInfo(sAXParseException);
        this.errorReporter.errorReport(string, (Exception)sAXParseException);
        throw new SAXException(string);
    }

    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        String string = this.getParseExceptionInfo(sAXParseException);
        this.errorReporter.fatalErrorReport(string, (Exception)sAXParseException);
        throw new SAXException(string);
    }

    public void setErrorReporter(ErrorReporter errorReporter) {
        this.errorReporter = errorReporter;
        if (errorReporter == null) {
            this.errorReporter = DefaultErrorReporter.getDefaultReporter();
        }
    }

    private String getParseExceptionInfo(SAXParseException sAXParseException) {
        String string = sAXParseException.getSystemId();
        if (string == null) {
            string = "null";
        }
        String string2 = "URI=" + string + " Line=" + sAXParseException.getLineNumber() + ": " + sAXParseException.getMessage();
        return string2;
    }
}

